///////////////////////////////
//  Makumba, Makumba tag library
//  Copyright (C) 2000-2003  http://www.makumba.org
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//  -------------
//  $Id: Query.java,v 2.0 2003/05/20 23:00:05 cristi Exp $
//  $Name: makumba-0_5_10_4 $
/////////////////////////////////////

package org.makumba.db;
import org.makumba.*;
import java.util.*;

/** A query prepared for execution. Returns all its results at once, in a Vector */
public interface Query
{
  /** Execute the query with the given arguments */
  public Vector execute(Object [] args);

  /** Get the data type returned by the query, as given by its SELECT section */
  public DataDefinition getResultType();

  /** Get the data type of the given label */
  public DataDefinition getLabelType(String label);
}
