/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.makumba.DBError;
import org.makumba.db.DBConnection;
import org.makumba.db.Database;

public class SQLDBConnection
extends DBConnection {
    static int nconn = 0;
    int n = nconn++;
    private Connection conn;

    private final void makeConnection() throws SQLException {
        this.conn = DriverManager.getConnection(((org.makumba.db.sql.Database)this.db).url, ((org.makumba.db.sql.Database)this.db).connectionConfig);
        if (this.conn.getMetaData().supportsTransactions()) {
            this.conn.setAutoCommit(false);
        }
        if (this.conn.getMetaData().supportsTransactionIsolationLevel(4)) {
            this.conn.setTransactionIsolation(4);
        }
    }

    public void commit() {
        try {
            this.conn.commit();
        }
        catch (SQLException sQLException) {
            org.makumba.db.sql.Database.logException(sQLException, this);
            throw new DBError(sQLException);
        }
    }

    public void rollback() {
        try {
            this.conn.rollback();
        }
        catch (SQLException sQLException) {
            org.makumba.db.sql.Database.logException(sQLException, this);
            throw new DBError(sQLException);
        }
    }

    private final Connection getConnection() throws SQLException {
        return this.conn;
    }

    public String toString() {
        return "connection " + this.n;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    public Statement createStatement() throws SQLException {
        return this.getConnection().createStatement();
    }

    PreparedStatement getPreparedStatement(String string) {
        try {
            return this.getConnection().prepareStatement(string);
        }
        catch (SQLException sQLException) {
            org.makumba.db.sql.Database.logException(sQLException);
            throw new DBError(sQLException);
        }
    }

    SQLDBConnection(Database database) throws SQLException {
        super(database);
        this.makeConnection();
    }
}

