/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.makumba.Database;
import org.makumba.FieldDefinition;
import org.makumba.InvalidFieldTypeException;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.ProgrammerError;
import org.makumba.abstr.FieldInfo;
import org.makumba.abstr.RecordInfo;
import org.makumba.db.DataHolder;
import org.makumba.db.Query;
import org.makumba.db.Table;
import org.makumba.db.Update;
import org.makumba.util.NamedResourceFactory;
import org.makumba.util.NamedResources;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class DBConnection
implements Database {
    protected org.makumba.db.Database db;
    NamedResources queries;
    NamedResources updates;
    Map locks;
    Hashtable lockRecord;

    public org.makumba.db.Database getHostDatabase() {
        return this.db;
    }

    public String getName() {
        return this.db.getName();
    }

    public abstract void close();

    public abstract void commit();

    public abstract void rollback();

    public void lock(String string) {
        this.lockRecord.clear();
        this.lockRecord.put("name", string);
        this.locks.put(string, this.insert("org.makumba.db.Lock", this.lockRecord));
    }

    public void unlock(String string) {
        Pointer pointer = (Pointer)this.locks.get(string);
        if (pointer == null) {
            throw new ProgrammerError(string + " not locked in connection " + this);
        }
        this.deleteLock(string);
    }

    protected void deleteLock(String string) {
        this.locks.remove(string);
        this.delete("org.makumba.db.Lock l", "l.name=$1", string);
    }

    protected void unlockAll() {
        Iterator iterator = this.locks.keySet().iterator();
        while (iterator.hasNext()) {
            this.deleteLock((String)iterator.next());
        }
    }

    public void update(Pointer pointer, Dictionary dictionary) {
        DataHolder dataHolder = new DataHolder(this, dictionary, pointer.getType());
        dataHolder.checkUpdate();
        dataHolder.update(pointer);
    }

    public Dictionary read(Pointer pointer, Object object) {
        Object object2;
        Object[] objectArray;
        Object object3;
        Serializable serializable;
        Enumeration enumeration = null;
        if (object == null) {
            serializable = RecordInfo.getRecordInfo(pointer.getType());
            object3 = new Vector();
            objectArray = ((RecordInfo)serializable).getFieldNames().elements();
            while (objectArray.hasMoreElements()) {
                object2 = (String)objectArray.nextElement();
                if (((RecordInfo)serializable).getKeyIndex().get(object2) == null) continue;
                ((Vector)object3).addElement(object2);
            }
            enumeration = ((Vector)object3).elements();
        } else if (object instanceof Vector) {
            enumeration = ((Vector)object).elements();
        } else if (object instanceof Enumeration) {
            enumeration = (Enumeration)object;
        } else if (object instanceof String[]) {
            serializable = new Vector();
            object3 = (String[])object;
            int n = 0;
            while (n < ((String[])object3).length) {
                ((Vector)serializable).addElement(object3[n]);
                ++n;
            }
            enumeration = ((Vector)serializable).elements();
        } else {
            throw new InvalidValueException("read() argument must be Enumeration, Vector, String[] or null");
        }
        serializable = new StringBuffer();
        ((StringBuffer)serializable).append("SELECT ");
        object3 = "";
        while (enumeration.hasMoreElements()) {
            objectArray = RecordInfo.getRecordInfo(pointer.getType()).checkFieldName(enumeration.nextElement());
            ((StringBuffer)serializable).append((String)object3).append("p.").append((String)objectArray).append(" as ").append((String)objectArray);
            object3 = ",";
        }
        ((StringBuffer)serializable).append(" FROM " + pointer.getType() + " p WHERE p=$1");
        objectArray = new Object[]{pointer};
        object2 = this.executeQuery(((StringBuffer)serializable).toString(), objectArray);
        if (((Vector)object2).size() == 0) {
            return null;
        }
        if (((Vector)object2).size() > 1) {
            throw new MakumbaError("MAKUMBA DATABASE INCOSISTENT: Pointer not unique: " + pointer);
        }
        return (Dictionary)((Vector)object2).elementAt(0);
    }

    public Pointer insert(String string, Dictionary object) {
        Object object2;
        Table table = this.db.getTable(string);
        table.computeInsertHook();
        if (table.insertHook != null) {
            object2 = new Hashtable();
            Enumeration enumeration = ((Dictionary)object).keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                ((Hashtable)object2).put(k, ((Dictionary)object).get(k));
            }
            object = object2;
        }
        if (table.insertHook == null || table.insertHook.transform((Dictionary)object, this)) {
            object2 = new DataHolder(this, (Dictionary)object, string);
            ((DataHolder)object2).checkInsert();
            return ((DataHolder)object2).insert();
        }
        return null;
    }

    Object[] treatParam(Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            Object[] objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        Object[] objectArray = new Object[]{object};
        return objectArray;
    }

    public Vector executeQuery(String string, Object object) {
        return ((Query)this.queries.getResource(string)).execute(this.treatParam(object));
    }

    public int executeUpdate(String string, String string2, String string3, Object object) {
        Object[] objectArray = new Object[]{string, string2, string3};
        return ((Update)this.updates.getResource(objectArray)).execute(this.treatParam(object));
    }

    public Pointer insert(Pointer pointer, String string, Dictionary dictionary) {
        FieldInfo fieldInfo = RecordInfo.getRecordInfo(pointer.getType()).getField(string);
        if (fieldInfo.getType().equals("setComplex")) {
            dictionary.put(fieldInfo.getSubtable().getMainTablePointerName(), pointer);
            return this.insert(fieldInfo.getSubtable().getName(), dictionary);
        }
        throw new InvalidFieldTypeException(fieldInfo, "subset");
    }

    public void delete(Pointer pointer) {
        RecordInfo recordInfo = RecordInfo.getRecordInfo(pointer.getType());
        FieldDefinition fieldDefinition = recordInfo.getParentField();
        if (fieldDefinition != null && fieldDefinition.getType().equals("ptrOne")) {
            this.executeUpdate(fieldDefinition.getDataDefinition().getName() + " this", "this." + fieldDefinition.getName() + "=nil", "this." + fieldDefinition.getName() + "=$1", pointer);
        }
        this.delete1(pointer);
    }

    void delete1(Pointer pointer) {
        Object object;
        RecordInfo recordInfo = RecordInfo.getRecordInfo(pointer.getType());
        Object[] objectArray = new Object[]{pointer};
        Vector<Object> vector = new Vector<Object>();
        Object object2 = recordInfo.getFieldNames().elements();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            if (!recordInfo.getField((String)object).getType().equals("ptrOne")) continue;
            vector.addElement(object);
        }
        if (vector.size() > 0) {
            object2 = this.read(pointer, vector);
            object = ((Dictionary)object2).elements();
            while (object.hasMoreElements()) {
                this.delete1((Pointer)object.nextElement());
            }
        }
        object2 = recordInfo.getFieldNames().elements();
        while (object2.hasMoreElements()) {
            object = recordInfo.getField((String)object2.nextElement());
            if (!((FieldInfo)object).getType().startsWith("set")) continue;
            if (((FieldInfo)object).getType().equals("setComplex")) {
                this.executeUpdate(((FieldInfo)object).getSubtype().getName() + " this", null, "this." + ((FieldInfo)object).getSubtype().getFieldDefinition(3).getName() + "= $1", objectArray);
                continue;
            }
            this.deleteSet(pointer, (FieldInfo)object);
        }
        this.executeUpdate(pointer.getType() + " this", null, "this." + MakumbaSystem.getDataDefinition(pointer.getType()).getIndexPointerFieldName() + "=$1", pointer);
    }

    void deleteSet(Pointer pointer, FieldInfo fieldInfo) {
        this.executeUpdate(fieldInfo.getSubtable().getName() + " this", null, "this." + fieldInfo.getSubtable().getMainTablePointerName() + "=$1", pointer);
    }

    void updateSet(Pointer pointer, String string, Object object) {
        FieldInfo fieldInfo = RecordInfo.getRecordInfo(pointer.getType()).getField(string);
        if (!(fieldInfo.getType().equals("set") || fieldInfo.getType().equals("setintEnum") || fieldInfo.getType().equals("setcharEnum"))) {
            throw new InvalidFieldTypeException(fieldInfo, "set");
        }
        this.deleteSet(pointer, fieldInfo);
        if (object == null || object == Pointer.NullSet || ((Vector)object).size() == 0) {
            return;
        }
        Vector vector = (Vector)object;
        Hashtable<String, Pointer> hashtable = new Hashtable<String, Pointer>(10);
        ((Dictionary)hashtable).put(fieldInfo.getSubtable().getMainTablePointerName(), pointer);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Dictionary)hashtable).put(fieldInfo.getSubtable().getSetMemberFieldName(), (Pointer)enumeration.nextElement());
            this.db.getTable(fieldInfo.getSubtable()).insertRecord(this, hashtable);
        }
    }

    public int update(String string, String string2, String string3, Object object) {
        return this.executeUpdate(string, string2, string3, object);
    }

    public int delete(String string, String string2, Object object) {
        return this.executeUpdate(string, null, string2, object);
    }

    private final /* synthetic */ void this() {
        this.locks = new HashMap(13);
        this.lockRecord = new Hashtable(5);
    }

    protected DBConnection() {
        this.this();
    }

    public DBConnection(org.makumba.db.Database database) {
        this.this();
        this.db = database;
        this.queries = new NamedResources("Database " + this.db.getName() + " per-connection query objects", new NamedResourceFactory(this){
            final /* synthetic */ DBConnection this$0;

            public final Object makeResource(Object object) {
                return this.this$0.db.prepareQueryImpl(this.this$0, (String)object);
            }
            {
                this.this$0 = dBConnection;
            }
        });
        this.updates = new NamedResources("Database " + this.db.getName() + " per-connection update objects", new NamedResourceFactory(this){
            final /* synthetic */ DBConnection this$0;

            public final Object makeResource(Object object) {
                Object[] objectArray = (Object[])object;
                return this.this$0.db.prepareUpdateImpl(this.this$0, (String)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
            }

            protected final Object getHashObject(Object object) {
                Object[] objectArray = (Object[])object;
                return objectArray[0] + "####" + objectArray[1] + "######" + objectArray[2];
            }
            {
                this.this$0 = dBConnection;
            }
        });
    }
}

