/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.tagext.Tag;
import org.makumba.MakumbaSystem;
import org.makumba.util.JspParseData;
import org.makumba.util.NamedResources;
import org.makumba.util.RuntimeWrappedException;
import org.makumba.util.SourceSyntaxPoints;
import org.makumba.util.SyntaxPoint;

public class JspParseData
implements SourceSyntaxPoints.PreprocessorClient {
    private static Pattern JspSystemTagPattern;
    private static Pattern JspTagPattern;
    private static Pattern JspCommentPattern;
    private static Pattern JspScriptletPattern;
    private static Pattern JspIncludePattern;
    private static Pattern JspTagAttributePattern;
    private static Pattern Word;
    private static Pattern TagName;
    private static String[] JspCommentPatternNames;
    private static Pattern[] JspCommentPatterns;
    static int analyzedPages;
    File file;
    JspAnalyzer analyzer;
    SourceSyntaxPoints syntaxPoints;
    Object holder;
    String uri;
    static /* synthetic */ Class class$java$lang$String;

    static String attribute(String string) {
        return "(" + JspParseData.attribute(string, "\"") + '|' + JspParseData.attribute(string, "'") + ')';
    }

    static String attribute(String string, String string2) {
        String string3 = "\\";
        String string4 = string3 + string2;
        String string5 = string3 + string3;
        return string3 + "s*" + string + string3 + "s*=" + string3 + "s*" + string4 + '(' + string5 + ".|[^" + string4 + string5 + "])*?" + string4;
    }

    public synchronized Object getAnalysisResult(Object object) {
        if (this.getSyntaxPoints() == null || !this.getSyntaxPoints().unchanged()) {
            try {
                this.parse(object);
            }
            catch (Error error) {
                this.holder = error;
                throw error;
            }
            catch (RuntimeException runtimeException) {
                this.holder = runtimeException;
                throw runtimeException;
            }
        }
        return this.holder;
    }

    public static JspParseData getParseData(String string, String string2, JspAnalyzer jspAnalyzer) {
        Object[] objectArray = new Object[]{string + string2, jspAnalyzer, string2};
        return (JspParseData)NamedResources.getStaticCache(analyzedPages).getResource(objectArray);
    }

    public SourceSyntaxPoints getSyntaxPoints() {
        return this.syntaxPoints;
    }

    void parse(Object object) {
        long l = new Date().getTime();
        this.syntaxPoints = new SourceSyntaxPoints(this.file, this);
        this.holder = this.analyzer.makeStatusHolder(object);
        this.treatTags(this.syntaxPoints.getContent(), this.analyzer);
        this.holder = this.analyzer.endPage(this.holder);
        MakumbaSystem.getMakumbaLogger("jspparser.time").info("analysis of " + this.uri + " took " + (new Date().getTime() - l) + " ms");
    }

    Map parseAttributes(String string, int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>(13);
        Matcher matcher = JspTagAttributePattern.matcher(string);
        while (matcher.find()) {
            String string2 = string.substring(matcher.start(), matcher.end());
            int n2 = string2.indexOf(61);
            String string3 = string2.substring(0, n2).trim();
            String string4 = string2.substring(n2 + 1).trim();
            char c = string4.charAt(0);
            if (string4.charAt(0) != string4.charAt(string4.length() - 1)) {
                throw new RuntimeException("Properly quoted string expected, found " + string4);
            }
            if (c == '\"') {
                string4 = string4.replaceAll("\\\\\"", "\"");
            } else if (c == '\'') {
                string4 = string4.replaceAll("\\\\'", "'");
            }
            string4 = string4.replaceAll("(\\\\){2}", "\\\\");
            String string5 = string4.substring(1, string4.length() - 1);
            hashMap.put(string3, string5);
            if (n != -1) {
                this.syntaxPoints.addSyntaxPoints(n, n + n2, "JSPTagAttributeName", null);
                this.syntaxPoints.addSyntaxPoints(n + n2, n + n2 + 1, "JSPTagAttributeEquals", null);
                this.syntaxPoints.addSyntaxPoints(n + n2 + 1, n + string.length(), "JSPTagAttributeValue", null);
            }
            Logger logger = MakumbaSystem.getMakumbaLogger("jspparser.tags.attribute");
            logger.finest("< Attribute : " + string2);
            logger.finest("> AttrParse : " + string3 + " = " + string5);
        }
        return hashMap;
    }

    public void treatInclude(int n, String string, SourceSyntaxPoints sourceSyntaxPoints) {
        Map map = this.parseAttributes(string, -1);
        String string2 = (String)map.get("file");
        sourceSyntaxPoints.include(new File(sourceSyntaxPoints.file.getParent(), string2), n, string);
    }

    public Pattern[] getCommentPatterns() {
        return JspCommentPatterns;
    }

    public String[] getCommentPatternNames() {
        return JspCommentPatternNames;
    }

    public Pattern getIncludePattern() {
        return JspIncludePattern;
    }

    public String getIncludePatternName() {
        return "JspInclude";
    }

    void treatTags(String string, JspAnalyzer jspAnalyzer) {
        Matcher matcher = JspTagPattern.matcher(string);
        Matcher matcher2 = JspSystemTagPattern.matcher(string);
        int n = Integer.MAX_VALUE;
        if (matcher.find()) {
            n = matcher.start();
        }
        int n2 = Integer.MAX_VALUE;
        if (matcher2.find()) {
            n2 = matcher2.start();
        }
        do {
            if (n < n2) {
                this.treatTag(matcher, string, jspAnalyzer);
                n = Integer.MAX_VALUE;
                if (!matcher.find()) continue;
                n = matcher.start();
                continue;
            }
            if (n2 >= n) continue;
            this.treatSystemTag(matcher2, string, jspAnalyzer);
            n2 = Integer.MAX_VALUE;
            if (!matcher2.find()) continue;
            n2 = matcher2.start();
        } while (n != Integer.MAX_VALUE || n2 != Integer.MAX_VALUE);
    }

    void treatTag(Matcher matcher, String string, JspAnalyzer jspAnalyzer) {
        Logger logger;
        String string2 = string.substring(matcher.start(), matcher.end());
        boolean bl = string2.startsWith("</");
        boolean bl2 = string2.endsWith("/>");
        Matcher matcher2 = TagName.matcher(string2);
        matcher2.find();
        this.syntaxPoints.addSyntaxPoints(matcher.start() + matcher2.start(), matcher.start() + matcher2.end(), "JSPTagName", null);
        String string3 = bl ? "JspTagEnd" : (bl2 ? "JspTagSimple" : "JspTagBegin");
        SyntaxPoint.End end = this.syntaxPoints.addSyntaxPoints(matcher.start(), matcher.end(), string3, null);
        SyntaxPoint syntaxPoint = (SyntaxPoint)((SyntaxPoint)end).getOtherInfo();
        String string4 = string2.substring(matcher2.start(), matcher2.end());
        TagData tagData = null;
        tagData = new TagData();
        tagData.name = string4;
        tagData.parseData = this;
        tagData.start = syntaxPoint;
        tagData.end = end;
        if (!bl) {
            tagData.attributes = this.parseAttributes(string2, matcher.start());
        }
        if ((logger = MakumbaSystem.getMakumbaLogger("jspparser.tags")).isLoggable(Level.FINE)) {
            logger.fine(this.uri + ':' + syntaxPoint.line + ':' + syntaxPoint.column + ": " + (bl ? "/" + string4 : tagData.name + ' ' + tagData.attributes));
        }
        if (bl) {
            jspAnalyzer.endTag(tagData, this.holder);
            return;
        }
        if (bl2) {
            jspAnalyzer.simpleTag(tagData, this.holder);
        } else {
            jspAnalyzer.startTag(tagData, this.holder);
        }
    }

    void treatSystemTag(Matcher matcher, String string, JspAnalyzer jspAnalyzer) {
        String string2 = string.substring(matcher.start(), matcher.end());
        SyntaxPoint.End end = this.syntaxPoints.addSyntaxPoints(matcher.start(), matcher.end(), "JSPSystemTag", null);
        Matcher matcher2 = Word.matcher(string2);
        matcher2.find();
        this.syntaxPoints.addSyntaxPoints(matcher.start() + matcher2.start(), matcher.start() + matcher2.end(), "JSPSystemTagName", null);
        SyntaxPoint syntaxPoint = (SyntaxPoint)((SyntaxPoint)end).getOtherInfo();
        TagData tagData = new TagData();
        tagData.name = string2.substring(matcher2.start(), matcher2.end());
        tagData.parseData = this;
        tagData.attributes = this.parseAttributes(string2, matcher.start());
        tagData.start = syntaxPoint;
        tagData.end = end;
        Logger logger = MakumbaSystem.getMakumbaLogger("jspparser.tags");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.uri + ':' + syntaxPoint.line + ':' + syntaxPoint.column + ": " + tagData.name + ' ' + tagData.attributes);
        }
        jspAnalyzer.systemTag(tagData, this.holder);
    }

    public static void tagDataLine(TagData tagData, StringBuffer stringBuffer) {
        stringBuffer.append(tagData.start.getLine()).append(":\n").append(tagData.parseData.getSyntaxPoints().getLineText(tagData.start.getLine())).append('\n');
        int n = 1;
        while (n < tagData.start.getColumn()) {
            stringBuffer.append(' ');
            ++n;
        }
        stringBuffer.append('^');
    }

    public static void fill(Tag tag, Map map) {
        Class<?> clazz = tag.getClass();
        Class[] classArray = new Class[1];
        Class clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = JspParseData.class$("[Ljava.lang.String;", false);
        }
        classArray[0] = clazz2;
        Class[] classArray2 = classArray;
        Object[] objectArray = new Object[1];
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
            try {
                Method method = clazz.getMethod(string2, classArray2);
                objectArray[0] = entry.getValue();
                method.invoke((Object)tag, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.println("error invoking method " + string2 + " on object of class " + clazz.getName() + " with argument " + objectArray[0]);
                throw new RuntimeWrappedException(invocationTargetException.getTargetException());
            }
            catch (Throwable throwable) {
                System.out.println("error invoking method " + string2 + " on object of class " + clazz.getName() + " with argument " + objectArray[0]);
                throw new RuntimeWrappedException(throwable);
            }
        }
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private JspParseData(String string, JspAnalyzer jspAnalyzer, String string2) {
        this.file = new File(string);
        this.uri = string2;
        this.analyzer = jspAnalyzer;
    }

    static {
        JspCommentPatternNames = new String[]{"JspComment", "JspScriptlet"};
        analyzedPages = NamedResources.makeStaticCache("JSP mak:list root tags", new 1());
        String string = JspParseData.attribute("\\w+");
        try {
            JspTagAttributePattern = Pattern.compile(string);
            JspSystemTagPattern = Pattern.compile("<%@\\s*\\w+(" + string + ")*\\s*%>");
            JspIncludePattern = Pattern.compile("<%@\\s*include" + JspParseData.attribute("file") + "\\s*%>");
            JspTagPattern = Pattern.compile("<((\\s*\\w+:\\w+(" + string + ")*\\s*)/?|(/\\w+:\\w+\\s*))>");
            JspCommentPattern = Pattern.compile("<%--.*?[^-]--%>", 32);
            JspScriptletPattern = Pattern.compile("<%[^@].*?%>", 32);
            Pattern[] patternArray = new Pattern[]{JspCommentPattern, JspScriptletPattern};
            JspCommentPatterns = patternArray;
            Word = Pattern.compile("\\w+");
            TagName = Pattern.compile("\\w+:\\w+");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public class TagData {
        JspParseData parseData;
        public String name;
        public Map attributes;
        public Object tagObject;
        SyntaxPoint start;
        SyntaxPoint end;
    }

    public static interface JspAnalyzer {
        public Object makeStatusHolder(Object var1);

        public void startTag(TagData var1, Object var2);

        public void endTag(TagData var1, Object var2);

        public void simpleTag(TagData var1, Object var2);

        public void systemTag(TagData var1, Object var2);

        public Object endPage(Object var1);
    }
}

