///////////////////////////////
//  Makumba, Makumba tag library
//  Copyright (C) 2000-2003  http://www.makumba.org
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//  -------------
//  $Id: charParser.java,v 2.1 2003/10/04 15:01:10 stefan Exp $
//  $Name: makumba-0_5_11 $
/////////////////////////////////////

package org.makumba.abstr;

public class charParser extends FieldParser
{
  public FieldParser parse(FieldCursor fc) 
  {
    if(!fc.lookup("{"))
    {
      fc.expect("[");
      Integer size=fc.expectInteger();
      if(size.intValue()>255 || size.intValue()<0)
	throw fc.fail("char size must be between 0 and 255, not "+size.toString());
      fi.extra2= size;
      fc.expect("]");
      fi.description= fc.lookupDescription();
      return this;
    }
      
    return setType("charEnum", fc);
  }
}
