/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import org.makumba.DBError;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaSystem;
import org.makumba.OQLAnalyzer;
import org.makumba.abstr.RecordInfo;
import org.makumba.db.DBConnection;
import org.makumba.db.Database;
import org.makumba.db.sql.ParameterAssigner;
import org.makumba.db.sql.RecordManager;
import org.makumba.db.sql.SQLDBConnection;
import org.makumba.db.sql.oql.QueryAST;
import org.makumba.util.ArrayMap;

public class Query
implements org.makumba.db.Query {
    String query;
    RecordManager resultHandler;
    String command;
    ParameterAssigner assigner;

    public String getCommand() {
        return this.command;
    }

    public Vector execute(Object[] objectArray, DBConnection dBConnection) {
        PreparedStatement preparedStatement = ((SQLDBConnection)dBConnection).getPreparedStatement(this.command);
        try {
            String string = this.assigner.assignParameters(preparedStatement, objectArray);
            if (string != null) {
                throw new InvalidValueException("Errors while trying to assign arguments to query:\n" + this.command + '\n' + string);
            }
            MakumbaSystem.getMakumbaLogger("db.query.execution").fine("" + preparedStatement);
            Date date = new Date();
            ResultSet resultSet = null;
            try {
                resultSet = preparedStatement.executeQuery();
            }
            catch (SQLException sQLException) {
                org.makumba.db.sql.Database.logException(sQLException, dBConnection);
                throw new DBError(sQLException, this.command);
            }
            long l = new Date().getTime() - date.getTime();
            MakumbaSystem.getMakumbaLogger("db.query.performance").fine(l + " ms " + this.command);
            return this.goThru(resultSet, this.resultHandler);
        }
        catch (SQLException sQLException) {
            throw new DBError(sQLException);
        }
    }

    Vector goThru(ResultSet resultSet, RecordManager recordManager) {
        int n = recordManager.keyIndex.size();
        Vector<ArrayMap> vector = new Vector<ArrayMap>(100, 100);
        try {
            while (resultSet.next()) {
                Object[] objectArray = new Object[n];
                recordManager.fillResult(resultSet, objectArray);
                vector.addElement(new ArrayMap(recordManager.keyIndex, objectArray));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new DBError(sQLException, recordManager.getRecordInfo().getName());
        }
        return vector;
    }

    public Query(Database database, String string) {
        this(database, MakumbaSystem.getOQLAnalyzer(string));
    }

    public Query(Database database, OQLAnalyzer oQLAnalyzer) {
        this.command = ((QueryAST)oQLAnalyzer).writeInSQLQuery(database);
        this.resultHandler = (RecordManager)database.makePseudoTable((RecordInfo)oQLAnalyzer.getProjectionType());
        this.assigner = new ParameterAssigner(database, oQLAnalyzer);
    }
}

