/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.controller.http;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.makumba.AttributeNotFoundException;
import org.makumba.DataDefinition;
import org.makumba.InvalidValueException;
import org.makumba.LogicException;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.controller.Logic;
import org.makumba.controller.http.ControllerFilter;
import org.makumba.controller.http.RequestAttributes;
import org.makumba.controller.http.Responder;
import org.makumba.controller.http.ResponderOp;
import org.makumba.util.NamedResources;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Responder
implements Serializable {
    public static final String responderName = "__makumba__responder__";
    public static final String anonymousResult = "___mak___edited___";
    public static final String defaultMessage = "changes done";
    public static final String basePointerName = "__makumba__base__";
    static Hashtable indexedCache = new Hashtable();
    static NamedResources cache = new NamedResources("controller.responders", new 1());
    static final char suffixSeparator = '_';
    static Integer ZERO = new Integer(0);
    static Comparator bySuffix = new 2();
    public static final String RESPONSE_STRING_NAME = "makumba.response";
    static final String resultNamePrefix = "org.makumba.controller.resultOf_";
    static Hashtable responderOps = new Hashtable();
    protected int identity;
    protected Object controller;
    protected String database;
    protected String message;
    protected String resultAttribute;
    protected String handler;
    protected String basePointerType;
    protected String newType;
    protected String addField;
    protected String operation;
    protected ResponderOp op;
    transient int groupCounter;
    protected transient String storedSuffix;
    protected transient String storedParentSuffix;

    public void setHttpRequest(HttpServletRequest httpServletRequest) throws LogicException {
        this.controller = RequestAttributes.getAttributes(httpServletRequest).getRequestController();
        this.database = RequestAttributes.getAttributes(httpServletRequest).getRequestDatabase();
    }

    public void setOperation(String string) {
        this.operation = string;
        this.op = (ResponderOp)responderOps.get(string);
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setHandler(String string) {
        this.handler = string;
    }

    public void setBasePointerType(String string) {
        this.basePointerType = string;
    }

    public void setResultAttribute(String string) {
        this.resultAttribute = string;
    }

    public void setAddField(String string) {
        this.addField = string;
    }

    public void setNewType(DataDefinition dataDefinition) {
        this.newType = dataDefinition.getName();
    }

    public String responderKey() {
        return this.basePointerType + this.message + this.resultAttribute + this.database + this.operation + this.controller.getClass().getName() + this.handler + this.addField + this.newType;
    }

    public int getPrototype() {
        String string = this.op.verify(this);
        if (string != null) {
            throw new MakumbaError("Bad responder configuration " + string);
        }
        return ((Responder)Responder.cache.getResource((Object)this)).identity;
    }

    public void setParentResponder(Responder responder, Responder responder2) {
        this.storedSuffix = "_" + ++responder2.groupCounter;
        this.storedParentSuffix = responder.storedSuffix;
    }

    public String getSuffix() {
        return this.storedSuffix;
    }

    static Integer suffix(String string) {
        int n = string.indexOf(95);
        if (n == -1) {
            return ZERO;
        }
        if ((n = (string = string.substring(n + 1)).indexOf(95)) != -1) {
            string = string.substring(0, n);
        }
        return new Integer(Integer.parseInt(string));
    }

    static Iterator getResponderCodes(HttpServletRequest httpServletRequest) {
        TreeSet<Object> treeSet = new TreeSet<Object>(bySuffix);
        Object object = RequestAttributes.getParameters(httpServletRequest).getParameter(responderName);
        if (object != null) {
            if (object instanceof String) {
                treeSet.add(object);
            } else {
                treeSet.addAll((Vector)object);
            }
        }
        return treeSet.iterator();
    }

    static void response(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (httpServletRequest.getAttribute(RESPONSE_STRING_NAME) != null) {
            return;
        }
        httpServletRequest.setAttribute(RESPONSE_STRING_NAME, (Object)"");
        String string = "";
        Iterator iterator = Responder.getResponderCodes(httpServletRequest);
        while (iterator.hasNext()) {
            Integer n;
            Responder responder;
            String string2;
            String string3 = string2 = (String)iterator.next();
            String string4 = "";
            String string5 = null;
            int n2 = string2.indexOf(95);
            if (n2 != -1) {
                string3 = string2.substring(0, n2);
                string4 = string2.substring(n2);
                string5 = "";
                n2 = string4.indexOf(95, 1);
                if (n2 != -1) {
                    string5 = string4.substring(n2);
                    string4 = string4.substring(0, n2);
                }
            }
            if ((responder = (Responder)indexedCache.get(n = new Integer(Integer.parseInt(string3)))) == null) {
                throw new InvalidValueException("Responder cannot be found, probably due to server restart. Please reload the form page.");
            }
            try {
                Object object = responder.op.respondTo(httpServletRequest, responder, string4, string5);
                string = "<font color=green>" + responder.message + "</font>";
                if (object != null) {
                    httpServletRequest.setAttribute(responder.resultAttribute, object);
                    httpServletRequest.setAttribute(resultNamePrefix + string4, object);
                }
                httpServletRequest.setAttribute("makumba.successfulResponse", (Object)"yes");
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                ControllerFilter.treatException(attributeNotFoundException, httpServletRequest, httpServletResponse);
                continue;
            }
            catch (LogicException logicException) {
                MakumbaSystem.getLogger("logic.error").log(Level.INFO, "error", logicException);
                string = Responder.errorMessage(logicException);
                httpServletRequest.setAttribute(responder.resultAttribute, Pointer.Null);
                httpServletRequest.setAttribute(resultNamePrefix + string4, Pointer.Null);
            }
            catch (Throwable throwable) {
                ControllerFilter.treatException(throwable, httpServletRequest, httpServletResponse);
            }
            if (!string4.equals("")) continue;
            httpServletRequest.setAttribute(RESPONSE_STRING_NAME, (Object)string);
        }
    }

    public static String errorMessage(Throwable throwable) {
        return "<font color=red>" + throwable.getMessage() + "</font>";
    }

    public Pointer getHttpBasePointer(HttpServletRequest httpServletRequest, String string) {
        return new Pointer(this.basePointerType, (String)RequestAttributes.getParameters(httpServletRequest).getParameter(basePointerName + string));
    }

    public abstract Dictionary getHttpData(HttpServletRequest var1, String var2);

    private final /* synthetic */ void this() {
        this.message = defaultMessage;
        this.resultAttribute = anonymousResult;
        this.groupCounter = 0;
        this.storedSuffix = "";
        this.storedParentSuffix = "";
    }

    public Responder() {
        this.this();
    }

    static {
        responderOps.put("edit", new ResponderOp(){

            public final Object respondTo(HttpServletRequest httpServletRequest, Responder responder, String string, String string2) throws LogicException {
                return Logic.doEdit(responder.controller, responder.basePointerType, responder.getHttpBasePointer(httpServletRequest, string), responder.getHttpData(httpServletRequest, string), new RequestAttributes(responder.controller, httpServletRequest, responder.database), responder.database, RequestAttributes.getConnectionProvider(httpServletRequest));
            }

            public final String verify(Responder responder) {
                return null;
            }
        });
        responderOps.put("simple", new ResponderOp(){

            public final Object respondTo(HttpServletRequest httpServletRequest, Responder responder, String string, String string2) throws LogicException {
                return Logic.doOp(responder.controller, responder.handler, responder.getHttpData(httpServletRequest, string), new RequestAttributes(responder.controller, httpServletRequest, responder.database), responder.database, RequestAttributes.getConnectionProvider(httpServletRequest));
            }

            public final String verify(Responder responder) {
                return null;
            }
        });
        responderOps.put("new", new ResponderOp(){

            public final Object respondTo(HttpServletRequest httpServletRequest, Responder responder, String string, String string2) throws LogicException {
                return Logic.doNew(responder.controller, responder.newType, responder.getHttpData(httpServletRequest, string), new RequestAttributes(responder.controller, httpServletRequest, responder.database), responder.database, RequestAttributes.getConnectionProvider(httpServletRequest));
            }

            public final String verify(Responder responder) {
                return null;
            }
        });
        responderOps.put("add", new ResponderOp(){

            public final Object respondTo(HttpServletRequest httpServletRequest, Responder responder, String string, String string2) throws LogicException {
                return Logic.doAdd(responder.controller, responder.basePointerType + "->" + responder.addField, responder.getHttpBasePointer(httpServletRequest, string), responder.getHttpData(httpServletRequest, string), new RequestAttributes(responder.controller, httpServletRequest, responder.database), responder.database, RequestAttributes.getConnectionProvider(httpServletRequest));
            }

            public final String verify(Responder responder) {
                return null;
            }
        });
        responderOps.put("addToNew", new ResponderOp(){

            public final Object respondTo(HttpServletRequest httpServletRequest, Responder responder, String string, String string2) throws LogicException {
                return Logic.doAdd(responder.controller, responder.newType + "->" + responder.addField, (Pointer)httpServletRequest.getAttribute("org.makumba.controller.resultOf_" + string2), responder.getHttpData(httpServletRequest, string), new RequestAttributes(responder.controller, httpServletRequest, responder.database), responder.database, RequestAttributes.getConnectionProvider(httpServletRequest));
            }

            public final String verify(Responder responder) {
                return null;
            }
        });
        responderOps.put("delete", new ResponderOp(){

            public final Object respondTo(HttpServletRequest httpServletRequest, Responder responder, String string, String string2) throws LogicException {
                return Logic.doDelete(responder.controller, responder.basePointerType, responder.getHttpBasePointer(httpServletRequest, string), new RequestAttributes(responder.controller, httpServletRequest, responder.database), responder.database, RequestAttributes.getConnectionProvider(httpServletRequest));
            }

            public final String verify(Responder responder) {
                return null;
            }
        });
    }
}

