/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import org.makumba.DBError;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.NotUniqueError;
import org.makumba.OQLAnalyzer;
import org.makumba.OQLParseError;
import org.makumba.db.DBConnection;
import org.makumba.db.Database;
import org.makumba.db.Update;
import org.makumba.db.sql.ParameterAssigner;
import org.makumba.db.sql.SQLDBConnection;
import org.makumba.db.sql.oql.QueryAST;

public class SQLUpdate
implements Update {
    ParameterAssigner assigner;
    String debugString;
    String updateCommand;

    public int execute(DBConnection dBConnection, Object[] objectArray) {
        PreparedStatement preparedStatement = ((SQLDBConnection)dBConnection).getPreparedStatement(this.updateCommand);
        try {
            int n;
            String string = this.assigner.assignParameters(preparedStatement, objectArray);
            if (string != null) {
                throw new InvalidValueException("Errors while trying to assign arguments to update:\n" + this.debugString + '\n' + string);
            }
            MakumbaSystem.getMakumbaLogger("db.update.execution").fine("" + preparedStatement);
            Date date = new Date();
            try {
                n = preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                org.makumba.db.sql.Database cfr_ignored_0 = (org.makumba.db.sql.Database)dBConnection.getHostDatabase();
                if (org.makumba.db.sql.Database.isDuplicateException(sQLException)) {
                    throw new NotUniqueError(sQLException);
                }
                org.makumba.db.sql.Database.logException(sQLException);
                throw new DBError(sQLException, this.debugString);
            }
            long l = new Date().getTime() - date.getTime();
            MakumbaSystem.getMakumbaLogger("db.update.performance").fine(l + " ms " + this.debugString);
            return n;
        }
        catch (SQLException sQLException) {
            throw new DBError(sQLException);
        }
    }

    SQLUpdate(Database database, String string, String string2, String string3) {
        int n;
        String string4;
        OQLAnalyzer oQLAnalyzer;
        String string5;
        this.debugString = (string2 == null ? "delete" : "update") + " on type: <" + string + '>' + (string2 == null ? " " : " setting: <" + string2 + '>') + " where: <" + string3 + '>';
        if (string2 != null && string2.trim().length() == 0) {
            throw new OQLParseError("Invalid empty update 'set' section in " + this.debugString);
        }
        if (string3 != null && string3.trim().length() == 0) {
            string3 = null;
        }
        if (string != null && string.indexOf(44) >= 0) {
            throw new OQLParseError("Only 1 table can be involved in " + this.debugString);
        }
        string = string.replace('\t', ' ');
        try {
            string5 = string.substring(string.trim().indexOf(32) + 1).trim();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new OQLParseError("Invalid delete/update 'type' section: " + string);
        }
        String string6 = "SELECT " + (string2 == null ? string5 : string2) + " FROM " + string;
        if (string3 != null) {
            string6 = string6 + " WHERE " + string3;
        }
        try {
            oQLAnalyzer = MakumbaSystem.getOQLAnalyzer(string6);
            this.assigner = new ParameterAssigner(database, oQLAnalyzer);
        }
        catch (OQLParseError oQLParseError) {
            throw new OQLParseError(oQLParseError.getMessage() + "\r\nin " + this.debugString + '\n' + string6, oQLParseError);
        }
        try {
            string4 = ((QueryAST)oQLAnalyzer).writeInSQLQuery(database);
        }
        catch (RuntimeException runtimeException) {
            throw new MakumbaError(runtimeException, this.debugString + '\n' + string6);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = string4.indexOf(" FROM ");
        while (true) {
            n = n2;
            n2 = string4.indexOf(string5 + '.', n);
            if (n2 == -1 || n2 > n3) break;
            stringBuffer.append(string4.substring(n, n2));
            n2 += string5.length() + 1;
        }
        stringBuffer.append(string4.substring(n, n3));
        n = string4.indexOf(" WHERE ");
        if (n < 0) {
            n = string4.length();
        }
        n2 = string4.lastIndexOf(" " + string5, n);
        stringBuffer.append(string4.substring(n3, n2));
        n2 = n;
        while (true) {
            n = n2;
            n2 = string4.indexOf(string5 + '.', n);
            if (n2 == -1) break;
            stringBuffer.append(string4.substring(n, n2));
            n2 += string5.length() + 1;
        }
        stringBuffer.append(string4.substring(n));
        string4 = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(string2 == null ? "DELETE FROM" : "UPDATE");
        stringBuffer2.append(string4.substring(string4.indexOf(" FROM ") + 5, string4.indexOf(" WHERE ")));
        if (string2 != null) {
            String string7 = string4.substring(string4.indexOf("SELECT ") + 7, string4.indexOf(" FROM "));
            n2 = 0;
            while (true) {
                if ((n2 = string7.indexOf("is null", n2)) == -1) {
                    if ((n2 = string7.indexOf("is  null", n2)) == -1) break;
                    string7 = string7.substring(0, n2) + " = null" + string7.substring(n2 + 8);
                    continue;
                }
                string7 = string7.substring(0, n2) + " = null" + string7.substring(n2 + 7);
            }
            stringBuffer2.append(" SET ").append(string7);
        }
        if (string3 != null) {
            stringBuffer2.append(string4.substring(string4.indexOf(" WHERE ")));
        }
        this.debugString = this.debugString + "\n generated SQL: " + stringBuffer2;
        this.updateCommand = stringBuffer2.toString();
    }
}

