/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.logging.Level;
import org.makumba.MakumbaSystem;
import org.makumba.abstr.RecordParser;
import org.makumba.devel.SourceViewer;
import org.makumba.util.ClassResource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LineViewer
implements SourceViewer {
    String realPath;
    String virtualPath;
    String contextPath;
    Reader reader;
    boolean lineNumbers;
    File dir;
    String title;
    String jspSourceViewExtension;
    StringBuffer highlighted;
    int position;
    char current;
    String text;
    String pattern;

    public File getDirectory() {
        if (this.dir != null && this.dir.isDirectory()) {
            return this.dir;
        }
        return null;
    }

    public Reader getReader() {
        return this.reader;
    }

    void readFromURL(URL uRL) throws IOException {
        if (uRL == null) {
            throw new FileNotFoundException(this.virtualPath);
        }
        this.realPath = uRL.getFile();
        try {
            this.dir = new File(this.realPath);
            if (!this.dir.isDirectory()) {
                this.reader = new InputStreamReader(new FileInputStream(this.dir));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.realPath = null;
            this.reader = new InputStreamReader((InputStream)uRL.getContent());
        }
    }

    public void parseText(PrintWriter printWriter) throws IOException {
        printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        printWriter.println("<html><head>");
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" >");
        if (this.realPath != null && this.virtualPath != null) {
            this.title = this.virtualPath;
        } else if (this.title == null || this.title != null && this.title.equals("")) {
            this.title = "";
        }
        printWriter.println("<title>" + this.title + "</title>");
        if (this.lineNumbers) {
            printWriter.println("<style type=\"text/css\">\n A.lineNo {color:navy; background-color:lightblue; text-decoration:none; cursor:default;}\n</style>");
        }
        printWriter.println("</head><body bgcolor=white><table width=\"100%\" bgcolor=\"lightblue\"><tr><td>");
        if (this.title != null && !this.title.equals("") && !this.title.equals(this.virtualPath)) {
            printWriter.print("<font size=\"+2\"><font color=\"darkblue\">" + this.title + "</font></font>");
        } else if (this.virtualPath != null) {
            printWriter.print("<font size=\"+2\"><a href=\"" + this.virtualPath + "\"><font color=\"darkblue\">" + this.virtualPath + "</font></a></font>");
        }
        if (this.realPath != null) {
            printWriter.print("<font size=\"-1\"><br>" + new File(this.realPath).getCanonicalPath() + "</font>");
        }
        printWriter.print("</td>");
        this.intro(printWriter);
        printWriter.print("</tr></table>\n<pre style=\"margin-top:0\">");
        LineNumberReader lineNumberReader = new LineNumberReader(this.reader);
        String string = null;
        while ((string = lineNumberReader.readLine()) != null) {
            this.parseLine(string);
            if (this.lineNumbers) {
                int n = lineNumberReader.getLineNumber();
                printWriter.print("<a name=\"" + n + "\" href=\"#" + n + "\" class=\"lineNo\">" + n + ":\t</a>");
            }
            this.printLine(printWriter, string);
        }
        printWriter.println("\n</pre>");
        this.footer(printWriter);
        printWriter.println("\n</body></html>");
        this.reader.close();
    }

    void intro(PrintWriter printWriter) throws IOException {
    }

    void footer(PrintWriter printWriter) throws IOException {
        printWriter.println("<hr><font size=\"-1\"><a href=\"http://www.makumba.org\">Makumba</a> developer support, version: " + MakumbaSystem.getVersion() + "</font>");
    }

    void printLine(PrintWriter printWriter, String string) throws IOException {
        String string2 = this.getLineTag(string);
        if (string2 != null) {
            printWriter.print("<a name=\"" + string2 + "\"></a>");
        }
        printWriter.print(this.highlighted);
        printWriter.print("\n");
    }

    String getLineTag(String string) {
        return null;
    }

    void parseLine(String string) {
        this.highlighted = new StringBuffer();
        while (true) {
            int n;
            if ((n = string.indexOf(46)) == -1) {
                this.writeNonMdd(string);
                return;
            }
            int n2 = n;
            int n3 = string.length();
            while (--n2 > 0 && this.isMakumbaTypeChar(string.charAt(n2))) {
            }
            ++n2;
            while (++n < n3 && this.isMakumbaTypeChar(string.charAt(n))) {
            }
            String string2 = string.substring(n2, n);
            if (string2.indexOf("www.makumba.org") != -1) {
                this.writeNonMdd(string.substring(0, n2));
                this.highlighted.append("<a href=\"http://www.makumba.org\">").append(string2).append("</a>");
            } else {
                Class clazz = null;
                String string3 = null;
                URL uRL = null;
                URL uRL2 = null;
                uRL = RecordParser.findDataDefinition(string2, "mdd");
                if (uRL == null && (uRL2 = RecordParser.findDataDefinition(string2, "idd")) == null && (clazz = this.findClass(string2)) == null && (string3 = this.findPage(string2)) == null) {
                    this.writeNonMdd(string.substring(0, n));
                } else {
                    this.writeNonMdd(string.substring(0, n2));
                    if (uRL != null || uRL2 != null) {
                        this.highlighted.append("<a href=\"" + this.contextPath + "/dataDefinitions/").append(string2).append("\">").append(string2).append("</a>");
                    } else if (clazz != null) {
                        this.highlighted.append("<a href=\"" + this.contextPath + "/classes/").append(clazz.getName()).append("\">").append(string2).append("</a>");
                    } else if (string3 != null) {
                        this.highlighted.append("<a href=\"").append(string3);
                        if (string3.endsWith("jsp")) {
                            this.highlighted.append(this.jspSourceViewExtension);
                        }
                        this.highlighted.append("\">").append(string2).append("</a>");
                    }
                }
            }
            if (n == n3) {
                return;
            }
            string = string.substring(n, n3);
        }
    }

    String findPage(String string) {
        return null;
    }

    Class findClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Throwable throwable) {
            return null;
        }
        if (ClassResource.get(clazz.getName().replace('.', '/') + ".java") != null) {
            return clazz;
        }
        return null;
    }

    boolean isMakumbaTypeChar(char c) {
        boolean bl = false;
        if (c == '.' || Character.isJavaIdentifierPart(c) || c == '/' || c == '-') {
            bl = true;
        }
        return bl;
    }

    void writeNonMdd(String string) {
        this.text = string;
        this.position = 0;
        while (this.position < string.length()) {
            this.current = this.text.charAt(this.position);
            this.treat();
            ++this.position;
        }
    }

    void treat() {
        this.htmlEscape();
    }

    void htmlEscape() {
        switch (this.current) {
            case '<': {
                this.highlighted.append("&lt;");
                break;
            }
            case '>': {
                this.highlighted.append("&gt;");
                break;
            }
            case '&': {
                this.highlighted.append("&amp;");
                break;
            }
            default: {
                this.highlighted.append(this.current);
            }
        }
    }

    boolean lookup(String string) {
        int n = string.length();
        try {
            if (this.position + n > this.text.length() || !this.text.substring(this.position, this.position + n).equals(string)) {
                return false;
            }
            this.pattern = string;
            return true;
        }
        catch (RuntimeException runtimeException) {
            MakumbaSystem.getMakumbaLogger("devel").log(Level.SEVERE, "" + this.position + ' ' + n + ' ' + this.text.length(), runtimeException);
            throw runtimeException;
        }
    }

    void advance() {
        this.position += this.pattern.length() - 1;
    }

    private final /* synthetic */ void this() {
        this.jspSourceViewExtension = "x";
    }

    public LineViewer(boolean bl) {
        this.this();
        this.lineNumbers = bl;
    }

    public LineViewer() {
        this(false);
    }

    public LineViewer(Reader reader) {
        this(false);
        this.reader = reader;
    }
}

