/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.makumba.MakumbaSystem;
import org.makumba.abstr.RecordParser;
import org.makumba.devel.SourceViewer;
import org.makumba.util.ClassResource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LineViewer
implements SourceViewer {
    protected static String regExpPossibleLink = "\\w+\\.\\w+[\\.\\w]*";
    Pattern patternUrl;
    protected ServletContext servletContext;
    protected String realPath;
    protected String virtualPath;
    protected String contextPath;
    protected Reader reader;
    protected boolean printLineNumbers;
    private File dir;
    protected String title;
    protected boolean searchJSPPages;
    protected boolean searchCompiledJSPClasses;
    protected boolean searchJavaClasses;
    protected boolean searchMDD;
    protected String jspSourceViewExtension;
    protected String jspClasspath;
    protected HttpServletRequest request;
    protected HttpServlet servlet;
    protected String servletPath;
    protected String logicPath;
    private String[] importedPackages;

    public File getDirectory() {
        if (this.dir != null && this.dir.isDirectory()) {
            return this.dir;
        }
        return null;
    }

    public Reader getReader() {
        return this.reader;
    }

    void readFromURL(URL uRL) throws IOException {
        if (uRL == null) {
            throw new FileNotFoundException(this.virtualPath);
        }
        this.realPath = uRL.getFile();
        try {
            this.dir = new File(this.realPath);
            if (!this.dir.isDirectory()) {
                this.reader = new InputStreamReader(new FileInputStream(this.dir));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.realPath = null;
            this.reader = new InputStreamReader((InputStream)uRL.getContent());
        }
    }

    public void parseText(PrintWriter printWriter) throws IOException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.printPageBegin(printWriter);
        LineNumberReader lineNumberReader = new LineNumberReader(this.reader);
        String string = null;
        while ((string = lineNumberReader.readLine()) != null) {
            if (this.printLineNumbers) {
                int n = lineNumberReader.getLineNumber();
                printWriter.print("<a name=\"" + n + "\" href=\"#" + n + "\" class=\"lineNo\">" + n + ":\t</a>");
            }
            this.printLine(printWriter, string, this.parseLine(this.htmlEscape(string)));
        }
        this.printPageEnd(printWriter);
        this.reader.close();
        double d = new Date(new GregorianCalendar().getTimeInMillis() - gregorianCalendar.getTimeInMillis()).getTime();
        System.out.println("Code viewer took :" + d / 1000.0 + " seconds");
    }

    public void printPageEnd(PrintWriter printWriter) throws IOException {
        printWriter.println("\n</pre>");
        this.footer(printWriter);
        printWriter.println("\n</body></html>");
    }

    public void printPageBegin(PrintWriter printWriter) throws IOException {
        printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        printWriter.println("<html><head>");
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" >");
        if (this.realPath != null && this.virtualPath != null) {
            this.title = this.virtualPath;
        } else if (this.title == null || this.title != null && this.title.equals("")) {
            this.title = "";
        }
        printWriter.println("<title>" + this.title + "</title>");
        if (this.printLineNumbers) {
            printWriter.println("<style type=\"text/css\">\n A.lineNo {color:navy; background-color:lightblue; text-decoration:none; cursor:default;}\n</style>");
        }
        printWriter.println("</head><body bgcolor=white><table width=\"100%\" bgcolor=\"lightblue\"><tr><td rowspan=\"2\">");
        if (this.title != null && !this.title.equals("") && !this.title.equals(this.virtualPath)) {
            printWriter.print("<font size=\"+2\"><font color=\"darkblue\">" + this.title + "</font></font>");
        } else if (this.virtualPath != null) {
            printWriter.print("<font size=\"+2\"><a href=\"" + this.virtualPath + "\"><font color=\"darkblue\">" + this.virtualPath + "</font></a></font>");
        }
        if (this.realPath != null) {
            printWriter.print("<font size=\"-1\"><br>" + new File(this.realPath).getCanonicalPath() + "</font>");
        }
        printWriter.print("</td>");
        this.intro(printWriter);
        printWriter.print("</tr></table>\n<pre style=\"margin-top:0\">");
    }

    public void intro(PrintWriter printWriter) throws IOException {
    }

    public void footer(PrintWriter printWriter) throws IOException {
        printWriter.println("<hr><font size=\"-1\"><a href=\"http://www.makumba.org\">Makumba</a> developer support, version: " + MakumbaSystem.getVersion() + "</font>");
    }

    public void printLine(PrintWriter printWriter, String string, String string2) throws IOException {
        String string3 = this.getLineTag(string);
        if (string3 != null) {
            printWriter.print("<a name=\"" + string3 + "\"></a>");
        }
        printWriter.print(string2);
        printWriter.print("\n");
    }

    public String getLineTag(String string) {
        return null;
    }

    public void setSearchLevels(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.searchJSPPages = bl;
        this.searchCompiledJSPClasses = bl2;
        this.searchJavaClasses = bl3;
        this.searchMDD = bl4;
    }

    public String parseLine(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        Matcher matcher = this.patternUrl.matcher(string);
        while (matcher.find()) {
            String string2;
            String string3;
            String string4;
            Class clazz;
            URL uRL;
            URL uRL2;
            String string5 = matcher.group();
            int n = stringBuffer.indexOf(string5);
            int n2 = n + string5.length();
            stringBuffer2.append(stringBuffer.substring(0, n));
            if (string5.equals("www.makumba.org")) {
                stringBuffer2.append(this.formatMakumbaLink(string5));
            } else if (this.searchMDD && (uRL2 = RecordParser.findDataDefinition(string5, "mdd")) != null || (uRL = RecordParser.findDataDefinition(string5, "idd")) != null) {
                stringBuffer2.append(this.formatMDDLink(string5));
            } else if (this.searchJavaClasses && (clazz = this.findClass(string5)) != null) {
                stringBuffer2.append(this.formatClassLink(clazz.getName(), string5, null));
            } else if (this.searchJavaClasses && (string4 = this.findJDKClass(string5)) != null) {
                stringBuffer2.append(string4);
            } else if (this.searchJSPPages && (string3 = this.findPage(string5)) != null) {
                stringBuffer2.append(this.formatJSPLink(string3, string5, null));
            } else if (this.searchCompiledJSPClasses && (string2 = this.findCompiledJSP(string5)) != null) {
                stringBuffer2.append(this.formatClassLink(string2, string5, null));
            } else {
                stringBuffer2.append(string5);
            }
            stringBuffer.delete(0, n2);
        }
        return stringBuffer2.append(stringBuffer).toString();
    }

    public String formatJSPLink(String string, String string2, Integer n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<a href=\"" + string);
        if (string.endsWith("jsp")) {
            stringBuffer.append(this.jspSourceViewExtension);
        }
        if (n != null) {
            stringBuffer.append("#" + n);
        }
        stringBuffer.append("\">").append(string2).append("</a>");
        return stringBuffer.toString();
    }

    public String formatClassLink(String string, String string2, Integer n) {
        if (n != null) {
            return "<a href=\"" + this.contextPath + "/classes/" + string + '#' + n + "\">" + string2 + "</a>";
        }
        return "<a href=\"" + this.contextPath + "/classes/" + string + "\">" + string2 + "</a>";
    }

    public String formatMDDLink(String string) {
        return "<a href=\"" + this.contextPath + "/dataDefinitions/" + string + "\">" + string + "</a>";
    }

    public String formatMakumbaLink(String string) {
        return "<a href=\"http://www.makumba.org\">" + string + "</a>";
    }

    public StringTokenizer getLineTokenizer(String string) {
        return new StringTokenizer(string, "\"' (){}[]<>,;-?#:", true);
    }

    public String findPage(String string) {
        if (string.startsWith("/")) {
            File file = new File(this.servletContext.getRealPath(string));
            if (file.exists()) {
                return this.contextPath + string;
            }
            file = new File(string);
            if (file.exists()) {
                return string;
            }
            return null;
        }
        File file = new File(this.realPath.substring(0, this.realPath.lastIndexOf(File.separatorChar)) + File.separatorChar + string.replace('/', File.separatorChar));
        if (file.exists()) {
            return string;
        }
        return null;
    }

    public Class findClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Throwable throwable) {
            return null;
        }
        if (ClassResource.get(clazz.getName().replace('.', '/') + ".java") != null) {
            return clazz;
        }
        return null;
    }

    public String findCompiledJSP(String string) {
        if (this.jspClasspath != null && string.indexOf("_jsp") != -1) {
            try {
                String string2 = string.substring(0, string.indexOf("_jsp") + 4);
                String string3 = this.jspClasspath + '/' + string2.replace('.', '/') + ".java";
                File file = new File(string3);
                if (file.exists()) {
                    return string2;
                }
                return null;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return null;
    }

    public String htmlEscape(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        return string;
    }

    public String findJDKClass(String string) {
        Class<?> clazz = null;
        int n = 0;
        while (n < this.importedPackages.length) {
            try {
                clazz = Class.forName(this.importedPackages[n] + string);
                break;
            }
            catch (Throwable throwable) {
                ++n;
            }
        }
        if (clazz != null && clazz.getName().startsWith("java")) {
            return "<a href=\"http://java.sun.com/j2se/1.4.2/docs/api/" + clazz.getName().replaceAll("\\.", "/") + ".html\">" + clazz.getName() + "</a>";
        }
        String string2 = string.substring(0, string.lastIndexOf("."));
        String string3 = string.substring(string.lastIndexOf(".") + 1);
        try {
            int n2 = 0;
            if (n2 < this.importedPackages.length) {
                clazz = Class.forName(this.importedPackages[n2] + string2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (clazz != null && clazz.getName().startsWith("java")) {
            return "<a href=\"http://java.sun.com/j2se/1.4.2/docs/api/" + clazz.getName().replaceAll("\\.", "/") + ".html#" + string3 + "()\">" + clazz.getName() + "</a>";
        }
        return null;
    }

    private final /* synthetic */ void this() {
        this.patternUrl = Pattern.compile(regExpPossibleLink);
        this.searchJSPPages = true;
        this.searchCompiledJSPClasses = true;
        this.searchJavaClasses = true;
        this.searchMDD = true;
        this.jspSourceViewExtension = "x";
        this.importedPackages = new String[]{"", "java.lang."};
    }

    public LineViewer(boolean bl, HttpServletRequest httpServletRequest, HttpServlet httpServlet) {
        this.this();
        this.request = httpServletRequest;
        this.servlet = httpServlet;
        this.printLineNumbers = bl;
        this.servletContext = httpServlet.getServletContext();
        this.contextPath = httpServletRequest.getContextPath();
    }
}

