/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.makumba.MakumbaSystem;
import org.makumba.devel.LineViewer;
import org.makumba.util.ClassResource;
import org.makumba.view.jsptaglib.TomcatJsp;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class javaViewer
extends LineViewer {
    public static final String PROPERTIES_FILE_NAME = "config/javaSyntax.properties";
    public static Properties javaSyntaxProperties = new Properties();
    private boolean compiledJSP;

    private static final void initProperties() {
        try {
            URLConnection uRLConnection = ClassResource.get(PROPERTIES_FILE_NAME).openConnection();
            javaSyntaxProperties.load(uRLConnection.getInputStream());
        }
        catch (Throwable throwable) {
            javaSyntaxProperties = javaViewer.initDefaultProperties();
            MakumbaSystem.getLogger().info("Java syntax highlighting properties file 'config/javaSyntax.properties' not found! Using default values.");
        }
    }

    public static Properties initDefaultProperties() {
        Properties properties = new Properties();
        properties.put("public", "color:blue; font-weight: bold; ");
        properties.put("private", "color:blue; font-weight: bold; ");
        properties.put("static", "color:blue; font-weight: bold; ");
        properties.put("void", "color:blue; font-weight: bold; ");
        properties.put("class", "color:blue; font-weight: bold; ");
        properties.put("package", "color:blue; font-weight: bold; ");
        properties.put("import", "color:blue; font-weight: bold; ");
        properties.put("super", "color:blue; font-weight: bold; ");
        properties.put("return", "color:blue; font-weight: bold; ");
        properties.put("throws", "color:blue; font-weight: bold; ");
        properties.put("inner", "color:blue; font-weight: bold; ");
        properties.put("outer", "color:blue; font-weight: bold; ");
        properties.put("if", "color:green; font-weight: bold; ");
        properties.put("else", "color:green; font-weight: bold; ");
        properties.put("for", "color:green; font-weight: bold; ");
        properties.put("while", "color:green; font-weight: bold; ");
        properties.put("do", "color:green; font-weight: bold; ");
        properties.put("switch", "color:green; font-weight: bold; ");
        properties.put("case", "color:green; font-weight: bold; ");
        properties.put("int", "color:red; font-weight: bold; ");
        properties.put("long", "color:red; font-weight: bold; ");
        properties.put("short", "color:red; font-weight: bold; ");
        properties.put("byte", "color:red; font-weight: bold; ");
        properties.put("double", "color:red; font-weight: bold; ");
        properties.put("float", "color:red; font-weight: bold; ");
        properties.put("boolean", "color:red; font-weight: bold; ");
        return properties;
    }

    public String parseLine(String string) {
        String string2 = super.parseLine(string);
        if (this.compiledJSP) {
            return string2;
        }
        Iterator<Object> iterator = javaSyntaxProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = String.valueOf(iterator.next());
            string2 = string2.replaceAll(string3 + ' ', "<span style=\"" + javaSyntaxProperties.getProperty(string3) + "\">" + string3 + "</span> ");
        }
        return string2;
    }

    private final /* synthetic */ void this() {
        this.compiledJSP = false;
    }

    public javaViewer(HttpServletRequest httpServletRequest, HttpServlet httpServlet) throws Exception {
        super(true, httpServletRequest, httpServlet);
        this.this();
        javaViewer.initProperties();
        this.servletContext = httpServlet.getServletContext();
        this.jspClasspath = TomcatJsp.getContextCompiledJSPDir(httpServlet.getServletContext());
        this.contextPath = httpServletRequest.getContextPath();
        this.virtualPath = httpServletRequest.getPathInfo().substring(1);
        URL uRL = ClassResource.get(this.virtualPath.replace('.', '/') + ".java");
        if (uRL != null) {
            this.setSearchLevels(false, false, true, true);
            this.readFromURL(uRL);
        } else {
            String string = this.jspClasspath + '/' + this.virtualPath.replace('.', '/') + ".java";
            File file = new File(string);
            if (file.exists()) {
                uRL = new URL("file://" + string);
                this.setSearchLevels(false, false, false, false);
                this.compiledJSP = true;
                this.readFromURL(uRL);
            } else {
                MakumbaSystem.getLogger().info("Could not find the compiled JSP '" + this.virtualPath + '\'');
            }
        }
    }

    static {
        javaViewer.initProperties();
    }
}

