/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLConnection;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.makumba.LogicNotFoundException;
import org.makumba.MakumbaSystem;
import org.makumba.controller.Logic;
import org.makumba.controller.http.ControllerFilter;
import org.makumba.devel.JspxJspAnalyzer;
import org.makumba.devel.LineViewer;
import org.makumba.util.ClassResource;
import org.makumba.util.JspParseData;
import org.makumba.util.SourceSyntaxPoints;
import org.makumba.util.SyntaxPoint;
import org.makumba.view.jsptaglib.TomcatJsp;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class jspViewer
extends LineViewer {
    public static Properties jspSyntaxProperties = new Properties();
    private static final String PROPERTIES_FILE_NAME = "config/jspSyntax.properties";
    private static Set syntaxKeys;
    boolean hasLogic;
    private TreeSet sourceSyntaxPoints;
    private SourceSyntaxPoints syntaxPoints;
    private boolean hideComments;
    private boolean hideHTML;
    private boolean hideJSTLCore;
    private boolean hideJSTLFormat;
    private boolean hideMakumba;
    private boolean hideJava;

    private static final void initProperties() {
        try {
            URLConnection uRLConnection = ClassResource.get(PROPERTIES_FILE_NAME).openConnection();
            jspSyntaxProperties.load(uRLConnection.getInputStream());
        }
        catch (Throwable throwable) {
            jspSyntaxProperties = jspViewer.initDefaultProperties();
            MakumbaSystem.getLogger().info("JSP syntax highlighting properties file 'config/jspSyntax.properties' not found! Using default values.");
        }
    }

    public static Properties initDefaultProperties() {
        Properties properties = new Properties();
        properties.put("mak", "background:#eecccc; color:green; border:red thin; font-weight: bold; ");
        properties.put("jsp", "background:lightcyan; color:green; border:red thin; font-weight: bold; ");
        properties.put("fmt", "background::chartreuse; color:green; border:red thin; font-weight: bold; ");
        properties.put("c", "background:lightblue; color:green; border:red thin; font-weight: bold; ");
        return properties;
    }

    private final int extraLength() {
        return 1;
    }

    public void intro(PrintWriter printWriter) throws IOException {
        printWriter.print("<td>\n<table align=\"right\" cellpading=\"5\" cellspacing=\"5\">\n<tr>\n<td align=\"right\"><a href=\"" + this.contextPath + this.virtualPath + "\"><font color=\"darkblue\">execute</font></a>&nbsp;&nbsp;&nbsp;</td>\n<td align=\"right\" bgcolor=\"darkblue\"><font color=\"lightblue\">source</font>&nbsp;&nbsp;&nbsp;</td>\n<td align=\"right\"><a href=\"" + this.logicPath + "\"><font color=\"darkblue\">business logic" + (this.hasLogic ? "" : " (none)") + "</font></a></td>\n");
        String string = ControllerFilter.getLoginPage(this.virtualPath);
        if (string != null) {
            printWriter.print("<td align=\"right\">&nbsp;&nbsp;&nbsp;<a href=\"" + this.contextPath + string + "x\"><font color=\"darkblue\">login page</font></a></td>\n");
        }
        printWriter.print("</tr>\n</table>\n</td>\n</tr>\n<tr>\n<td align=\"right\"><form method=\"get\" action>\nHide: <input type=\"checkbox\" name=\"hideComments\" value=\"true\"" + (this.hideComments ? " checked=\"checked\"" : "") + ">Comments  \n<input type=\"checkbox\" name=\"hideHTML\" value=\"true\"" + (this.hideHTML ? " checked=\"checked\"" : "") + ">HML  \n<input type=\"checkbox\" name=\"hideJava\" value=\"true\"" + (this.hideJava ? " checked=\"checked\"" : "") + ">Java  \n<input type=\"checkbox\" name=\"hideJSTLCore\" value=\"true\"" + (this.hideJSTLCore ? " checked=\"checked\"" : "") + ">JSTL Core  \n<input type=\"checkbox\" name=\"hideJSTLFormat\" value=\"true\"" + (this.hideJSTLFormat ? " checked=\"checked\"" : "") + ">JSTL Format  \n<input type=\"checkbox\" name=\"hideMakumba\" value=\"true\"" + (this.hideMakumba ? " checked=\"checked\"" : "") + ">Makumba  \n<input type=\"submit\" value=\"apply\"> \n</form>\n</td>\n</tr>\n");
    }

    public void parseText(PrintWriter printWriter) throws IOException {
        jspViewer.initProperties();
        Date date = new Date();
        Object[] objectArray = syntaxKeys.toArray();
        Iterator iterator = this.sourceSyntaxPoints.iterator();
        this.printPageBegin(printWriter);
        SyntaxPoint syntaxPoint = null;
        boolean bl = true;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            SyntaxPoint syntaxPoint2 = (SyntaxPoint)iterator.next();
            String string = syntaxPoint2.getType();
            int n = syntaxPoint2.getLine();
            if (string.equals("TextLine") && syntaxPoint2.isBegin()) {
                syntaxPoint = syntaxPoint2;
                continue;
            }
            if (string.equals("TextLine") && !syntaxPoint2.isBegin()) {
                if (syntaxPoint2.getColumn() > 1 && (!this.hideHTML || bl2) && bl) {
                    stringBuffer.append(this.parseLine(this.htmlEscape(this.syntaxPoints.getLineText(n).substring(syntaxPoint.getColumn() - 1, syntaxPoint2.getColumn() - 1))));
                }
                if ((!stringBuffer.toString().trim().equals("") || syntaxPoint2.getColumn() == 1) && bl && this.printLineNumbers) {
                    printWriter.print("\n<a name=\"" + n + "\" href=\"#" + n + "\" class=\"lineNo\">" + n + ":\t</a>");
                }
                printWriter.print(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                syntaxPoint = syntaxPoint2;
                continue;
            }
            if (!this.isTagToHighlight(string)) continue;
            if (syntaxPoint2.isBegin()) {
                if (syntaxPoint2.getColumn() > 1 && !this.hideHTML && bl) {
                    stringBuffer.append(this.parseLine(this.htmlEscape(this.syntaxPoints.getLineText(n).substring(syntaxPoint.getColumn() - 1, syntaxPoint2.getColumn() - 1))));
                }
                bl2 = true;
                String string2 = this.syntaxPoints.getLineText(n).substring(syntaxPoint2.getColumn());
                if (string.equals("JspScriptlet")) {
                    if (this.hideJava) {
                        bl = false;
                    } else {
                        stringBuffer.append("<span style=\"background:yellow;color:green; border:red thin; font-weight: bold; \">");
                    }
                } else if (string.equals("JspComment")) {
                    if (this.hideComments) {
                        bl = false;
                    } else {
                        stringBuffer.append("<span style=\"color:gray; \">");
                    }
                } else if (string.equals("JSPSystemTag")) {
                    stringBuffer.append("<span style=\"" + jspSyntaxProperties.getProperty("jsp") + "; \">");
                } else {
                    if ((string2.startsWith("mak") || string2.startsWith("/mak")) && this.hideMakumba || (string2.startsWith("c") || string2.startsWith("/c")) && this.hideJSTLCore || (string2.startsWith("fmt") || string2.startsWith("/fmt")) && this.hideJSTLFormat) {
                        bl = false;
                    }
                    if (bl) {
                        int n2 = 0;
                        while (n2 < objectArray.length) {
                            if (string2.startsWith(String.valueOf(objectArray[n2])) || string2.startsWith(String.valueOf("/" + objectArray[n2]))) {
                                stringBuffer.append("<span style=\"" + jspSyntaxProperties.get(objectArray[n2]) + "; \">");
                                break;
                            }
                            ++n2;
                        }
                    }
                }
                syntaxPoint = syntaxPoint2;
                bl2 = true;
                continue;
            }
            if (bl) {
                stringBuffer.append(this.parseLine(this.htmlEscape(this.syntaxPoints.getLineText(n).substring(syntaxPoint.getColumn() - 1, syntaxPoint2.getColumn() - 1))));
                stringBuffer.append("</span>");
            }
            bl = true;
            syntaxPoint = syntaxPoint2;
            bl2 = false;
        }
        this.printPageEnd(printWriter);
        double d = new Date().getTime() - date.getTime();
        System.out.println("Code viewer took :" + d / 1000.0 + " seconds");
    }

    private final boolean isTagToHighlight(String string) {
        boolean bl = false;
        if (string.equals("JspTagBegin") || string.equals("JspTagEnd") || string.equals("JspTagSimple") || this.isSystemtag(string)) {
            bl = true;
        }
        return bl;
    }

    private final boolean isSystemtag(String string) {
        boolean bl = false;
        if (string.equals("JspComment") || string.equals("JspScriptlet") || string.equals("JSPSystemTag")) {
            bl = true;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        try {
            jspViewer.initDefaultProperties().store(new FileOutputStream("default.properties"), "Makumba Developer Support - JSP syntax highlighting");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final /* synthetic */ void this() {
        this.hideComments = false;
        this.hideHTML = false;
        this.hideJSTLCore = false;
        this.hideJSTLFormat = false;
        this.hideMakumba = false;
        this.hideJava = false;
    }

    public jspViewer(HttpServletRequest httpServletRequest, HttpServlet httpServlet) throws Exception {
        super(true, httpServletRequest, httpServlet);
        this.this();
        this.setSearchLevels(true, false, false, true);
        this.servlet = httpServlet;
        this.hideComments = Boolean.valueOf(String.valueOf(httpServletRequest.getParameter("hideComments")));
        this.hideHTML = Boolean.valueOf(String.valueOf(httpServletRequest.getParameter("hideHTML")));
        this.hideJSTLCore = Boolean.valueOf(String.valueOf(httpServletRequest.getParameter("hideJSTLCore")));
        this.hideJSTLFormat = Boolean.valueOf(String.valueOf(httpServletRequest.getParameter("hideJSTLFormat")));
        this.hideMakumba = Boolean.valueOf(String.valueOf(httpServletRequest.getParameter("hideMakumba")));
        this.hideJava = Boolean.valueOf(String.valueOf(httpServletRequest.getParameter("hideJava")));
        String string = TomcatJsp.getJspURI(httpServletRequest);
        string = string.substring(0, string.length() - 1);
        JspParseData jspParseData = JspParseData.getParseData(httpServlet.getServletContext().getRealPath("/"), string, JspxJspAnalyzer.singleton);
        jspParseData.getAnalysisResult(null);
        this.syntaxPoints = jspParseData.getSyntaxPoints();
        this.sourceSyntaxPoints = jspParseData.getSyntaxPoints().getSyntaxPoints();
        this.contextPath = httpServletRequest.getContextPath();
        String string2 = httpServletRequest.getServletPath();
        this.virtualPath = string2.substring(0, string2.length() - this.extraLength());
        this.jspSourceViewExtension = string2.substring(string2.length() - this.extraLength());
        this.realPath = httpServlet.getServletConfig().getServletContext().getRealPath(this.virtualPath);
        this.reader = new FileReader(this.realPath);
        string2 = string2.substring(0, string2.indexOf(".")) + ".jsp";
        this.logicPath = this.contextPath + "/logic" + string2;
        this.hasLogic = Logic.getLogic(string2) instanceof LogicNotFoundException ^ true;
    }

    static {
        jspViewer.initProperties();
        syntaxKeys = jspSyntaxProperties.keySet();
    }
}

