/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.controller.html;

import java.util.Dictionary;
import org.makumba.ProgrammerError;
import org.makumba.controller.html.RecordEditor;
import org.makumba.controller.http.HttpParameters;
import org.makumba.view.FieldFormatter;
import org.makumba.view.InvalidValueException;

public class FieldEditor
extends FieldFormatter {
    static String[] params = new String[]{"default", "empty", "type"};
    static String[][] paramValues;
    static final String suffixName = "org.makumba.editorSuffix";
    public static final String extraFormattingParam = "makumba.extraFormatting";

    public String[] getAcceptedParams() {
        return params;
    }

    public String[][] getAcceptedValue() {
        return paramValues;
    }

    public static String getSuffix(Dictionary dictionary) {
        return (String)dictionary.get(suffixName);
    }

    public static void setSuffix(Dictionary dictionary, String string) {
        dictionary.put(suffixName, string);
    }

    public void checkParam(String string, String string2) {
        if (string.equals(extraFormattingParam)) {
            return;
        }
        if (string.equals("type") && string2.equals("hidden")) {
            return;
        }
        super.checkParam(string, string2);
    }

    public String format(Object object, Dictionary dictionary) {
        String string = (String)dictionary.get("type");
        if (string != null && string.equals("hidden")) {
            return this.formatHidden(object, dictionary);
        }
        return this.formatShow(object, dictionary);
    }

    public String formatShow(Object object, Dictionary dictionary) {
        return super.format(object, dictionary);
    }

    public String formatHidden(Object object, Dictionary dictionary) {
        return "<input type=\"hidden\" name=\"" + this.getInputName(dictionary) + "\" value=\"" + this.formatHiddenValue(object, dictionary) + "\" " + FieldEditor.getExtraFormatting(dictionary) + '>';
    }

    public String formatHiddenValue(Object object, Dictionary dictionary) {
        return this.formatValue(object, dictionary);
    }

    public String formatValue(Object object, Dictionary dictionary) {
        throw new ProgrammerError("If this method is needed, overload it in the inheriting class");
    }

    public void onStartup(RecordEditor recordEditor) {
    }

    public String getInputName(Dictionary dictionary) {
        return this.getInputName(FieldEditor.getSuffix(dictionary));
    }

    public String getInputName(String string) {
        return this.getExpr() + string;
    }

    public static String getExtraFormatting(Dictionary dictionary) {
        return (String)dictionary.get(extraFormattingParam);
    }

    public static void setExtraFormatting(Dictionary dictionary, String string) {
        dictionary.put(extraFormattingParam, string);
    }

    public Object readFrom(HttpParameters httpParameters, String string) {
        return httpParameters.getParameter(this.getInputName(string));
    }

    protected Integer toInt(Object object) {
        if (object == null) {
            return null;
        }
        String string = ("" + object).trim();
        if (string.length() == 0) {
            return null;
        }
        try {
            return new Integer(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidValueException(this, "invalid integer: " + object);
        }
    }

    protected Double toReal(Object object) {
        if (object == null) {
            return null;
        }
        String string = ("" + object).trim();
        if (string.length() == 0) {
            return null;
        }
        try {
            return new Double(Double.parseDouble(string));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new Double(Double.parseDouble(string.replace(',', '.')));
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return new Double(Double.parseDouble(string.replace('.', ',')));
                }
                catch (NumberFormatException numberFormatException3) {
                    throw new InvalidValueException(this, "invalid real: " + object);
                }
            }
        }
    }

    static {
        String[][] stringArrayArray = new String[3][];
        stringArrayArray[2] = new String[]{"hidden"};
        paramValues = stringArrayArray;
    }
}

