/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.makumba.MakumbaSystem;
import org.makumba.devel.JavaSourceAnalyzer;
import org.makumba.devel.LineViewer;
import org.makumba.util.ClassResource;
import org.makumba.util.JavaParseData;
import org.makumba.util.SourceSyntaxPoints;
import org.makumba.util.SyntaxPoint;
import org.makumba.view.jsptaglib.TomcatJsp;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class javaViewer
extends LineViewer {
    public static final String PROPERTIES_FILE_NAME = "javaSyntax.properties";
    public static Properties javaSyntaxProperties = new Properties();
    private static final String DEFAULT_JAVACOMMENT_STYLE = "color: green; font-style: italic; ";
    private static final String DEFAULT_JAVAMODIFIER_STYLE = "color: blue; font-weight: bold; ";
    private static final String DEFAULT_JAVARESERVEDWORD_STYLE = "color: purple; font-weight: bold; ";
    private static final String DEFAULT_JAVASTRINGLITERAL_STYLE = "color: red; font-style: italic; ";
    private boolean compiledJSP;
    private SourceSyntaxPoints syntaxPoints;
    private SyntaxPoint[] sourceSyntaxPoints;

    private static final void initProperties() {
        try {
            URLConnection uRLConnection = ClassResource.get(PROPERTIES_FILE_NAME).openConnection();
            Properties properties = new Properties();
            properties.load(uRLConnection.getInputStream());
            javaSyntaxProperties.put("JavaBlockComment", properties.getProperty("JavaBlockComment", DEFAULT_JAVACOMMENT_STYLE));
            javaSyntaxProperties.put("JavaDocComment", properties.getProperty("javaDocComment", DEFAULT_JAVACOMMENT_STYLE));
            javaSyntaxProperties.put("JavaLineComment", properties.getProperty("javaLineComment", DEFAULT_JAVACOMMENT_STYLE));
            javaSyntaxProperties.put("JavaModifier", properties.getProperty("JavaReservedWord", DEFAULT_JAVAMODIFIER_STYLE));
            javaSyntaxProperties.put("JavaReservedWord", properties.getProperty("JavaReservedWord", DEFAULT_JAVARESERVEDWORD_STYLE));
            javaSyntaxProperties.put("JavaImport", properties.getProperty("JavaImport", DEFAULT_JAVARESERVEDWORD_STYLE));
            javaSyntaxProperties.put("JavaStringLiteral", properties.getProperty("JavaStringLiteral", DEFAULT_JAVASTRINGLITERAL_STYLE));
        }
        catch (Throwable throwable) {
            MakumbaSystem.getLogger("org.makumba.devel.sourceViewer").fine("Java syntax highlighting properties file 'javaSyntax.properties' not found! Using default values.");
            javaSyntaxProperties.put("JavaDocComment", DEFAULT_JAVACOMMENT_STYLE);
            javaSyntaxProperties.put("JavaBlockComment", DEFAULT_JAVACOMMENT_STYLE);
            javaSyntaxProperties.put("JavaLineComment", DEFAULT_JAVACOMMENT_STYLE);
            javaSyntaxProperties.put("JavaModifier", DEFAULT_JAVAMODIFIER_STYLE);
            javaSyntaxProperties.put("JavaReservedWord", DEFAULT_JAVARESERVEDWORD_STYLE);
            javaSyntaxProperties.put("JavaImport", DEFAULT_JAVARESERVEDWORD_STYLE);
            javaSyntaxProperties.put("JavaStringLiteral", DEFAULT_JAVASTRINGLITERAL_STYLE);
        }
    }

    public String parseLine(String string) {
        String string2 = super.parseLine(string);
        if (this.compiledJSP) {
            return string2;
        }
        Iterator<Object> iterator = javaSyntaxProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = String.valueOf(iterator.next());
            string2 = string2.replaceAll(string3 + ' ', "<span style=\"" + javaSyntaxProperties.getProperty(string3) + "\">" + string3 + "</span> ");
        }
        return string2;
    }

    public void parseText(PrintWriter printWriter) throws IOException {
        Date date = new Date();
        this.printPageBegin(printWriter);
        SyntaxPoint syntaxPoint = null;
        int n = 0;
        while (n < this.sourceSyntaxPoints.length) {
            SyntaxPoint syntaxPoint2 = this.sourceSyntaxPoints[n];
            String string = syntaxPoint2.getType();
            int n2 = syntaxPoint2.getLine();
            if (string.equals("TextLine") && syntaxPoint2.isBegin()) {
                if (this.printLineNumbers) {
                    printWriter.print("\n<a style=\"font-style: normal; \" name=\"" + n2 + "\" href=\"#" + n2 + "\" class=\"lineNo\">" + n2 + ":\t</a>");
                }
            } else if (string.equals("TextLine") && !syntaxPoint2.isBegin()) {
                printWriter.print(this.parseLine(this.htmlEscape(this.syntaxPoints.getLineText(n2).substring(syntaxPoint.getColumn() - 1, syntaxPoint2.getColumn() - 1))));
            } else if (syntaxPoint2.isBegin()) {
                printWriter.print(this.parseLine(this.htmlEscape(this.syntaxPoints.getLineText(n2).substring(syntaxPoint.getColumn() - 1, syntaxPoint2.getColumn() - 1))));
                printWriter.print("<span style=\"" + javaSyntaxProperties.get(string) + "; \">");
            } else {
                printWriter.print(this.parseLine(this.htmlEscape(this.syntaxPoints.getLineText(n2).substring(syntaxPoint.getColumn() - 1, syntaxPoint2.getColumn() - 1))));
                printWriter.print("</span>");
            }
            syntaxPoint = syntaxPoint2;
            ++n;
        }
        this.printPageEnd(printWriter);
        double d = new Date().getTime() - date.getTime();
        MakumbaSystem.getLogger("org.makumba.devel.sourceViewer").finer("Java sourcecode viewer took :" + d / 1000.0 + " seconds");
    }

    private final /* synthetic */ void this() {
        this.compiledJSP = false;
    }

    public javaViewer(HttpServletRequest httpServletRequest, HttpServlet httpServlet) throws Exception {
        super(true, httpServletRequest, httpServlet);
        Object object;
        this.this();
        javaViewer.initProperties();
        this.servletContext = httpServlet.getServletContext();
        this.jspClasspath = TomcatJsp.getContextCompiledJSPDir(httpServlet.getServletContext());
        this.contextPath = httpServletRequest.getContextPath();
        this.virtualPath = httpServletRequest.getPathInfo().substring(1);
        URL uRL = ClassResource.get(this.virtualPath.replace('.', '/') + ".java");
        if (uRL != null) {
            this.setSearchLevels(false, false, true, true);
        } else {
            object = this.jspClasspath + '/' + this.virtualPath.replace('.', '/') + ".java";
            File file = new File((String)object);
            if (file.exists()) {
                uRL = new URL("file://" + (String)object);
                this.setSearchLevels(false, false, false, false);
                this.compiledJSP = true;
            } else {
                MakumbaSystem.getLogger("org.makumba.devel.sourceViewer").info("Could not find the compiled JSP '" + this.virtualPath + '\'');
            }
        }
        object = JavaParseData.getParseData("/", uRL.getFile(), JavaSourceAnalyzer.singleton);
        ((JavaParseData)object).getAnalysisResult(null);
        this.syntaxPoints = ((JavaParseData)object).getSyntaxPoints();
        this.sourceSyntaxPoints = ((JavaParseData)object).getSyntaxPoints().getSyntaxPoints();
        this.readFromURL(uRL);
    }

    static {
        javaViewer.initProperties();
    }
}

