/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.util;

import java.io.File;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makumba.MakumbaSystem;
import org.makumba.util.JavaParseData;
import org.makumba.util.NamedResources;
import org.makumba.util.SourceSyntaxPoints;
import org.makumba.util.SyntaxPoint;

public class JavaParseData
implements SourceSyntaxPoints.PreprocessorClient {
    static int analyzedPages = NamedResources.makeStaticCache("Java page analyses", new 1(), true);
    private static String[] JavaCommentPatternNames = new String[]{"JavaBlockComment", "JavaDocComment", "JavaLineComment"};
    private static Pattern[] JavaCommentPatterns;
    static Pattern JavaDocCommentPattern;
    static Pattern JavaBlockCommentPattern;
    static Pattern JavaLineCommentPattern;
    static Pattern JavaModifierPattern;
    static Pattern JavaReservedWordPattern;
    static Pattern JavaImports;
    static Pattern JavaStringLiteral;
    JavaAnalyzer analyzer;
    File file;
    Object holder;
    SourceSyntaxPoints syntaxPoints;
    String uri;

    public static JavaParseData getParseData(String string, String string2, JavaAnalyzer javaAnalyzer) {
        Object[] objectArray = new Object[]{string + string2, javaAnalyzer, string2};
        return (JavaParseData)NamedResources.getStaticCache(analyzedPages).getResource(objectArray);
    }

    public synchronized Object getAnalysisResult(Object object) {
        if (this.getSyntaxPoints() == null || !this.getSyntaxPoints().unchanged()) {
            try {
                this.parse(object);
            }
            catch (Error error) {
                this.holder = error;
                throw error;
            }
            catch (RuntimeException runtimeException) {
                this.holder = runtimeException;
                throw runtimeException;
            }
        }
        return this.holder;
    }

    public String[] getCommentPatternNames() {
        return JavaCommentPatternNames;
    }

    public Pattern[] getCommentPatterns() {
        return JavaCommentPatterns;
    }

    public Pattern getIncludePattern() {
        return null;
    }

    public String getIncludePatternName() {
        return null;
    }

    public SourceSyntaxPoints getSyntaxPoints() {
        return this.syntaxPoints;
    }

    void parse(Object object) {
        long l = new Date().getTime();
        this.syntaxPoints = new SourceSyntaxPoints(this.file, this);
        this.holder = this.analyzer.makeStatusHolder(object);
        this.treatJavaImports(this.syntaxPoints.getContent(), this.analyzer);
        this.treatJavaStringLiterals(this.syntaxPoints.getContent(), this.analyzer);
        this.treatJavaModifiers(this.syntaxPoints.getContent(), this.analyzer);
        this.treatReservedWords(this.syntaxPoints.getContent(), this.analyzer);
        this.holder = this.analyzer.endPage(this.holder);
        MakumbaSystem.getMakumbaLogger("javaparser.time").info("analysis of " + this.uri + " took " + (new Date().getTime() - l) + " ms");
    }

    public void treatInclude(int n, String string, SourceSyntaxPoints sourceSyntaxPoints) {
    }

    void treatJavaImports(String string, JavaAnalyzer javaAnalyzer) {
        Matcher matcher = JavaImports.matcher(string);
        while (matcher.find()) {
            SyntaxPoint.End end = this.syntaxPoints.addSyntaxPoints(matcher.start(), matcher.end(), "JavaImport", null);
            SyntaxPoint syntaxPoint = (SyntaxPoint)((SyntaxPoint)end).getOtherInfo();
        }
    }

    void treatJavaStringLiterals(String string, JavaAnalyzer javaAnalyzer) {
        Matcher matcher = JavaStringLiteral.matcher(string);
        while (matcher.find()) {
            SyntaxPoint.End end = this.syntaxPoints.addSyntaxPoints(matcher.start(), matcher.end(), "JavaStringLiteral", null);
            SyntaxPoint syntaxPoint = (SyntaxPoint)((SyntaxPoint)end).getOtherInfo();
        }
    }

    void treatJavaModifiers(String string, JavaAnalyzer javaAnalyzer) {
        Matcher matcher = JavaModifierPattern.matcher(string);
        while (matcher.find()) {
            SyntaxPoint.End end = this.syntaxPoints.addSyntaxPoints(matcher.start(), matcher.end(), "JavaModifier", null);
            SyntaxPoint syntaxPoint = (SyntaxPoint)((SyntaxPoint)end).getOtherInfo();
        }
    }

    void treatReservedWords(String string, JavaAnalyzer javaAnalyzer) {
        Matcher matcher = JavaReservedWordPattern.matcher(string);
        while (matcher.find()) {
            SyntaxPoint.End end = this.syntaxPoints.addSyntaxPoints(matcher.start(), matcher.end(), "JavaReservedWord", null);
            SyntaxPoint syntaxPoint = (SyntaxPoint)((SyntaxPoint)end).getOtherInfo();
        }
    }

    protected JavaParseData(String string, JavaAnalyzer javaAnalyzer, String string2) {
        this.file = new File(string);
        this.uri = string2;
        this.analyzer = javaAnalyzer;
    }

    static {
        try {
            JavaDocCommentPattern = Pattern.compile("/\\*\\*.*?[^\\*]\\*/", 32);
            JavaBlockCommentPattern = Pattern.compile("\\/\\*[^\\*][^(\\*\\/)]*\\*\\/", 32);
            JavaLineCommentPattern = Pattern.compile("//.*$", 8);
            JavaModifierPattern = Pattern.compile("(public )|(private )|(protected )|(transient )|(static )|(void )|(super.)|(super \\()|(super )|(inner.)|(outer.)");
            JavaReservedWordPattern = Pattern.compile("(class )|(int )|(boolean )|(double )|(float )|(short )|(long )|(byte )|(for )|(for\\()|(do )|(do\\{)|(while )|(while\\()|(switch )|(case )|(return )|(if )|(if\\()|(else )|(else\\()");
            JavaImports = Pattern.compile("(package )|(import )");
            JavaStringLiteral = Pattern.compile("\"[^\"]*\"");
            Pattern[] patternArray = new Pattern[]{JavaBlockCommentPattern, JavaDocCommentPattern, JavaLineCommentPattern};
            JavaCommentPatterns = patternArray;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static interface JavaAnalyzer {
        public Object endPage(Object var1);

        public Object makeStatusHolder(Object var1);
    }
}

