/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql;

import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.makumba.DBError;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.NotUniqueError;
import org.makumba.Pointer;
import org.makumba.abstr.FieldHandler;
import org.makumba.db.DBConnection;
import org.makumba.db.DBConnectionWrapper;
import org.makumba.db.Table;
import org.makumba.db.sql.Database;
import org.makumba.db.sql.FieldManager;
import org.makumba.db.sql.SQLDBConnection;
import org.makumba.db.sql.ptrIndexJavaManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RecordManager
extends Table {
    protected String tbname;
    protected String handlerList;
    protected String indexDBField;
    protected String indexField;
    boolean alter;
    boolean exists_;
    Hashtable handlerExist;
    Dictionary keyIndex;
    String preparedInsertString;
    String preparedDeleteString;
    String preparedDeleteFromString;
    boolean admin;
    Hashtable indexes;
    Hashtable extraIndexes;

    public boolean exists() {
        return this.exists_;
    }

    public boolean exists(String string) {
        boolean bl = false;
        if (this.handlerExist.get(string) != null) {
            bl = true;
        }
        return bl;
    }

    public String getDBName() {
        return this.tbname;
    }

    protected Database getSQLDatabase() {
        return (Database)this.getDatabase();
    }

    protected boolean usesHidden() {
        return true;
    }

    void makeKeyIndex() {
        if (this.keyIndex == null) {
            this.keyIndex = new Hashtable();
            int n = 0;
            while (n < this.getDataDefinition().getFieldNames().size()) {
                FieldDefinition fieldDefinition = this.getDataDefinition().getFieldDefinition(n);
                if (!fieldDefinition.getType().startsWith("set")) {
                    this.keyIndex.put(fieldDefinition.getName(), new Integer(n));
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void open(Properties properties) {
        this.setTableAndFieldNames(properties);
        if (this.getDataDefinition().isTemporary()) {
            this.makeKeyIndex();
            return;
        }
        DBConnectionWrapper dBConnectionWrapper = (DBConnectionWrapper)this.getSQLDatabase().getDBConnection();
        SQLDBConnection sQLDBConnection = (SQLDBConnection)dBConnectionWrapper.getWrapped();
        try {
            this.checkStructure(sQLDBConnection, properties);
            this.initFields(sQLDBConnection, properties);
            this.preparedInsertString = this.prepareInsert();
            this.preparedDeleteString = this.prepareDelete();
            this.preparedDeleteFromString = "DELETE FROM " + this.getDBName() + " WHERE " + this.indexDBField + " >= ? AND " + this.indexDBField + " <= ?";
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            dBConnectionWrapper.close();
            throw throwable;
        }
        {
            Object var5_6 = null;
            dBConnectionWrapper.close();
            return;
        }
    }

    protected void setTableAndFieldNames(Properties properties) {
        Object[] objectArray = new Object[]{this, properties};
        this.tbname = properties.getProperty(this.getDataDefinition().getName());
        if (this.tbname == null) {
            String string = Database.findConfig(properties, this.getDataDefinition().getName());
            String string2 = this.getDataDefinition().getName();
            if (string != null) {
                string2 = properties.getProperty(string) + this.getDataDefinition().getName().substring(string.length());
            }
            this.tbname = this.getSQLDatabase().getTableName(string2);
        } else if (this.tbname.indexOf(46) != -1) {
            this.tbname = this.getSQLDatabase().getTableName(this.tbname);
        }
        try {
            this.callAll(this.getHandlerMethod("setDBName"), objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MakumbaError(invocationTargetException.getTargetException());
        }
    }

    public boolean canAdmin() {
        return this.admin;
    }

    protected void checkStructure(SQLDBConnection sQLDBConnection, Properties properties) {
        String string = Database.findConfig(properties, "admin#" + this.getDataDefinition().getName());
        boolean bl = false;
        if (string != null && properties.getProperty(string).trim().equals("true")) {
            bl = true;
        }
        this.admin = bl;
        string = Database.findConfig(properties, "alter#" + this.getDataDefinition().getName());
        boolean bl2 = false;
        if (string != null && properties.getProperty(string).trim().equals("true")) {
            bl2 = true;
        }
        this.alter = bl2;
        MakumbaSystem.getMakumbaLogger("db.init.tablechecking").info(this.getDatabase().getConfiguration() + ": checking " + this.getDataDefinition().getName() + " as " + this.tbname);
        try {
            CatalogChecker catalogChecker = null;
            if (this.getSQLDatabase().catalog == null) {
                throw new MakumbaError(this.getDatabase().getName() + ": could not open catalog");
            }
            catalogChecker = new CatalogChecker(this.getSQLDatabase().catalog);
            if (catalogChecker.shouldCreate()) {
                this.create(sQLDBConnection, this.tbname, this.alter);
                this.exists_ = this.alter;
                properties.put("makumba.wasCreated", "");
                this.makeKeyIndex();
            } else {
                this.exists_ = true;
                this.alter(sQLDBConnection, catalogChecker);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new DBError(sQLException);
        }
    }

    protected void initFields(SQLDBConnection sQLDBConnection, Properties properties) {
        Object object;
        Object[] objectArray;
        try {
            objectArray = sQLDBConnection.getMetaData().getIndexInfo(null, null, this.getDBName(), false, false);
            while (objectArray.next()) {
                object = objectArray.getString("INDEX_NAME");
                boolean bl = objectArray.getBoolean("NON_UNIQUE");
                if (object == null) continue;
                this.indexes.put(((String)object).toLowerCase(), new Boolean(bl));
            }
            objectArray.close();
        }
        catch (SQLException sQLException) {
            Database.logException(sQLException, sQLDBConnection);
            throw new DBError(sQLException);
        }
        this.extraIndexes = (Hashtable)this.indexes.clone();
        objectArray = new Object[]{this, properties, sQLDBConnection};
        try {
            this.callAll(this.getHandlerMethod("onStartup"), objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (this.alter) {
                throw new MakumbaError(invocationTargetException.getTargetException());
            }
            MakumbaSystem.getMakumbaLogger("db.init.tablechecking").severe("unusable table: " + this.getDataDefinition().getName());
        }
        if (this.alter) {
            object = this.extraIndexes.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                try {
                    Statement statement = sQLDBConnection.createStatement();
                    statement.executeUpdate("DROP INDEX " + string + " ON " + this.getDBName());
                    MakumbaSystem.getMakumbaLogger("db.init.tablechecking").info("INDEX DROPPED on " + this.getDataDefinition().getName() + '#' + string);
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        } else {
            object = new StringBuffer();
            String string = "";
            Enumeration enumeration = this.extraIndexes.keys();
            while (enumeration.hasMoreElements()) {
                ((StringBuffer)object).append(string).append(enumeration.nextElement());
                string = ", ";
            }
            if (((StringBuffer)object).length() > 0) {
                MakumbaSystem.getMakumbaLogger("db.init.tablechecking").warning("Extra indexes on " + this.getDataDefinition().getName() + ": " + object);
            }
        }
        object = new StringBuffer();
        RecordManager.fieldList((StringBuffer)object, this.handlerOrder.elements());
        this.handlerList = ((StringBuffer)object).toString();
        this.indexField = this.getDataDefinition().getIndexPointerFieldName();
        this.indexDBField = ((FieldManager)this.handlers.get(this.indexField)).getDBName();
    }

    public int deleteFrom(DBConnection dBConnection, DBConnection dBConnection2) {
        if (!this.exists()) {
            return 0;
        }
        if (!this.canAdmin()) {
            throw new MakumbaError("no administration approval for " + this.getDataDefinition().getName());
        }
        if (dBConnection instanceof DBConnectionWrapper) {
            dBConnection = ((DBConnectionWrapper)dBConnection).getWrapped();
        }
        PreparedStatement preparedStatement = ((SQLDBConnection)dBConnection).getPreparedStatement(this.preparedDeleteFromString);
        try {
            preparedStatement.setInt(1, dBConnection2.getHostDatabase().getMinPointerValue());
            preparedStatement.setInt(2, dBConnection2.getHostDatabase().getMaxPointerValue());
        }
        catch (SQLException sQLException) {
            Database.logException(sQLException);
            throw new DBError(sQLException);
        }
        int n = this.getSQLDatabase().exec(preparedStatement);
        ((ptrIndexJavaManager)this.handlers.get(this.indexField)).reset();
        return n;
    }

    protected void alter(SQLDBConnection sQLDBConnection, CheckingStrategy checkingStrategy) throws SQLException {
        Object object;
        Object object2;
        Vector<FieldManager> vector = new Vector<FieldManager>();
        Vector<Object> vector2 = new Vector<Object>();
        Vector<FieldManager> vector3 = new Vector<FieldManager>();
        Vector<Object> vector4 = new Vector<Object>();
        Object object3 = new Object();
        while (checkingStrategy.hasMoreColumns()) {
            object2 = checkingStrategy.columnName();
            boolean bl = false;
            object = this.handlerOrder.elements();
            while (object.hasMoreElements()) {
                FieldManager fieldManager = (FieldManager)object.nextElement();
                if (!fieldManager.getDBName().toLowerCase().equals(((String)object2).toLowerCase())) continue;
                this.handlerExist.put(fieldManager.getName(), object3);
                vector.addElement(fieldManager);
                if (!(checkingStrategy.checkColumn(fieldManager) || this.alter && this.alter(sQLDBConnection, fieldManager, "MODIFY"))) {
                    MakumbaSystem.getMakumbaLogger("db.init.tablechecking").warning("should modify: " + fieldManager.getDataName() + ' ' + fieldManager.getDBName() + ' ' + fieldManager.getDBType() + ' ' + checkingStrategy.columnType() + ' ' + checkingStrategy.columnName());
                    vector3.addElement(fieldManager);
                }
                bl = true;
            }
            if (bl) continue;
            vector4.addElement(object2);
            MakumbaSystem.getMakumbaLogger("db.init.tablechecking").warning("extra field: " + checkingStrategy.columnName() + ' ' + checkingStrategy.columnType() + ' ' + checkingStrategy.columnTypeName());
        }
        object2 = new Vector();
        this.keyIndex = new Hashtable();
        Enumeration enumeration = this.handlerOrder.elements();
        while (enumeration.hasMoreElements()) {
            object = (FieldManager)enumeration.nextElement();
            if (!(this.handlerExist.get(((FieldHandler)object).getName()) != null || this.alter && this.alter(sQLDBConnection, (FieldManager)object, "ADD"))) {
                vector2.addElement(object);
                MakumbaSystem.getMakumbaLogger("db.init.tablechecking").warning("should add " + ((FieldHandler)object).getDataName() + ' ' + ((FieldManager)object).getDBName() + ' ' + ((FieldManager)object).getDBType());
                continue;
            }
            this.keyIndex.put(((FieldHandler)object).getName(), new Integer(((Vector)object2).size()));
            ((Vector)object2).addElement(object);
        }
        this.handlerOrder = object2;
        this.doAlter(sQLDBConnection, vector4, vector, vector2, vector3);
    }

    boolean alter(SQLDBConnection sQLDBConnection, FieldManager fieldManager, String string) throws SQLException {
        Statement statement = sQLDBConnection.createStatement();
        String string2 = "ALTER TABLE " + this.getDBName() + ' ' + string + ' ' + fieldManager.inCreate(this.getSQLDatabase());
        MakumbaSystem.getMakumbaLogger("db.init.tablechecking").info(this.getSQLDatabase().getConfiguration() + ": " + string2);
        try {
            String string3 = "DROP INDEX " + fieldManager.getDBIndexName() + " ON " + this.getDBName();
            statement.executeUpdate(string3);
            MakumbaSystem.getMakumbaLogger("db.init.tablechecking").info("SUCCESS: " + string3);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.executeUpdate(string2);
        this.handlerExist.put(fieldManager.getName(), "");
        sQLDBConnection.commit();
        statement.close();
        return true;
    }

    protected void doAlter(SQLDBConnection sQLDBConnection, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws SQLException {
        if (vector3.size() == 0 && vector4.size() == 0) {
            return;
        }
        if (vector2.size() == 0) {
            this.create(sQLDBConnection, this.tbname, this.alter);
        }
    }

    protected void indexCreated(SQLDBConnection sQLDBConnection) {
    }

    protected String createDbSpecific(String string) {
        return string;
    }

    protected String getTableMissingStateName(SQLDBConnection sQLDBConnection) {
        return "tableMissing";
    }

    protected void create(SQLDBConnection sQLDBConnection, String string, boolean bl) throws SQLException {
        Statement statement = sQLDBConnection.createStatement();
        Object[] objectArray = new Object[]{this.getSQLDatabase()};
        if (bl) {
            try {
                statement.executeUpdate("DROP TABLE " + string);
            }
            catch (SQLException sQLException) {
                this.getSQLDatabase().checkState(sQLException, this.getTableMissingStateName(sQLDBConnection));
            }
        }
        try {
            String string2 = "CREATE TABLE " + string + '(' + this.concatAll(this.getHandlerMethod("inCreate"), objectArray, ",") + ')';
            string2 = this.createDbSpecific(string2);
            if (!bl) {
                MakumbaSystem.getMakumbaLogger("db.init.tablechecking").warning("would be:\n" + string2);
                return;
            }
            MakumbaSystem.getMakumbaLogger("db.init.tablechecking").info(string2);
            statement.executeUpdate(string2);
            sQLDBConnection.commit();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DBError(invocationTargetException.getTargetException());
        }
        statement.close();
    }

    protected static void fieldList(StringBuffer stringBuffer, Enumeration enumeration) {
        String string = "";
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(string);
            string = ", ";
            stringBuffer.append(((FieldManager)enumeration.nextElement()).getDBName());
        }
    }

    boolean checkDBName(String string) {
        Enumeration enumeration = this.handlerOrder.elements();
        while (enumeration.hasMoreElements()) {
            FieldManager fieldManager = (FieldManager)enumeration.nextElement();
            if (fieldManager.getDBName() == null || !fieldManager.getDBName().toLowerCase().equals(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected String prepareInsert() {
        Object[] objectArray = new Object[]{};
        try {
            return "INSERT INTO " + this.tbname + " (" + this.handlerList + ") VALUES (" + this.concatAll(this.getHandlerMethod("inPreparedInsert"), objectArray, ",") + ')';
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MakumbaError(invocationTargetException.getTargetException());
        }
    }

    public Pointer insertRecordImpl(DBConnection dBConnection, Dictionary dictionary) {
        boolean bl = false;
        if (dictionary.get(this.indexField) != null) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if (dictionary.get("TS_create") != null) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        boolean bl5 = false;
        if (dictionary.get("TS_create") != null) {
            bl5 = true;
        }
        boolean bl6 = bl5;
        try {
            if (dBConnection instanceof DBConnectionWrapper) {
                dBConnection = ((DBConnectionWrapper)dBConnection).getWrapped();
            }
            PreparedStatement preparedStatement = ((SQLDBConnection)dBConnection).getPreparedStatement(this.preparedInsertString);
            int n = 0;
            Object object = this.handlerOrder.elements();
            while (object.hasMoreElements()) {
                ++n;
                FieldManager fieldManager = (FieldManager)object.nextElement();
                try {
                    fieldManager.setInsertArgument(preparedStatement, n, dictionary);
                }
                catch (Throwable throwable) {
                    throw new DBError(throwable, "insert into \"" + this.getDataDefinition().getName() + "\" at field \"" + fieldManager.getName() + "\" could not assign value \"" + dictionary.get(fieldManager.getName()) + "\" " + (dictionary.get(fieldManager.getName()) != null ? "of type \"" + dictionary.get(fieldManager.getName()).getClass().getName() + '\"' : ""));
                }
            }
            if (this.getSQLDatabase().exec(preparedStatement) == -1) {
                throw this.findDuplicates((SQLDBConnection)dBConnection, dictionary);
            }
            object = (Pointer)dictionary.get(this.indexField);
            if (!bl2) {
                dictionary.remove(this.indexField);
            }
            if (!bl4) {
                dictionary.remove("TS_create");
            }
            if (!bl6) {
                dictionary.remove("TS_modify");
            }
            return object;
        }
        catch (Throwable throwable) {
            DBError dBError;
            if (!(throwable instanceof DBError)) {
                dBError = new DBError(throwable);
            }
            throw (DBError)dBError;
        }
    }

    protected NotUniqueError findDuplicates(SQLDBConnection sQLDBConnection, Dictionary dictionary) {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.handlerOrder.elements();
        while (enumeration.hasMoreElements()) {
            FieldManager fieldManager = (FieldManager)enumeration.nextElement();
            if (!fieldManager.checkDuplicate(sQLDBConnection, dictionary)) continue;
            ((Dictionary)hashtable).put(fieldManager.getName(), dictionary.get(fieldManager.getName()));
        }
        return new NotUniqueError(this.getDataDefinition().getName(), hashtable);
    }

    protected String prepareDelete() {
        return "DELETE FROM " + this.tbname + " WHERE " + ((FieldManager)this.handlers.get(this.indexField)).inPreparedUpdate();
    }

    public void deleteRecord(DBConnection dBConnection, Pointer pointer) {
        if (dBConnection instanceof DBConnectionWrapper) {
            dBConnection = ((DBConnectionWrapper)dBConnection).getWrapped();
        }
        PreparedStatement preparedStatement = ((SQLDBConnection)dBConnection).getPreparedStatement(this.preparedDeleteString);
        try {
            ((FieldManager)this.handlers.get(this.indexField)).setUpdateArgument(preparedStatement, 1, pointer);
            this.getSQLDatabase().exec(preparedStatement);
        }
        catch (SQLException sQLException) {
            Database.logException(sQLException);
            throw new DBError(sQLException);
        }
    }

    public void updateRecord(DBConnection dBConnection, Pointer pointer, Dictionary dictionary) {
        Object object;
        if (dBConnection instanceof DBConnectionWrapper) {
            dBConnection = ((DBConnectionWrapper)dBConnection).getWrapped();
        }
        dictionary.remove(this.indexField);
        dictionary.remove("TS_create");
        dictionary.put("TS_modify", new Date());
        StringBuffer stringBuffer = new StringBuffer("UPDATE ").append(this.tbname).append(" SET ");
        String string = "";
        Object object2 = dictionary.keys();
        while (object2.hasMoreElements()) {
            Object k;
            if (string.length() > 0) {
                stringBuffer.append(",");
            }
            if ((object = (FieldManager)this.handlers.get(k = object2.nextElement())) == null) {
                throw new DBError(new Exception("no such field " + k + " in " + this.getDataDefinition().getName()));
            }
            string = ((FieldManager)object).inPreparedUpdate();
            stringBuffer.append(string);
        }
        stringBuffer.append(" WHERE " + ((FieldManager)this.handlers.get(this.indexField)).inPreparedUpdate());
        try {
            object2 = ((SQLDBConnection)dBConnection).getPreparedStatement(stringBuffer.toString());
            int n = 1;
            object = dictionary.keys();
            while (object.hasMoreElements()) {
                ((FieldManager)this.handlers.get(object.nextElement())).setUpdateArgument((PreparedStatement)object2, n, dictionary);
                ++n;
            }
            ((FieldManager)this.handlers.get(this.indexField)).setUpdateArgument((PreparedStatement)object2, n, pointer);
            if (this.getSQLDatabase().exec((PreparedStatement)object2) == -1) {
                throw this.findDuplicates((SQLDBConnection)dBConnection, dictionary);
            }
            return;
        }
        catch (SQLException sQLException) {
            throw new DBError(sQLException);
        }
    }

    protected void fillResult(ResultSet resultSet, Dictionary dictionary) throws SQLException {
        int n = this.handlerOrder.size();
        int n2 = 0;
        while (n2 < n) {
            ((FieldManager)this.handlerOrder.elementAt(n2)).setValue(dictionary, resultSet, ++n2);
        }
    }

    protected void fillResult(ResultSet resultSet, Object[] objectArray) throws SQLException {
        int n = this.handlerOrder.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                objectArray[n2] = ((FieldManager)this.handlerOrder.elementAt(n2)).getValue(resultSet, n2 + 1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                MakumbaSystem.getMakumbaLogger("db.query.execution").log(Level.SEVERE, "" + n2 + ' ' + this.getDataDefinition().getName() + ' ' + this.keyIndex + ' ' + this.handlerOrder, arrayIndexOutOfBoundsException);
                throw arrayIndexOutOfBoundsException;
            }
            ++n2;
        }
    }

    public Object getValue(ResultSet resultSet, String string, int n) {
        try {
            return ((FieldManager)this.getFieldHandler(string)).getValue(resultSet, n);
        }
        catch (SQLException sQLException) {
            throw new DBError(sQLException);
        }
    }

    private final /* synthetic */ void this() {
        this.handlerExist = new Hashtable();
        this.indexes = new Hashtable();
    }

    public RecordManager() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CatalogChecker
    implements CheckingStrategy {
        Vector columns;
        Hashtable column;
        int i;

        public boolean shouldCreate() {
            boolean bl = false;
            if (this.columns == null) {
                bl = true;
            }
            return bl;
        }

        public boolean hasMoreColumns() throws SQLException {
            if (this.i < this.columns.size()) {
                this.column = (Hashtable)this.columns.elementAt(this.i);
                ++this.i;
                return true;
            }
            return false;
        }

        public String columnName() throws SQLException {
            return (String)this.column.get("COLUMN_NAME");
        }

        public int columnType() throws SQLException {
            return (Integer)this.column.get("DATA_TYPE");
        }

        public int columnSize() throws SQLException {
            return (Integer)this.column.get("COLUMN_SIZE");
        }

        public String columnTypeName() throws SQLException {
            return (String)this.column.get("TYPE_NAME");
        }

        public boolean checkColumn(FieldManager fieldManager) throws SQLException {
            return fieldManager.unmodified(this.columnType(), this.columnSize(), this.columns, this.i);
        }

        private final /* synthetic */ void this() {
            this.i = 0;
        }

        CatalogChecker(Hashtable hashtable) throws SQLException {
            this.this();
            this.columns = (Vector)hashtable.get(RecordManager.this.tbname);
            if (this.columns == null) {
                this.columns = (Vector)hashtable.get(RecordManager.this.tbname.toLowerCase());
                if (this.columns == null) {
                    this.columns = (Vector)hashtable.get(RecordManager.this.tbname.toUpperCase());
                    if (this.columns != null) {
                        RecordManager.this.tbname = RecordManager.this.tbname.toUpperCase();
                    }
                } else {
                    RecordManager.this.tbname = RecordManager.this.tbname.toLowerCase();
                }
            }
        }
    }

    protected static interface CheckingStrategy {
        public boolean hasMoreColumns() throws SQLException;

        public String columnName() throws SQLException;

        public int columnType() throws SQLException;

        public String columnTypeName() throws SQLException;

        public boolean checkColumn(FieldManager var1) throws SQLException;

        public boolean shouldCreate() throws SQLException;
    }
}

