/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.TimeZone;

public class ReadableFormatter {
    public static String readableBytes(String string) {
        try {
            return ReadableFormatter.readableBytes(new Long(string.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return "N/A";
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public static String readableBytes(long l) {
        if (l < 0L) {
            return "invalid";
        }
        if (l < 1L) {
            return "empty";
        }
        float f = new Float(l).floatValue();
        String string = "bytes";
        float f2 = 1.0f;
        String[] stringArray = new String[]{"B", "kB", "MB", "GB", "TB"};
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(1);
        decimalFormat.setGroupingUsed(true);
        String string2 = decimalFormat.format(f);
        int n = 0;
        while (n + 1 < stringArray.length && (string2.length() > 4 || string2.length() > 3 && string2.indexOf(46) < 0)) {
            ++n;
            string2 = decimalFormat.format(f / (f2 *= 1024.0f));
        }
        if (string2.charAt(0) == '0' && n > 0) {
            string2 = decimalFormat.format(Math.round(1024.0f * f / f2));
            --n;
        }
        if (string2.length() > 3 && string2.indexOf(46) > 0) {
            string2 = string2.substring(0, string2.indexOf(46));
        }
        string = stringArray[n];
        return string2 + ' ' + string;
    }

    public static String readableAge(long l) {
        long l2 = l / 1000L;
        if (l2 < (long)2) {
            return "1 second";
        }
        if (l2 == (long)2) {
            return "2 seconds";
        }
        long l3 = l2;
        String string = "seconds";
        Long l4 = new Long(l2);
        long[] lArray = new long[]{31536000L, 2628000L, 604800L, 86400L, 3600L, 60L, 1L};
        String[] stringArray = new String[]{"year", "month", "week", "day", "hour", "minute", "second"};
        int n = 0;
        while (n <= lArray.length && l2 <= (long)2 * lArray[n]) {
            ++n;
        }
        l3 = l2 / lArray[n];
        string = stringArray[n];
        if (l3 >= (long)2) {
            string = string + 's';
        }
        String string2 = "" + l3 + ' ' + string;
        return string2;
    }

    public static String readableDate(Date date) {
        DateFormat dateFormat = DateFormat.getInstance();
        dateFormat.setTimeZone(TimeZone.getTimeZone("CET"));
        return dateFormat.format(date);
    }
}

