/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.property.BackrefPropertyAccessor;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.type.ArrayType;
import org.hibernate.type.BagType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeCustomType;
import org.hibernate.type.CurrencyType;
import org.hibernate.type.CustomCollectionType;
import org.hibernate.type.CustomType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.IdentifierBagType;
import org.hibernate.type.ListType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.MapType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.SetType;
import org.hibernate.type.SortedMapType;
import org.hibernate.type.SortedSetType;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;

public final class TypeFactory {
    private static final Map BASIC_TYPES;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$util$GregorianCalendar;
    static /* synthetic */ Class class$java$util$TimeZone;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$org$hibernate$type$Type;
    static /* synthetic */ Class class$org$hibernate$usertype$CompositeUserType;
    static /* synthetic */ Class class$org$hibernate$usertype$UserType;
    static /* synthetic */ Class class$org$hibernate$classic$Lifecycle;

    private TypeFactory() {
        throw new UnsupportedOperationException();
    }

    public static EntityType oneToOne(String persistentClass, ForeignKeyDirection foreignKeyType, String uniqueKeyPropertyName, boolean lazy, boolean isEmbeddedInXML, String entityName, String propertyName) {
        return new OneToOneType(persistentClass, foreignKeyType, uniqueKeyPropertyName, lazy, isEmbeddedInXML, entityName, propertyName);
    }

    public static EntityType manyToOne(String persistentClass) {
        return new ManyToOneType(persistentClass);
    }

    public static EntityType manyToOne(String persistentClass, boolean lazy) {
        return new ManyToOneType(persistentClass, lazy);
    }

    public static EntityType manyToOne(String persistentClass, String uniqueKeyPropertyName, boolean lazy, boolean isEmbeddedInXML, boolean ignoreNotFound) {
        return new ManyToOneType(persistentClass, uniqueKeyPropertyName, lazy, isEmbeddedInXML, ignoreNotFound);
    }

    public static Type basic(String name) {
        return (Type)BASIC_TYPES.get(name);
    }

    public static Type heuristicType(String typeName) throws MappingException {
        return TypeFactory.heuristicType(typeName, null);
    }

    public static Type heuristicType(String typeName, Properties parameters) throws MappingException {
        Type type = TypeFactory.basic(typeName);
        if (type == null) {
            Class typeClass;
            try {
                typeClass = ReflectHelper.classForName(typeName);
            }
            catch (ClassNotFoundException cnfe) {
                typeClass = null;
            }
            if (typeClass != null) {
                if ((class$org$hibernate$type$Type == null ? (class$org$hibernate$type$Type = TypeFactory.class$("org.hibernate.type.Type")) : class$org$hibernate$type$Type).isAssignableFrom(typeClass)) {
                    try {
                        type = (Type)typeClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new MappingException("Could not instantiate Type " + typeClass.getName() + ": " + e);
                    }
                } else if ((class$org$hibernate$usertype$CompositeUserType == null ? (class$org$hibernate$usertype$CompositeUserType = TypeFactory.class$("org.hibernate.usertype.CompositeUserType")) : class$org$hibernate$usertype$CompositeUserType).isAssignableFrom(typeClass)) {
                    type = new CompositeCustomType(typeClass, parameters);
                } else if ((class$org$hibernate$usertype$UserType == null ? (class$org$hibernate$usertype$UserType = TypeFactory.class$("org.hibernate.usertype.UserType")) : class$org$hibernate$usertype$UserType).isAssignableFrom(typeClass)) {
                    type = new CustomType(typeClass, parameters);
                } else if ((class$org$hibernate$classic$Lifecycle == null ? (class$org$hibernate$classic$Lifecycle = TypeFactory.class$("org.hibernate.classic.Lifecycle")) : class$org$hibernate$classic$Lifecycle).isAssignableFrom(typeClass)) {
                    type = Hibernate.entity(typeClass);
                } else if ((class$java$io$Serializable == null ? (class$java$io$Serializable = TypeFactory.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(typeClass)) {
                    type = Hibernate.serializable(typeClass);
                }
            }
        }
        return type;
    }

    public static CollectionType customCollection(String typeName, String role, String propertyRef, boolean embedded) {
        Class typeClass;
        try {
            typeClass = ReflectHelper.classForName(typeName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException("user colllection type class not found: " + typeName, cnfe);
        }
        return new CustomCollectionType(typeClass, role, propertyRef, embedded);
    }

    public static CollectionType array(String role, String propertyRef, boolean embedded, Class elementClass) {
        return new ArrayType(role, propertyRef, elementClass, embedded);
    }

    public static CollectionType list(String role, String propertyRef, boolean embedded) {
        return new ListType(role, propertyRef, embedded);
    }

    public static CollectionType bag(String role, String propertyRef, boolean embedded) {
        return new BagType(role, propertyRef, embedded);
    }

    public static CollectionType idbag(String role, String propertyRef, boolean embedded) {
        return new IdentifierBagType(role, propertyRef, embedded);
    }

    public static CollectionType map(String role, String propertyRef, boolean embedded) {
        return new MapType(role, propertyRef, embedded);
    }

    public static CollectionType set(String role, String propertyRef, boolean embedded) {
        return new SetType(role, propertyRef, embedded);
    }

    public static CollectionType sortedMap(String role, String propertyRef, boolean embedded, Comparator comparator) {
        return new SortedMapType(role, propertyRef, comparator, embedded);
    }

    public static CollectionType sortedSet(String role, String propertyRef, boolean embedded, Comparator comparator) {
        return new SortedSetType(role, propertyRef, comparator, embedded);
    }

    public static void deepCopy(Object[] values, Type[] types, boolean[] copy, Object[] target, SessionImplementor session) throws HibernateException {
        for (int i = 0; i < types.length; ++i) {
            if (!copy[i]) continue;
            target[i] = values[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || values[i] == BackrefPropertyAccessor.UNKNOWN ? values[i] : types[i].deepCopy(values[i], session.getEntityMode(), session.getFactory());
        }
    }

    public static Object[] assemble(Serializable[] row, Type[] types, SessionImplementor session, Object owner) throws HibernateException {
        Object[] assembled = new Object[row.length];
        for (int i = 0; i < types.length; ++i) {
            assembled[i] = row[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || row[i] == BackrefPropertyAccessor.UNKNOWN ? row[i] : types[i].assemble(row[i], session, owner);
        }
        return assembled;
    }

    public static Serializable[] disassemble(Object[] row, Type[] types, SessionImplementor session, Object owner) throws HibernateException {
        Serializable[] disassembled = new Serializable[row.length];
        for (int i = 0; i < row.length; ++i) {
            disassembled[i] = row[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || row[i] == BackrefPropertyAccessor.UNKNOWN ? (Serializable)row[i] : types[i].disassemble(row[i], session, owner);
        }
        return disassembled;
    }

    public static Object[] replace(Object[] original, Object[] target, Type[] types, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        Object[] copied = new Object[original.length];
        for (int i = 0; i < types.length; ++i) {
            copied[i] = original[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || original[i] == BackrefPropertyAccessor.UNKNOWN ? target[i] : types[i].replace(original[i], target[i], session, owner, copyCache);
        }
        return copied;
    }

    public static int[] findDirty(StandardProperty[] properties, Object[] x, Object[] y, boolean anyUninitializedProperties, SessionImplementor session) throws HibernateException {
        int[] results = null;
        int count = 0;
        int span = properties.length;
        for (int i = 0; i < span; ++i) {
            boolean dirty;
            boolean bl = dirty = x[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY && properties[i].isDirtyCheckable(anyUninitializedProperties) && properties[i].getType().isDirty(y[i], x[i], session);
            if (!dirty) continue;
            if (results == null) {
                results = new int[span];
            }
            results[count++] = i;
        }
        if (count == 0) {
            return null;
        }
        int[] trimmed = new int[count];
        System.arraycopy(results, 0, trimmed, 0, count);
        return trimmed;
    }

    public static int[] findModified(StandardProperty[] properties, Object[] x, Object[] y, boolean anyUninitializedProperties, SessionImplementor session) throws HibernateException {
        int[] results = null;
        int count = 0;
        int span = properties.length;
        for (int i = 0; i < span; ++i) {
            boolean modified;
            boolean bl = modified = x[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY && properties[i].isDirtyCheckable(anyUninitializedProperties) && properties[i].getType().isModified(y[i], x[i], session);
            if (!modified) continue;
            if (results == null) {
                results = new int[span];
            }
            results[count++] = i;
        }
        if (count == 0) {
            return null;
        }
        int[] trimmed = new int[count];
        System.arraycopy(results, 0, trimmed, 0, count);
        return trimmed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HashMap<String, Type> basics = new HashMap<String, Type>();
        basics.put(Boolean.TYPE.getName(), Hibernate.BOOLEAN);
        basics.put(Long.TYPE.getName(), Hibernate.LONG);
        basics.put(Short.TYPE.getName(), Hibernate.SHORT);
        basics.put(Integer.TYPE.getName(), Hibernate.INTEGER);
        basics.put(Byte.TYPE.getName(), Hibernate.BYTE);
        basics.put(Float.TYPE.getName(), Hibernate.FLOAT);
        basics.put(Double.TYPE.getName(), Hibernate.DOUBLE);
        basics.put(Character.TYPE.getName(), Hibernate.CHARACTER);
        basics.put(Hibernate.CHARACTER.getName(), Hibernate.CHARACTER);
        basics.put(Hibernate.INTEGER.getName(), Hibernate.INTEGER);
        basics.put(Hibernate.STRING.getName(), Hibernate.STRING);
        basics.put(Hibernate.DATE.getName(), Hibernate.DATE);
        basics.put(Hibernate.TIME.getName(), Hibernate.TIME);
        basics.put(Hibernate.TIMESTAMP.getName(), Hibernate.TIMESTAMP);
        basics.put(Hibernate.LOCALE.getName(), Hibernate.LOCALE);
        basics.put(Hibernate.CALENDAR.getName(), Hibernate.CALENDAR);
        basics.put(Hibernate.CALENDAR_DATE.getName(), Hibernate.CALENDAR_DATE);
        basics.put(Hibernate.CURRENCY.getName(), Hibernate.CURRENCY);
        basics.put(Hibernate.TIMEZONE.getName(), Hibernate.TIMEZONE);
        basics.put(Hibernate.CLASS.getName(), Hibernate.CLASS);
        basics.put(Hibernate.TRUE_FALSE.getName(), Hibernate.TRUE_FALSE);
        basics.put(Hibernate.YES_NO.getName(), Hibernate.YES_NO);
        basics.put(Hibernate.BINARY.getName(), Hibernate.BINARY);
        basics.put(Hibernate.TEXT.getName(), Hibernate.TEXT);
        basics.put(Hibernate.BLOB.getName(), Hibernate.BLOB);
        basics.put(Hibernate.CLOB.getName(), Hibernate.CLOB);
        basics.put(Hibernate.BIG_DECIMAL.getName(), Hibernate.BIG_DECIMAL);
        basics.put(Hibernate.BIG_INTEGER.getName(), Hibernate.BIG_INTEGER);
        basics.put(Hibernate.SERIALIZABLE.getName(), Hibernate.SERIALIZABLE);
        basics.put(Hibernate.OBJECT.getName(), Hibernate.OBJECT);
        basics.put((class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeFactory.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), Hibernate.BOOLEAN);
        basics.put((class$java$lang$Long == null ? (class$java$lang$Long = TypeFactory.class$("java.lang.Long")) : class$java$lang$Long).getName(), Hibernate.LONG);
        basics.put((class$java$lang$Short == null ? (class$java$lang$Short = TypeFactory.class$("java.lang.Short")) : class$java$lang$Short).getName(), Hibernate.SHORT);
        basics.put((class$java$lang$Integer == null ? (class$java$lang$Integer = TypeFactory.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), Hibernate.INTEGER);
        basics.put((class$java$lang$Byte == null ? (class$java$lang$Byte = TypeFactory.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), Hibernate.BYTE);
        basics.put((class$java$lang$Float == null ? (class$java$lang$Float = TypeFactory.class$("java.lang.Float")) : class$java$lang$Float).getName(), Hibernate.FLOAT);
        basics.put((class$java$lang$Double == null ? (class$java$lang$Double = TypeFactory.class$("java.lang.Double")) : class$java$lang$Double).getName(), Hibernate.DOUBLE);
        basics.put((class$java$lang$Character == null ? (class$java$lang$Character = TypeFactory.class$("java.lang.Character")) : class$java$lang$Character).getName(), Hibernate.CHARACTER);
        basics.put((class$java$lang$String == null ? (class$java$lang$String = TypeFactory.class$("java.lang.String")) : class$java$lang$String).getName(), Hibernate.STRING);
        basics.put((class$java$util$Date == null ? (class$java$util$Date = TypeFactory.class$("java.util.Date")) : class$java$util$Date).getName(), Hibernate.TIMESTAMP);
        basics.put((class$java$sql$Time == null ? (class$java$sql$Time = TypeFactory.class$("java.sql.Time")) : class$java$sql$Time).getName(), Hibernate.TIME);
        basics.put((class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = TypeFactory.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).getName(), Hibernate.TIMESTAMP);
        basics.put((class$java$sql$Date == null ? (class$java$sql$Date = TypeFactory.class$("java.sql.Date")) : class$java$sql$Date).getName(), Hibernate.DATE);
        basics.put((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TypeFactory.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName(), Hibernate.BIG_DECIMAL);
        basics.put((class$java$math$BigInteger == null ? (class$java$math$BigInteger = TypeFactory.class$("java.math.BigInteger")) : class$java$math$BigInteger).getName(), Hibernate.BIG_INTEGER);
        basics.put((class$java$util$Locale == null ? (class$java$util$Locale = TypeFactory.class$("java.util.Locale")) : class$java$util$Locale).getName(), Hibernate.LOCALE);
        basics.put((class$java$util$Calendar == null ? (class$java$util$Calendar = TypeFactory.class$("java.util.Calendar")) : class$java$util$Calendar).getName(), Hibernate.CALENDAR);
        basics.put((class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = TypeFactory.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar).getName(), Hibernate.CALENDAR);
        if (CurrencyType.CURRENCY_CLASS != null) {
            basics.put(CurrencyType.CURRENCY_CLASS.getName(), Hibernate.CURRENCY);
        }
        basics.put((class$java$util$TimeZone == null ? (class$java$util$TimeZone = TypeFactory.class$("java.util.TimeZone")) : class$java$util$TimeZone).getName(), Hibernate.TIMEZONE);
        basics.put((class$java$lang$Object == null ? (class$java$lang$Object = TypeFactory.class$("java.lang.Object")) : class$java$lang$Object).getName(), Hibernate.OBJECT);
        basics.put((class$java$lang$Class == null ? (class$java$lang$Class = TypeFactory.class$("java.lang.Class")) : class$java$lang$Class).getName(), Hibernate.CLASS);
        basics.put((array$B == null ? (array$B = TypeFactory.class$("[B")) : array$B).getName(), Hibernate.BINARY);
        basics.put("byte[]", Hibernate.BINARY);
        basics.put((class$java$sql$Blob == null ? (class$java$sql$Blob = TypeFactory.class$("java.sql.Blob")) : class$java$sql$Blob).getName(), Hibernate.BLOB);
        basics.put((class$java$sql$Clob == null ? (class$java$sql$Clob = TypeFactory.class$("java.sql.Clob")) : class$java$sql$Clob).getName(), Hibernate.CLOB);
        basics.put((class$java$io$Serializable == null ? (class$java$io$Serializable = TypeFactory.class$("java.io.Serializable")) : class$java$io$Serializable).getName(), Hibernate.SERIALIZABLE);
        BASIC_TYPES = Collections.unmodifiableMap(basics);
    }
}

