///////////////////////////////
//  Makumba, Makumba tag library
//  Copyright (C) 2000-2003  http://www.makumba.org
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//  -------------
//  $Id: AddTag.java,v 2.9 2005/06/25 13:16:50 rosso_nero Exp $
//  $Name: makumba-0_5_15 $
/////////////////////////////////////

package org.makumba.view.jsptaglib;
import org.makumba.DataDefinition;
import org.makumba.util.MultipleKey;

public class AddTag extends FormTagBase 
{
  /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
// for input tags:
  String field = null;
  String multipleSubmitMsg = null;
  
  public void setField(String s) { field=s; }
  public void setMultipleSubmitMsg(String s) { checkNoParent("multipleSubmitMsg"); multipleSubmitMsg=s; }

  /** Set tagKey to uniquely identify this tag. Called at analysis time before doStartAnalyze() and at runtime before doMakumbaStartTag() */
  public void setTagKey(MakumbaJspAnalyzer.PageCache pageCache)
  {
    Object[] keyComponents= {baseObject, field, handler, getParentListKey(null), getClass()};
    tagKey=new MultipleKey(keyComponents);
  }

  public void initialiseState() {
      super.initialiseState();
	  if (multipleSubmitMsg != null) responder.setMultipleSubmitMsg(multipleSubmitMsg);
      if (field != null) responder.setAddField(field);
      if (!"add".equals(getOperation())) 
	responder.setNewType(((NewTag)findParentForm()).type);
  }

  public DataDefinition getDataTypeAtAnalysis(MakumbaJspAnalyzer.PageCache pageCache)
  {
    DataDefinition base= getOperation().equals("add")?pageCache.getQuery(getParentListKey(pageCache)).getLabelType(baseObject):
      ((NewTag)findParentForm()).type;
    return base.getFieldDefinition(field).getSubtable();
  }
  
  String getOperation(){
    FormTagBase parent=findParentForm();
    if((parent instanceof NewTag) && baseObject.equals(parent.formName))
       return "addToNew";
    return "add";
  }
  
  boolean shouldComputeBasePointer(){ return getOperation().equals("add"); }
}


