/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.makumba.DBError;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.NotUniqueError;
import org.makumba.Pointer;
import org.makumba.Text;
import org.makumba.db.DBConnection;
import org.makumba.db.DBConnectionWrapper;
import org.makumba.db.Table;
import org.makumba.db.sql.Database;
import org.makumba.db.sql.SQLDBConnection;
import org.makumba.db.sql.SQLPointer;

public class TableManager
extends Table {
    protected String tbname;
    protected String handlerList;
    protected String indexDBField;
    protected String indexField;
    protected String modTable;
    protected long primaryKeyCurrentIndex;
    protected int dbsv;
    boolean alter;
    boolean exists_;
    Hashtable handlerExist = new Hashtable();
    Dictionary keyIndex;
    String preparedInsertString;
    String preparedDeleteString;
    String preparedDeleteFromString;
    String preparedDeleteFromIgnoreDbsvString;
    Hashtable checkDuplicate = new Hashtable();
    Hashtable checkNullDuplicate = new Hashtable();
    boolean admin;
    Hashtable indexes = new Hashtable();
    Hashtable extraIndexes;

    public boolean exists() {
        return this.exists_;
    }

    public boolean exists(String string) {
        return this.handlerExist.get(string) != null;
    }

    public String getDBName() {
        return this.tbname;
    }

    protected Database getSQLDatabase() {
        return (Database)this.getDatabase();
    }

    protected boolean usesHidden() {
        return true;
    }

    void makeKeyIndex() {
        if (this.keyIndex == null) {
            this.keyIndex = new Hashtable();
            for (int i = 0; i < this.getDataDefinition().getFieldNames().size(); ++i) {
                FieldDefinition fieldDefinition = this.getDataDefinition().getFieldDefinition(i);
                if (fieldDefinition.getType().startsWith("set")) continue;
                this.keyIndex.put(fieldDefinition.getName(), new Integer(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open(Properties properties) {
        this.setTableAndFieldNames(properties);
        if (!this.getDataDefinition().isTemporary()) {
            DBConnectionWrapper dBConnectionWrapper = (DBConnectionWrapper)this.getSQLDatabase().getDBConnection();
            SQLDBConnection sQLDBConnection = (SQLDBConnection)dBConnectionWrapper.getWrapped();
            try {
                this.checkStructure(sQLDBConnection, properties);
                this.initFields(sQLDBConnection, properties);
                this.preparedInsertString = this.prepareInsert();
                this.preparedDeleteString = this.prepareDelete();
                this.preparedDeleteFromIgnoreDbsvString = "DELETE FROM " + this.getDBName();
                this.preparedDeleteFromString = "DELETE FROM " + this.getDBName() + " WHERE " + this.indexDBField + " >= ?" + " AND " + this.indexDBField + " <= ?";
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                dBConnectionWrapper.close();
            }
        } else {
            this.makeKeyIndex();
        }
    }

    protected void setTableAndFieldNames(Properties properties) {
        String string;
        Object object;
        this.tbname = properties.getProperty(this.getDataDefinition().getName());
        if (this.tbname == null) {
            object = Database.findConfig(properties, this.getDataDefinition().getName());
            string = this.getDataDefinition().getName();
            if (object != null) {
                string = properties.getProperty((String)object) + this.getDataDefinition().getName().substring(((String)object).length());
            }
            this.tbname = this.getSQLDatabase().getTableName(string);
        } else if (this.tbname.indexOf(46) != -1) {
            this.tbname = this.getSQLDatabase().getTableName(this.tbname);
        }
        object = this.dd.getFieldNames().elements();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            if (this.getFieldDefinition(string).getType().startsWith("set")) continue;
            this.setFieldDBName(string, properties);
        }
    }

    public boolean canAdmin() {
        return this.admin;
    }

    protected void checkStructure(SQLDBConnection sQLDBConnection, Properties properties) {
        String string = Database.findConfig(properties, "admin#" + this.getDataDefinition().getName());
        this.admin = string != null && properties.getProperty(string).trim().equals("true");
        string = Database.findConfig(properties, "alter#" + this.getDataDefinition().getName());
        this.alter = string != null && properties.getProperty(string).trim().equals("true");
        MakumbaSystem.getMakumbaLogger("db.init.tablechecking").info(this.getDatabase().getConfiguration() + ": checking " + this.getDataDefinition().getName() + " as " + this.tbname);
        try {
            CatalogChecker catalogChecker = null;
            if (this.getSQLDatabase().catalog == null) {
                throw new MakumbaError(this.getDatabase().getName() + ": could not open catalog");
            }
            catalogChecker = new CatalogChecker(this.getSQLDatabase().catalog);
            if (catalogChecker.shouldCreate()) {
                this.create(sQLDBConnection, this.tbname, this.alter);
                this.exists_ = this.alter;
                properties.put("makumba.wasCreated", "");
                this.makeKeyIndex();
            } else {
                this.exists_ = true;
                this.alter(sQLDBConnection, catalogChecker);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new DBError(sQLException);
        }
    }

    protected void initFields(SQLDBConnection sQLDBConnection, Properties properties) throws SQLException {
        String string;
        Object object;
        try {
            object = sQLDBConnection.getMetaData().getIndexInfo(null, null, this.getDBName(), false, false);
            while (object.next()) {
                string = object.getString("INDEX_NAME");
                boolean bl = object.getBoolean("NON_UNIQUE");
                if (string == null) continue;
                this.indexes.put(string.toLowerCase(), new Boolean(bl));
            }
            object.close();
        }
        catch (SQLException sQLException) {
            Database.logException(sQLException, sQLDBConnection);
            throw new DBError(sQLException);
        }
        this.extraIndexes = (Hashtable)this.indexes.clone();
        object = this.dd.getFieldNames().elements();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            if (this.getFieldDefinition(string).getType().startsWith("set")) continue;
            this.onStartup(string, properties, sQLDBConnection);
        }
        if (this.alter) {
            object = this.extraIndexes.keys();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                try {
                    Statement statement = sQLDBConnection.createStatement();
                    statement.executeUpdate("DROP INDEX " + string + " ON " + this.getDBName());
                    MakumbaSystem.getMakumbaLogger("db.init.tablechecking").info("INDEX DROPPED on " + this.getDataDefinition().getName() + "#" + string);
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        } else {
            object = new StringBuffer();
            string = "";
            Enumeration enumeration = this.extraIndexes.keys();
            while (enumeration.hasMoreElements()) {
                ((StringBuffer)object).append(string).append(enumeration.nextElement());
                string = ", ";
            }
            if (((StringBuffer)object).length() > 0) {
                MakumbaSystem.getMakumbaLogger("db.init.tablechecking").warning("Extra indexes on " + this.getDataDefinition().getName() + ": " + object);
            }
        }
        object = new StringBuffer();
        this.fieldList((StringBuffer)object, this.dd.getFieldNames().elements());
        this.handlerList = ((StringBuffer)object).toString();
        this.indexField = this.dd.getIndexPointerFieldName();
        this.indexDBField = this.getFieldDBName(this.indexField);
    }

    public int deleteFrom(DBConnection dBConnection, DBConnection dBConnection2, boolean bl) {
        if (!this.exists()) {
            return 0;
        }
        if (!this.canAdmin()) {
            throw new MakumbaError("no administration approval for " + this.getDataDefinition().getName());
        }
        if (dBConnection instanceof DBConnectionWrapper) {
            dBConnection = ((DBConnectionWrapper)dBConnection).getWrapped();
        }
        PreparedStatement preparedStatement = null;
        if (bl) {
            preparedStatement = ((SQLDBConnection)dBConnection).getPreparedStatement(this.preparedDeleteFromIgnoreDbsvString);
        } else {
            preparedStatement = ((SQLDBConnection)dBConnection).getPreparedStatement(this.preparedDeleteFromString);
            try {
                preparedStatement.setInt(1, dBConnection2.getHostDatabase().getMinPointerValue());
                preparedStatement.setInt(2, dBConnection2.getHostDatabase().getMaxPointerValue());
            }
            catch (SQLException sQLException) {
                Database.logException(sQLException);
                throw new DBError(sQLException);
            }
        }
        int n = this.getSQLDatabase().exec(preparedStatement);
        this.resetPrimaryKey();
        return n;
    }

    protected void alter(SQLDBConnection sQLDBConnection, CheckingStrategy checkingStrategy) throws SQLException {
        Object object;
        Object object2;
        Vector<String> vector = new Vector<String>();
        Vector<Object> vector2 = new Vector<Object>();
        Vector<String> vector3 = new Vector<String>();
        Vector<Object> vector4 = new Vector<Object>();
        Object object3 = new Object();
        while (checkingStrategy.hasMoreColumns()) {
            object2 = checkingStrategy.columnName();
            boolean bl = false;
            object = this.dd.getFieldNames().elements();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                if (this.getFieldDefinition(string).getType().startsWith("set") || !this.getFieldDBName(string).toLowerCase().equals(((String)object2).toLowerCase())) continue;
                this.handlerExist.put(string, object3);
                vector.addElement(string);
                if (!(checkingStrategy.checkColumn(string) || this.alter && this.alter(sQLDBConnection, string, this.getColumnAlterKeyword()))) {
                    MakumbaSystem.getMakumbaLogger("db.init.tablechecking").warning("should modify: " + string + " " + this.getFieldDBName(string) + " " + this.getFieldDBType(string) + " " + checkingStrategy.columnType() + " " + checkingStrategy.columnName());
                    vector3.addElement(string);
                }
                bl = true;
            }
            if (bl) continue;
            vector4.addElement(object2);
            MakumbaSystem.getMakumbaLogger("db.init.tablechecking").warning("extra field: " + checkingStrategy.columnName() + " " + checkingStrategy.columnType() + " " + checkingStrategy.columnTypeName());
        }
        object2 = new Vector();
        this.keyIndex = new Hashtable();
        Enumeration enumeration = this.dd.getFieldNames().elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (this.getFieldDefinition((String)object).getType().startsWith("set")) continue;
            if (!(this.handlerExist.get(object) != null || this.alter && this.alter(sQLDBConnection, (String)object, "ADD"))) {
                vector2.addElement(object);
                MakumbaSystem.getMakumbaLogger("db.init.tablechecking").warning("should add " + (String)object + " " + this.getFieldDBName((String)object) + " " + this.getFieldDBType((String)object));
                continue;
            }
            this.keyIndex.put(object, new Integer(((Vector)object2).size()));
            ((Vector)object2).addElement(object);
        }
        this.doAlter(sQLDBConnection, vector4, vector, vector2, vector3);
    }

    protected String getColumnAlterKeyword() {
        return "MODIFY";
    }

    boolean alter(SQLDBConnection sQLDBConnection, String string, String string2) throws SQLException {
        Statement statement = sQLDBConnection.createStatement();
        String string3 = "ALTER TABLE " + this.getDBName() + " " + string2 + " " + this.inCreate(string, this.getSQLDatabase());
        MakumbaSystem.getMakumbaLogger("db.init.tablechecking").info(this.getSQLDatabase().getConfiguration() + ": " + string3);
        try {
            String string4 = "DROP INDEX " + this.getFieldDBIndexName(string) + " ON " + this.getDBName();
            statement.executeUpdate(string4);
            MakumbaSystem.getMakumbaLogger("db.init.tablechecking").info("SUCCESS: " + string4);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.executeUpdate(string3);
        this.handlerExist.put(string, "");
        sQLDBConnection.commit();
        statement.close();
        return true;
    }

    protected void doAlter(SQLDBConnection sQLDBConnection, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws SQLException {
        if (vector3.size() == 0 && vector4.size() == 0) {
            return;
        }
        if (vector2.size() == 0) {
            this.create(sQLDBConnection, this.tbname, this.alter);
        }
    }

    protected void indexCreated(SQLDBConnection sQLDBConnection) {
    }

    protected String createDbSpecific(String string) {
        return string;
    }

    protected String getTableMissingStateName(SQLDBConnection sQLDBConnection) {
        return "tableMissing";
    }

    protected void create(SQLDBConnection sQLDBConnection, String string, boolean bl) throws SQLException {
        Statement statement = sQLDBConnection.createStatement();
        Object[] objectArray = new Object[]{this.getSQLDatabase()};
        if (bl) {
            try {
                statement.executeUpdate("DROP TABLE " + string);
            }
            catch (SQLException sQLException) {
                this.getSQLDatabase().checkState(sQLException, this.getTableMissingStateName(sQLDBConnection));
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        Object object = this.dd.getFieldNames().elements();
        while (object.hasMoreElements()) {
            String string3 = (String)object.nextElement();
            if (this.getFieldDefinition(string3).getType().startsWith("set")) continue;
            stringBuffer.append(string2).append(this.inCreate(string3, this.getSQLDatabase()));
            string2 = ",";
        }
        object = "CREATE TABLE " + string + "(" + stringBuffer + ")";
        object = this.createDbSpecific((String)object);
        if (!bl) {
            MakumbaSystem.getMakumbaLogger("db.init.tablechecking").warning("would be:\n" + (String)object);
            return;
        }
        MakumbaSystem.getMakumbaLogger("db.init.tablechecking").info((String)object);
        statement.executeUpdate((String)object);
        sQLDBConnection.commit();
        statement.close();
    }

    protected void fieldList(StringBuffer stringBuffer, Enumeration enumeration) {
        String string = "";
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (this.getFieldDefinition(string2).getType().startsWith("set")) continue;
            stringBuffer.append(string);
            string = ", ";
            stringBuffer.append(this.getFieldDBName(string2));
        }
    }

    boolean checkTableDBName(String string) {
        Enumeration enumeration = this.dd.getFieldNames().elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (this.getFieldDefinition(string2).getType().startsWith("set") || this.getFieldDBName(string2) == null || !this.getFieldDBName(string2).toLowerCase().equals(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected String prepareInsert() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        Enumeration enumeration = this.dd.getFieldNames().elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (this.getFieldDefinition(string2).getType().startsWith("set")) continue;
            stringBuffer.append(string).append(this.inPreparedInsert(string2));
            string = ",";
        }
        return "INSERT INTO " + this.tbname + " (" + this.handlerList + ") VALUES (" + stringBuffer + ")";
    }

    public Pointer insertRecordImpl(DBConnection dBConnection, Dictionary dictionary) {
        boolean bl = dictionary.get(this.indexField) != null;
        boolean bl2 = dictionary.get("TS_create") != null;
        boolean bl3 = dictionary.get("TS_create") != null;
        try {
            if (dBConnection instanceof DBConnectionWrapper) {
                dBConnection = ((DBConnectionWrapper)dBConnection).getWrapped();
            }
            PreparedStatement preparedStatement = ((SQLDBConnection)dBConnection).getPreparedStatement(this.preparedInsertString);
            int n = 0;
            Object object = this.dd.getFieldNames().elements();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                if (this.getFieldDefinition(string).getType().startsWith("set")) continue;
                ++n;
                try {
                    this.setInsertArgument(string, preparedStatement, n, dictionary);
                }
                catch (Throwable throwable) {
                    throw new DBError(throwable, "insert into \"" + this.getDataDefinition().getName() + "\" at field \"" + string + "\" could not assign value \"" + dictionary.get(string) + "\" " + (dictionary.get(string) != null ? "of type \"" + dictionary.get(string).getClass().getName() + "\"" : ""));
                }
            }
            if (this.getSQLDatabase().exec(preparedStatement) == -1) {
                throw this.findDuplicates((SQLDBConnection)dBConnection, dictionary);
            }
            object = (Pointer)dictionary.get(this.indexField);
            if (!bl) {
                dictionary.remove(this.indexField);
            }
            if (!bl2) {
                dictionary.remove("TS_create");
            }
            if (!bl3) {
                dictionary.remove("TS_modify");
            }
            return object;
        }
        catch (Throwable throwable) {
            DBError dBError;
            if (!(throwable instanceof DBError)) {
                dBError = new DBError(throwable);
            }
            throw (DBError)dBError;
        }
    }

    protected NotUniqueError findDuplicates(SQLDBConnection sQLDBConnection, Dictionary dictionary) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = this.dd.getFieldNames().elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = dictionary.get(string);
            if (this.getFieldDefinition(string).getType().startsWith("set") || !this.checkDuplicate(string, sQLDBConnection, dictionary)) continue;
            ((Dictionary)hashtable).put(string, v == null ? "null" : v);
        }
        return new NotUniqueError(this.getDataDefinition().getName(), hashtable);
    }

    protected String prepareDelete() {
        return "DELETE FROM " + this.tbname + " WHERE " + this.inPreparedUpdate(this.indexField);
    }

    public void deleteRecord(DBConnection dBConnection, Pointer pointer) {
        if (dBConnection instanceof DBConnectionWrapper) {
            dBConnection = ((DBConnectionWrapper)dBConnection).getWrapped();
        }
        PreparedStatement preparedStatement = ((SQLDBConnection)dBConnection).getPreparedStatement(this.preparedDeleteString);
        try {
            this.setUpdateArgument(this.getDBName(), preparedStatement, 1, pointer);
            this.getSQLDatabase().exec(preparedStatement);
        }
        catch (SQLException sQLException) {
            Database.logException(sQLException);
            throw new DBError(sQLException);
        }
    }

    public void updateRecord(DBConnection dBConnection, Pointer pointer, Dictionary dictionary) {
        Object object;
        if (dBConnection instanceof DBConnectionWrapper) {
            dBConnection = ((DBConnectionWrapper)dBConnection).getWrapped();
        }
        dictionary.remove(this.indexField);
        dictionary.remove("TS_create");
        dictionary.put("TS_modify", new Date());
        StringBuffer stringBuffer = new StringBuffer("UPDATE ").append(this.tbname).append(" SET ");
        String string = "";
        Object object2 = dictionary.keys();
        while (object2.hasMoreElements()) {
            String string2;
            if (string.length() > 0) {
                stringBuffer.append(",");
            }
            if ((object = this.getFieldDBName(string2 = (String)object2.nextElement())) == null) {
                throw new DBError(new Exception("no such field " + (String)object + " in " + this.getDBName()));
            }
            string = this.inPreparedUpdate(string2);
            stringBuffer.append(string);
        }
        stringBuffer.append(" WHERE " + this.inPreparedUpdate(this.indexField));
        try {
            object2 = ((SQLDBConnection)dBConnection).getPreparedStatement(stringBuffer.toString());
            int n = 1;
            object = dictionary.keys();
            while (object.hasMoreElements()) {
                this.setUpdateArgument((String)object.nextElement(), (PreparedStatement)object2, n, dictionary);
                ++n;
            }
            this.setUpdateArgument(this.getDBName(), (PreparedStatement)object2, n, pointer);
            if (this.getSQLDatabase().exec((PreparedStatement)object2) == -1) {
                throw this.findDuplicates((SQLDBConnection)dBConnection, dictionary);
            }
            return;
        }
        catch (SQLException sQLException) {
            throw new DBError(sQLException);
        }
    }

    protected void fillResult(ResultSet resultSet, Dictionary dictionary) throws SQLException {
        int n = this.dd.getFieldNames().size();
        int n2 = 0;
        while (n2 < n) {
            if (this.dd.getFieldDefinition(n2).getType().startsWith("set")) continue;
            this.setValue(this.dd.getFieldDefinition(n2).getName(), dictionary, resultSet, ++n2);
        }
    }

    protected void fillResult(ResultSet resultSet, Object[] objectArray) throws SQLException {
        int n = this.dd.getFieldNames().size();
        for (int i = 0; i < n; ++i) {
            if (this.dd.getFieldDefinition(i).getType().startsWith("set")) continue;
            try {
                objectArray[i] = this.getValue(this.dd.getFieldDefinition(i).getName(), resultSet, i + 1);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                MakumbaSystem.getMakumbaLogger("db.query.execution").log(Level.SEVERE, "" + i + " " + this.dd.getName() + " " + this.keyIndex + " " + this.dd.getFieldNames(), arrayIndexOutOfBoundsException);
                throw arrayIndexOutOfBoundsException;
            }
        }
    }

    public Object getValue(ResultSet resultSet, String string, int n) {
        try {
            return this.getValue(string, resultSet, n);
        }
        catch (SQLException sQLException) {
            throw new DBError(sQLException);
        }
    }

    public Object getValue(String string, ResultSet resultSet, int n) throws SQLException {
        if (!this.getFieldDefinition(string).getType().startsWith("set")) {
            switch (this.getFieldDefinition(string).getIntegerType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return this.get_ptrDB_Value(string, resultSet, n);
                }
                case 4: 
                case 5: {
                    return this.get_int_Value(string, resultSet, n);
                }
                case 6: 
                case 7: {
                    return this.get_char_Value(string, resultSet, n);
                }
                case 8: {
                    return this.get_text_Value(string, resultSet, n);
                }
                case 9: {
                    return this.get_dateTime_Value(string, resultSet, n);
                }
                case 10: 
                case 11: {
                    return this.get_timeStamp_Value(string, resultSet, n);
                }
                case 14: {
                    return this.get_nil_Value(string, resultSet, n);
                }
                case 15: {
                    return this.get_real_Value(string, resultSet, n);
                }
            }
            return this.base_getValue(string, resultSet, n);
        }
        throw new RuntimeException("shouldn't be here");
    }

    private Object get_real_Value(String string, ResultSet resultSet, int n) throws SQLException {
        double d = resultSet.getDouble(n);
        if (resultSet.wasNull()) {
            return null;
        }
        return new Double(d);
    }

    public Object base_getValue(String string, ResultSet resultSet, int n) throws SQLException {
        Object object = resultSet.getObject(n);
        if (resultSet.wasNull()) {
            return null;
        }
        return object;
    }

    public Object get_ptrDB_Value(String string, ResultSet resultSet, int n) throws SQLException {
        Object object = this.base_getValue(string, resultSet, n);
        if (object == null) {
            return object;
        }
        return new SQLPointer(this.dd.getFieldDefinition(string).getPointedType().getName(), ((Number)object).longValue());
    }

    public Object get_int_Value(String string, ResultSet resultSet, int n) throws SQLException {
        int n2 = resultSet.getInt(n);
        if (resultSet.wasNull()) {
            return null;
        }
        return new Integer(n2);
    }

    public Object get_char_Value(String string, ResultSet resultSet, int n) throws SQLException {
        Object object = this.base_getValue(string, resultSet, n);
        if (object == null) {
            return object;
        }
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        return object;
    }

    public Object get_text_Value(String string, ResultSet resultSet, int n) throws SQLException {
        Object object = this.base_getValue(string, resultSet, n);
        if (object == null) {
            return object;
        }
        return Text.getText(object);
    }

    public Object get_dateTime_Value(String string, ResultSet resultSet, int n) throws SQLException {
        Object object = resultSet.getObject(n);
        if (resultSet.wasNull()) {
            return null;
        }
        return object;
    }

    public Object get_nil_Value(String string, ResultSet resultSet, int n) {
        return null;
    }

    public Object get_timeStamp_Value(String string, ResultSet resultSet, int n) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(n);
        if (resultSet.wasNull()) {
            return null;
        }
        return timestamp;
    }

    public void setUpdateArgument(String string, PreparedStatement preparedStatement, int n, Object object) throws SQLException {
        if (object == this.getFieldDefinition(string).getNull()) {
            this.setNullArgument(string, preparedStatement, n);
        } else {
            try {
                this.setArgument(string, preparedStatement, n, object);
            }
            catch (SQLException sQLException) {
                MakumbaSystem.getMakumbaLogger("db.update.execution").log(Level.SEVERE, this.getDBName() + "  " + object.getClass(), sQLException);
                throw sQLException;
            }
        }
    }

    public void setUpdateArgument(String string, PreparedStatement preparedStatement, int n, Dictionary dictionary) throws SQLException {
        switch (this.getFieldDefinition(string).getIntegerType()) {
            case 3: 
            case 10: {
                throw new RuntimeException("shouldn't be called");
            }
            case 11: {
                this.nxt(string, dictionary);
            }
        }
        this.setUpdateArgument(string, preparedStatement, n, dictionary.get(string));
    }

    public void setNullArgument(String string, PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setNull(n, this.getSQLType(string));
    }

    public void setArgument(String string, PreparedStatement preparedStatement, int n, Object object) throws SQLException {
        if (this.getFieldDefinition(string).getIntegerType() == 8) {
            this.set_text_Argument(string, preparedStatement, n, object);
        } else {
            preparedStatement.setObject(n, this.toSQLObject(string, object));
        }
    }

    public void set_text_Argument(String string, PreparedStatement preparedStatement, int n, Object object) throws SQLException {
        Text text = Text.getText(object);
        preparedStatement.setBinaryStream(n, text.toBinaryStream(), text.length());
    }

    protected int getSQLType(String string) {
        switch (this.getFieldDefinition(string).getIntegerType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.get_ptrDB_SQLType(string);
            }
            case 4: 
            case 5: {
                return this.get_int_SQLType(string);
            }
            case 6: 
            case 7: {
                return this.get_char_SQLType(string);
            }
            case 8: {
                return this.get_text_SQLType(string);
            }
            case 9: {
                return this.get_dateTime_SQLType(string);
            }
            case 15: {
                return this.get_real_SQLType(string);
            }
            case 10: 
            case 11: {
                return this.get_timeStamp_SQLType(string);
            }
        }
        throw new RuntimeException("" + string + " should be redefined");
    }

    public int get_ptrDB_SQLType(String string) {
        return 4;
    }

    protected int get_int_SQLType(String string) {
        return 4;
    }

    protected int get_char_SQLType(String string) {
        return 12;
    }

    protected int get_text_SQLType(String string) {
        return -4;
    }

    public int get_dateTime_SQLType(String string) {
        return 93;
    }

    protected int get_real_SQLType(String string) {
        return 8;
    }

    public int get_timeStamp_SQLType(String string) {
        return 93;
    }

    public Object toSQLObject(String string, Object object) {
        switch (this.getFieldDefinition(string).getIntegerType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.toSQL_ptrDB_Object(string, object);
            }
            case 9: {
                return this.toSQL_dateTime_Object(string, object);
            }
        }
        return object;
    }

    public Object base_toSQLObject(String string, Object object) {
        return object;
    }

    public Object toSQL_ptrDB_Object(String string, Object object) {
        return new Integer((int)((Pointer)object).longValue());
    }

    public Object toSQL_dateTime_Object(String string, Object object) {
        return new Timestamp(((Date)object).getTime());
    }

    public void setFieldDBName(String string, Properties properties) {
        String string2 = null;
        string2 = properties.getProperty(this.getDBName() + "#" + this.getFieldDBName(string));
        if (string2 == null) {
            string2 = this.getSQLDatabase().getFieldName(string);
            while (this.checkTableDBName(string2)) {
                string2 = string2 + "_";
            }
        }
        this.fieldDBNames.put(string, string2);
    }

    public String getFieldDBName(String string) {
        return (String)this.fieldDBNames.get(string);
    }

    public String inCreate(String string, Database database) {
        switch (this.getFieldDefinition(string).getIntegerType()) {
            case 6: 
            case 7: {
                return this.in_char_Create(string, database);
            }
        }
        return this.base_inCreate(string, database);
    }

    public String base_inCreate(String string, Database database) {
        return this.getFieldDBName(string) + " " + this.getFieldDBType(string, database);
    }

    public String in_char_Create(String string, Database database) {
        String string2 = Database.getEngineProperty(database.getEngine() + "." + "charBinary");
        string2 = string2 != null && string2.equals("true") ? " BINARY" : "";
        return this.getFieldDBName(string) + " " + this.getFieldDBType(string, database) + "(" + this.getFieldDefinition(string).getWidth() + ")" + string2;
    }

    public String inPreparedUpdate(String string) {
        return this.getFieldDBName(string) + "=?";
    }

    protected String getFieldDBType(String string) {
        switch (this.getFieldDefinition(string).getIntegerType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.get_ptrDB_FieldDBType(string);
            }
            case 4: 
            case 5: {
                return this.get_int_FieldDBType(string);
            }
            case 6: 
            case 7: {
                return this.get_char_FieldDBType(string);
            }
            case 8: {
                return this.get_text_FieldDBType(string);
            }
            case 9: {
                return this.get_dateTime_FieldDBType(string);
            }
            case 10: 
            case 11: {
                return this.get_timeStamp_FieldDBType(string);
            }
            case 15: {
                return this.get_real_FieldDBType(string);
            }
        }
        throw new RuntimeException("" + string + " should be redefined");
    }

    protected String get_ptrDB_FieldDBType(String string) {
        return "INTEGER";
    }

    protected String get_int_FieldDBType(String string) {
        return "INTEGER";
    }

    protected String get_char_FieldDBType(String string) {
        return "VARCHAR";
    }

    protected String get_text_FieldDBType(String string) {
        return "LONG VARBINARY";
    }

    protected String get_dateTime_FieldDBType(String string) {
        return "DATETIME";
    }

    protected String get_real_FieldDBType(String string) {
        return "DOUBLE PRECISION";
    }

    protected String get_timeStamp_FieldDBType(String string) {
        return "TIMESTAMP";
    }

    protected String getFieldDBType(String string, Database database) {
        String string2 = Database.getEngineProperty(database.getEngine() + "." + this.getFieldDefinition(string).getDataType());
        if (string2 == null) {
            return this.getFieldDBType(string);
        }
        return string2;
    }

    public String getFieldDBIndexName(String string) {
        return this.getFieldDBName(string);
    }

    public String inPreparedInsert(String string) {
        return "?";
    }

    public void setInsertArgument(String string, PreparedStatement preparedStatement, int n, Dictionary dictionary) throws SQLException {
        switch (this.getFieldDefinition(string).getIntegerType()) {
            case 10: 
            case 11: {
                if (dictionary.get(string) == null) {
                    this.nxt(string, dictionary);
                }
                this.set_timeStamp_InsertArgument(string, preparedStatement, n, dictionary);
                break;
            }
            case 3: {
                Pointer pointer = (Pointer)dictionary.get(string);
                if (pointer != null) {
                    this.base_setInsertArgument(string, preparedStatement, n, dictionary);
                    if (pointer.getDbsv() == this.dbsv && pointer.longValue() > this.primaryKeyCurrentIndex) {
                        this.primaryKeyCurrentIndex = pointer.longValue();
                    }
                    return;
                }
                preparedStatement.setInt(n, (int)this.nxt_ptrIndex(string, dictionary).longValue());
                break;
            }
            default: {
                this.base_setInsertArgument(string, preparedStatement, n, dictionary);
            }
        }
    }

    public void base_setInsertArgument(String string, PreparedStatement preparedStatement, int n, Dictionary dictionary) throws SQLException {
        Object v = dictionary.get(string);
        if (v == null || v.equals(this.getFieldDefinition(string).getNull())) {
            this.setNullArgument(string, preparedStatement, n);
        } else {
            this.setArgument(string, preparedStatement, n, v);
        }
    }

    public void set_timeStamp_InsertArgument(String string, PreparedStatement preparedStatement, int n, Dictionary dictionary) throws SQLException {
        Object v = dictionary.get(string);
        if (v instanceof Date && !(v instanceof Timestamp)) {
            dictionary.put(string, new Timestamp(((Date)v).getTime()));
        }
        this.base_setInsertArgument(string, preparedStatement, n, dictionary);
    }

    public void setCopyArgument(String string, PreparedStatement preparedStatement, int n, Dictionary dictionary) throws SQLException {
        try {
            Object v = dictionary.get(string);
            if (v == null || v.equals(this.getFieldDefinition(string).getNull())) {
                this.setNullArgument(string, preparedStatement, n);
            } else {
                this.setArgument(string, preparedStatement, n, v);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(string + " " + exception.getMessage());
        }
    }

    public String inInsert(String string, Dictionary dictionary) {
        try {
            switch (this.getFieldDefinition(string).getIntegerType()) {
                case 10: 
                case 11: {
                    if (dictionary.get(string) != null) break;
                    this.nxt(string, dictionary);
                    break;
                }
                case 3: {
                    Pointer pointer = (Pointer)dictionary.get(string);
                    if (pointer == null) {
                        return "" + this.nxt_ptrIndex(string, dictionary).longValue();
                    }
                    if (pointer.getDbsv() != this.dbsv || pointer.longValue() <= this.primaryKeyCurrentIndex) break;
                    this.primaryKeyCurrentIndex = pointer.longValue();
                }
            }
            return this.writeConstant(string, dictionary.get(string));
        }
        catch (NullPointerException nullPointerException) {
            return "null";
        }
    }

    public String inCopy(String string, Dictionary dictionary) {
        return this.inInsert(string, dictionary);
    }

    public String inUpdate(String string, Dictionary dictionary) {
        switch (this.getFieldDefinition(string).getIntegerType()) {
            case 3: 
            case 10: {
                throw new RuntimeException("shouldn't be called");
            }
            case 11: {
                this.nxt(string, dictionary);
            }
        }
        return this.getDBName() + "=" + this.writeConstant(string, dictionary.get(string));
    }

    public String inCondition(String string, Dictionary dictionary, String string2) {
        return this.getDBName() + string2 + this.writeConstant(string, dictionary.get(string));
    }

    public String writeConstant(String string, Object object) {
        switch (this.getFieldDefinition(string).getIntegerType()) {
            case 6: 
            case 7: {
                return this.write_char_Constant(string, object);
            }
            case 8: {
                return this.write_text_Constant(string, object);
            }
            case 9: {
                return this.write_dateTime_Constant(string, object);
            }
            case 10: 
            case 11: {
                return this.write_timeStamp_Constant(string, object);
            }
        }
        if (object == this.getFieldDefinition(string).getNull()) {
            return "null";
        }
        return this.toSQLObject(string, object).toString();
    }

    public String base_writeConstant(String string, Object object) {
        if (object == this.getFieldDefinition(string).getNull()) {
            return "null";
        }
        return this.toSQLObject(string, object).toString();
    }

    public String write_char_Constant(String string, Object object) {
        return Database.SQLEscape(object.toString());
    }

    public String write_text_Constant(String string, Object object) {
        return Database.SQLEscape(object.toString());
    }

    public String write_dateTime_Constant(String string, Object object) {
        return "'" + new Timestamp(((Date)object).getTime()) + "'";
    }

    public String write_timeStamp_Constant(String string, Object object) {
        return "'" + this.base_writeConstant(string, object) + "'";
    }

    protected String getEngineProperty(String string, String string2) {
        Database database = this.getSQLDatabase();
        return Database.getEngineProperty(database.getEngine() + "." + string2);
    }

    public void onStartup(String string, Properties properties, SQLDBConnection sQLDBConnection) throws SQLException {
        if (this.alter && this.shouldIndex(string)) {
            this.manageIndexes(string, sQLDBConnection);
        }
        if (this.shouldIndex(string)) {
            this.extraIndexes.remove(this.getFieldDBIndexName(string).toLowerCase());
        }
        this.checkDuplicate.put(string, "SELECT 1 FROM " + this.getDBName() + " WHERE " + this.getFieldDBName(string) + "=?");
        this.checkNullDuplicate.put(string, "SELECT 1 FROM " + this.getDBName() + " WHERE " + this.getFieldDBName(string) + " is null");
        switch (this.getFieldDefinition(string).getIntegerType()) {
            case 3: {
                this.dbsv = this.getSQLDatabase().getDbsv();
                Statement statement = sQLDBConnection.createStatement();
                this.resetPrimaryKey();
                ResultSet resultSet = statement.executeQuery("SELECT MAX(" + this.getFieldDBName(string) + "), COUNT(" + this.getFieldDBName(string) + ") FROM " + this.tbname + " WHERE " + this.getFieldDBName(string) + ">=" + this.primaryKeyCurrentIndex + " AND " + this.getFieldDBName(string) + "<=" + this.getSQLDatabase().getMaxPointerValue());
                resultSet.next();
                if (resultSet.getLong(2) > 0L) {
                    this.primaryKeyCurrentIndex = resultSet.getLong(1);
                }
                resultSet.close();
                statement.close();
            }
        }
    }

    public boolean shouldIndex(String string) {
        if (this.getFieldDefinition(string).getIntegerType() == 8) {
            return this.should_text_Index(string);
        }
        return true;
    }

    public boolean should_text_Index(String string) {
        return false;
    }

    public boolean isIndexOk(String string, SQLDBConnection sQLDBConnection) {
        Boolean bl = (Boolean)this.indexes.get(this.getFieldDBIndexName(string).toLowerCase());
        if (bl != null) {
            return this.getFieldDefinition(string).isUnique() == (bl == false);
        }
        return false;
    }

    public void manageIndexes(String string, SQLDBConnection sQLDBConnection) throws SQLException {
        String string2 = this.getFieldDBIndexName(string);
        String string3 = this.getDataDefinition().getName() + "#" + string + " (" + this.getFieldDefinition(string).getDescription() + ")";
        if (!this.isIndexOk(string, sQLDBConnection)) {
            Statement statement;
            try {
                Statement statement2 = sQLDBConnection.createStatement();
                statement2.executeUpdate(this.indexDropSyntax(string));
                MakumbaSystem.getMakumbaLogger("db.init.tablechecking").info("INDEX DROPPED on " + string3);
                statement2.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            boolean bl = false;
            if (this.getFieldDefinition(string).isUnique()) {
                try {
                    statement = sQLDBConnection.createStatement();
                    statement.executeUpdate(this.indexCreateUniqueSyntax(string));
                    MakumbaSystem.getMakumbaLogger("db.init.tablechecking").info("UNIQUE INDEX ADDED on " + string3);
                    statement.close();
                    this.indexCreated(sQLDBConnection);
                }
                catch (SQLException sQLException) {
                    MakumbaSystem.getMakumbaLogger("db.init.tablechecking").warning("Problem adding UNIQUE INDEX on " + string3 + ": " + sQLException.getMessage() + " [ErrorCode: " + sQLException.getErrorCode() + ", SQLstate:" + sQLException.getSQLState() + "]");
                    bl = true;
                }
            }
            if (bl || !this.getFieldDefinition(string).isUnique()) {
                try {
                    statement = sQLDBConnection.createStatement();
                    statement.executeUpdate(this.indexCreateSyntax(string));
                    MakumbaSystem.getMakumbaLogger("db.init.tablechecking").info("INDEX ADDED on " + string3);
                    statement.close();
                    this.indexCreated(sQLDBConnection);
                }
                catch (SQLException sQLException) {
                    MakumbaSystem.getMakumbaLogger("db.init.tablechecking").warning("Problem adding INDEX on " + string3 + ": " + sQLException.getMessage() + " [ErrorCode: " + sQLException.getErrorCode() + ", SQLstate:" + sQLException.getSQLState() + "]");
                }
            }
        }
    }

    public String indexCreateSyntax(String string) {
        return "CREATE INDEX " + this.getFieldDBIndexName(string) + " ON " + this.getDBName() + " (" + this.getFieldDBName(string) + ")";
    }

    public String indexCreateUniqueSyntax(String string) {
        return "CREATE UNIQUE INDEX " + this.getFieldDBIndexName(string) + " ON " + this.getDBName() + " (" + this.getFieldDBName(string) + ")";
    }

    public String indexDropSyntax(String string) {
        return "DROP INDEX " + this.getFieldDBIndexName(string) + " ON " + this.getDBName();
    }

    public void setValue(String string, Dictionary dictionary, ResultSet resultSet, int n) throws SQLException {
        Object object = this.getValue("", resultSet, n);
        if (object != null) {
            dictionary.put(string, object);
        } else {
            dictionary.remove(string);
        }
    }

    public void setValue(String string, Object[] objectArray, ResultSet resultSet, int n) throws SQLException {
        objectArray[n] = this.getValue("", resultSet, n);
    }

    protected void checkCopy(String string, String string2) {
        if (!this.admin) {
            throw new InvalidValueException(this.getFieldDefinition(string), "you cannot insert an " + string2 + " field unless the type " + this.getDataDefinition().getName() + " has administration approval in the database connection file");
        }
    }

    public boolean checkDuplicate(String string, SQLDBConnection sQLDBConnection, Dictionary dictionary) {
        if (!this.getFieldDefinition(string).isUnique()) {
            return false;
        }
        Object v = dictionary.get(string);
        PreparedStatement preparedStatement = v == null ? sQLDBConnection.getPreparedStatement((String)this.checkNullDuplicate.get(string)) : sQLDBConnection.getPreparedStatement((String)this.checkDuplicate.get(string));
        try {
            if (v != null) {
                this.setUpdateArgument(string, preparedStatement, 1, v);
            }
            return preparedStatement.executeQuery().next();
        }
        catch (SQLException sQLException) {
            Database.logException(sQLException, sQLDBConnection);
            throw new DBError(sQLException, (String)this.checkDuplicate.get(string));
        }
    }

    protected boolean unmodified(String string, int n, int n2, Vector vector, int n3) throws SQLException {
        switch (this.getFieldDefinition(string).getIntegerType()) {
            case 6: 
            case 7: {
                return this.unmodified_char(string, n, n2, vector, n3);
            }
        }
        return this.base_unmodified(string, n, n2, vector, n3);
    }

    protected boolean base_unmodified(String string, int n, int n2, Vector vector, int n3) throws SQLException {
        return n == this.getSQLType(string);
    }

    protected boolean unmodified_char(String string, int n, int n2, Vector vector, int n3) throws SQLException {
        return (this.base_unmodified(string, n, n2, vector, n3) || n == 1) && this.check_char_Width(string, n2);
    }

    protected boolean unmodified_wrapper(String string, int n, int n2, Vector vector, int n3) throws SQLException {
        return this.base_unmodified(string, n, n2, vector, n3);
    }

    protected boolean check_char_Width(String string, ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        return resultSetMetaData.getColumnDisplaySize(n) >= this.getFieldDefinition(string).getWidth();
    }

    protected boolean check_char_Width(String string, int n) throws SQLException {
        return n >= this.getFieldDefinition(string).getWidth();
    }

    protected void resetPrimaryKey() {
        this.primaryKeyCurrentIndex = this.getSQLDatabase().getMinPointerValue();
    }

    void nxt(String string, Dictionary dictionary) {
        switch (this.getFieldDefinition(string).getIntegerType()) {
            case 10: {
                dictionary.put(string, dictionary.get(this.dd.getLastModificationDateFieldName()));
                break;
            }
            case 11: {
                dictionary.put(string, new Timestamp(new Date().getTime()));
            }
        }
    }

    public SQLPointer nxt_ptrIndex(String string, Dictionary dictionary) {
        SQLPointer sQLPointer = new SQLPointer(this.dd.getName(), this.nextId_ptrIndex());
        dictionary.put(string, sQLPointer);
        return sQLPointer;
    }

    protected synchronized long nextId_ptrIndex() {
        return ++this.primaryKeyCurrentIndex;
    }

    public void checkInsert(String string, Dictionary dictionary) {
        Object v = dictionary.get(string);
        if (v != null) {
            switch (this.getFieldDefinition(string).getIntegerType()) {
                case 10: {
                    this.checkCopy(string, "creation date");
                    break;
                }
                case 11: {
                    this.checkCopy(string, "modification date");
                    break;
                }
                case 3: {
                    this.checkCopy(string, "index");
                    break;
                }
                default: {
                    this.base_checkInsert(string, dictionary);
                    return;
                }
            }
            dictionary.put(string, this.getFieldDefinition(string).checkValue(v));
        }
    }

    public void base_checkInsert(String string, Dictionary dictionary) {
        this.getFieldDefinition(string).checkInsert(dictionary);
    }

    public void checkInsert(Dictionary dictionary, Dictionary dictionary2) {
        this.dd.checkFieldNames(dictionary);
        Enumeration enumeration = this.dd.getFieldNames().elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (dictionary2.get(string) != null) continue;
            this.checkInsert(string, dictionary);
        }
    }

    public void checkUpdate(String string, Dictionary dictionary) {
        Object v = dictionary.get(string);
        if (v != null) {
            switch (this.getFieldDefinition(string).getIntegerType()) {
                case 10: {
                    throw new InvalidValueException(this.getFieldDefinition(string), "you cannot update a creation date");
                }
                case 11: {
                    throw new InvalidValueException(this.getFieldDefinition(string), "you cannot update a modification date");
                }
                case 3: {
                    throw new InvalidValueException(this.getFieldDefinition(string), "you cannot update an index pointer");
                }
            }
            this.base_checkUpdate(string, dictionary);
        }
    }

    public void base_checkUpdate(String string, Dictionary dictionary) {
        this.getFieldDefinition(string).checkUpdate(dictionary);
    }

    public void checkUpdate(Dictionary dictionary, Dictionary dictionary2) {
        this.dd.checkFieldNames(dictionary);
        Enumeration enumeration = this.dd.getFieldNames().elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (dictionary2.get(string) != null) continue;
            this.checkUpdate(string, dictionary);
        }
    }

    public Object check_timeStamp_ValueImpl(String string, Object object) {
        Object object2 = this.getFieldDefinition(string).checkValueImpl(object);
        if (object2 instanceof Date && !(object2 instanceof Timestamp)) {
            object2 = new Timestamp(((Date)object2).getTime());
        }
        return object2;
    }

    class CatalogChecker
    implements CheckingStrategy {
        Vector columns;
        Hashtable column;
        int i = 0;

        CatalogChecker(Hashtable hashtable) throws SQLException {
            this.columns = (Vector)hashtable.get(TableManager.this.tbname);
            if (this.columns == null) {
                this.columns = (Vector)hashtable.get(TableManager.this.tbname.toLowerCase());
                if (this.columns == null) {
                    this.columns = (Vector)hashtable.get(TableManager.this.tbname.toUpperCase());
                    if (this.columns != null) {
                        TableManager.this.tbname = TableManager.this.tbname.toUpperCase();
                    }
                } else {
                    TableManager.this.tbname = TableManager.this.tbname.toLowerCase();
                }
            }
        }

        public boolean shouldCreate() {
            return this.columns == null;
        }

        public boolean hasMoreColumns() throws SQLException {
            if (this.i < this.columns.size()) {
                this.column = (Hashtable)this.columns.elementAt(this.i);
                ++this.i;
                return true;
            }
            return false;
        }

        public String columnName() throws SQLException {
            return (String)this.column.get("COLUMN_NAME");
        }

        public int columnType() throws SQLException {
            return (Integer)this.column.get("DATA_TYPE");
        }

        public int columnSize() throws SQLException {
            return (Integer)this.column.get("COLUMN_SIZE");
        }

        public String columnTypeName() throws SQLException {
            return (String)this.column.get("TYPE_NAME");
        }

        public boolean checkColumn(String string) throws SQLException {
            return TableManager.this.unmodified(string, this.columnType(), this.columnSize(), this.columns, this.i);
        }
    }

    protected static interface CheckingStrategy {
        public boolean hasMoreColumns() throws SQLException;

        public String columnName() throws SQLException;

        public int columnType() throws SQLException;

        public String columnTypeName() throws SQLException;

        public boolean checkColumn(String var1) throws SQLException;

        public boolean shouldCreate() throws SQLException;
    }
}

