/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql.oql;

import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.collections.AST;
import org.makumba.db.Database;
import org.makumba.db.sql.oql.OQLAST;

public class AggregateAST
extends OQLAST {
    private static final long serialVersionUID = 1L;
    OQLAST expr;

    public void setExpr(OQLAST oQLAST) {
        this.expr = oQLAST;
    }

    public String writeInSQLQuery(Database database) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getText());
        stringBuffer.append(this.expr.writeInSQLQuery(database));
        AST aST = this.expr.getNextSibling();
        while (!aST.getText().equals(")")) {
            stringBuffer.append(((OQLAST)aST).writeInSQLQuery(database));
            aST = aST.getNextSibling();
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Object getMakumbaType() throws RecognitionException {
        Object object = this.expr.getMakumbaType();
        String string = "" + object;
        if (this.getText().startsWith("max") || this.getText().startsWith("min")) {
            if (string.startsWith("int") || string.startsWith("real") || string.startsWith("date") || string.startsWith("ptr") || string.startsWith("char") || string.startsWith("text")) {
                return object;
            }
            throw new SemanticException("cannot min() or max() a " + string);
        }
        if (this.getText().startsWith("sum")) {
            if (string.startsWith("int")) {
                return "int";
            }
            if (string.startsWith("real")) {
                return "real";
            }
            throw new SemanticException("cannot sum() a " + string);
        }
        if (this.getText().startsWith("avg")) {
            if (string.startsWith("int") || string.startsWith("real")) {
                return "real";
            }
            throw new SemanticException("cannot avg() a " + string);
        }
        throw new SemanticException("aggregate expressions can be sum, min, max, avg");
    }
}

