/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.abstr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionParseError;
import org.makumba.MakumbaError;
import org.makumba.abstr.FieldCursor;
import org.makumba.abstr.FieldInfo;
import org.makumba.abstr.OrderedProperties;
import org.makumba.abstr.RecordInfo;
import org.makumba.util.ClassResource;

public class RecordParser {
    OrderedProperties text;
    OrderedProperties fields = new OrderedProperties();
    OrderedProperties subfields = new OrderedProperties();
    DataDefinitionParseError mpe;
    Properties definedTypes;
    DataDefinition dd;
    HashMap ptrOne_RecordParsers = new HashMap();
    HashMap setParser_settbls = new HashMap();
    HashMap subtableParser_subtables = new HashMap();
    HashMap subtableParser_here = new HashMap();
    FieldCursor currentRowCursor;

    RecordParser() {
        this.definedTypes = new Properties();
    }

    RecordParser(RecordInfo recordInfo, RecordParser recordParser) {
        this.dd = recordInfo;
        this.text = new OrderedProperties();
        this.definedTypes = recordParser.definedTypes;
        this.mpe = recordParser.mpe;
    }

    void parse(RecordInfo recordInfo) {
        this.dd = recordInfo;
        this.text = new OrderedProperties();
        this.mpe = new DataDefinitionParseError();
        try {
            this.read(this.text, recordInfo.origin);
        }
        catch (IOException iOException) {
            throw this.fail(iOException);
        }
        try {
            recordInfo.addStandardFields(recordInfo.name.substring(recordInfo.name.lastIndexOf(46) + 1));
            this.parse();
        }
        catch (RuntimeException runtimeException) {
            throw new MakumbaError(runtimeException, "Internal error in parser while parsing " + recordInfo.getName());
        }
        if (!this.mpe.isSingle() && recordInfo.getParentField() == null) {
            throw this.mpe;
        }
    }

    DataDefinition parse(URL uRL, String string) {
        this.dd = new RecordInfo(uRL, string);
        this.parse((RecordInfo)this.dd);
        return this.dd;
    }

    RecordInfo parse(String string) {
        this.dd = new RecordInfo();
        this.text = new OrderedProperties();
        this.mpe = new DataDefinitionParseError();
        try {
            this.read(this.text, string);
        }
        catch (IOException iOException) {
            throw this.fail(iOException);
        }
        try {
            ((RecordInfo)this.dd).addStandardFields(this.dd.getName().substring(this.dd.getName().lastIndexOf(46) + 1));
            this.parse();
        }
        catch (RuntimeException runtimeException) {
            throw new MakumbaError(runtimeException, "Internal error in parser while parsing " + this.dd.getName());
        }
        if (!this.mpe.isSingle() && this.dd.getParentField() == null) {
            throw this.mpe;
        }
        return (RecordInfo)this.dd;
    }

    void parse() {
        this.solveIncludes();
        this.separateFields();
        this.setTitle();
        this.readTypes();
        if (this.text.size() != 0) {
            this.mpe.add(this.fail("unrecognized commands", this.text.toString()));
        }
        this.treatMyFields();
        this.configSubfields();
        this.treatSubfields();
    }

    void separateFields() {
        Enumeration enumeration = this.text.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.indexOf(33) == 0) continue;
            if (string.indexOf("->") == -1) {
                this.fields.putLast(string, this.text.getOriginal(string), this.text.remove(string));
                continue;
            }
            this.subfields.putLast(string, this.text.getOriginal(string), this.text.remove(string));
        }
    }

    void setTitle() {
        String string = this.text.getOriginal("!title");
        String string2 = (String)this.text.remove("!title");
        String string3 = null;
        if (string2 != null) {
            string3 = string2.trim();
            if (this.fields.get(string3) == null) {
                this.mpe.add(this.fail("no such field for title", RecordParser.makeLine(string, string2)));
                return;
            }
        } else if (this.fields.get("name") != null) {
            string3 = "name";
        } else if (this.fields.size() > 0) {
            string3 = this.fields.keyAt(0);
        }
        ((RecordInfo)this.dd).title = string3;
    }

    static URL getResource(String string) {
        return ClassResource.get(string);
    }

    public static URL findDataDefinition(String string, String string2) {
        URL uRL = RecordParser.findDataDefinitionOrDirectory(string, string2);
        if (uRL != null && uRL.toString().endsWith("/")) {
            return null;
        }
        return uRL;
    }

    public static URL findDataDefinitionOrDirectory(String string, String string2) {
        String string3 = null;
        URL uRL = null;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (string.endsWith(".") || string.endsWith("//")) {
            return null;
        }
        uRL = RecordParser.getResource(string.replace('.', '/') + "." + string2);
        if (uRL == null && (uRL = RecordParser.getResource("dataDefinitions/" + string.replace('.', '/') + "." + string2)) == null && (uRL = RecordParser.getResource(string3 = "dataDefinitions/" + string.replace('.', '/'))) == null) {
            string3 = string.replace('.', '/');
            uRL = RecordParser.getResource(string3);
        }
        return uRL;
    }

    void solveIncludes() {
        String string;
        int n = 0;
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.text.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.startsWith("!include")) {
                OrderedProperties orderedProperties;
                String string2 = this.text.getOriginal(string);
                String string3 = (String)this.text.remove(string);
                --n;
                String string4 = string3.trim();
                URL uRL = RecordParser.findDataDefinition(string4, "idd");
                String string5 = "." + this.dd.getName();
                if (uRL == null) {
                    this.mpe.add(this.fail("could not find include file " + string4, string2 + "=" + string3));
                    return;
                }
                try {
                    orderedProperties = new OrderedProperties();
                    this.read(orderedProperties, uRL);
                }
                catch (IOException iOException) {
                    this.mpe.add(this.fail("could not find include file " + string4 + " " + iOException, string2 + "=" + string3));
                    return;
                }
                Enumeration enumeration2 = orderedProperties.keys();
                while (enumeration2.hasMoreElements()) {
                    String string6 = (String)enumeration2.nextElement();
                    String string7 = this.text.getProperty(string6);
                    if (string7 == null) {
                        this.text.putAt(++n, string6, orderedProperties.getOriginal(string6), orderedProperties.getProperty(string6));
                        continue;
                    }
                    vector.add(string6);
                }
            }
            ++n;
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (((String)this.text.get(string)).trim().length() != 0) continue;
            this.text.remove(string);
        }
    }

    void readTypes() {
        Enumeration enumeration = this.text.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("!type.")) continue;
            String string2 = string.substring(6);
            this.definedTypes.put(string2, this.text.remove(string));
        }
    }

    FieldInfo getFieldInfo(String string) {
        return (FieldInfo)this.dd.getFieldDefinition(string);
    }

    void treatMyFields() {
        int n = 0;
        Enumeration enumeration = this.fields.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            for (int i = 0; i < string.length(); ++i) {
                if ((i != 0 || Character.isJavaIdentifierStart(string.charAt(i))) && (i <= 0 || Character.isJavaIdentifierPart(string.charAt(i)))) continue;
                this.mpe.add(this.fail("Invalid character \"" + string.charAt(i) + "\" in field name \"" + string + "\"", string));
            }
            FieldInfo fieldInfo = new FieldInfo((RecordInfo)this.dd, string);
            ((RecordInfo)this.dd).addField1(fieldInfo);
            try {
                this.parse(string, new FieldCursor(this, RecordParser.makeLine(this.fields, string)));
            }
            catch (DataDefinitionParseError dataDefinitionParseError) {
                ((RecordInfo)this.dd).fields.remove(string);
                ((RecordInfo)this.dd).fieldOrder.remove(string);
                this.mpe.add(dataDefinitionParseError);
            }
            ++n;
        }
    }

    void configSubfields() {
        Enumeration enumeration = this.subfields.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = string.indexOf("->");
            String string2 = this.getFieldInfo((String)string.substring((int)0, (int)n)).type;
            if (string2 == null) {
                this.mpe.add(this.fail("no such field in subfield definition", RecordParser.makeLine(this.subfields, string)));
                continue;
            }
            String string3 = this.addText(string.substring(0, n), string.substring(n + 2), this.subfields.getOriginal(string), this.subfields.getProperty(string));
            if (string3 == null) continue;
            this.mpe.add(this.fail(string3, RecordParser.makeLine(this.subfields, string)));
        }
    }

    void treatSubfields() {
        Enumeration enumeration = this.dd.getFieldNames().elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.parseSubfields(string);
        }
    }

    static String makeLine(String string, String string2) {
        return string + "=" + string2;
    }

    static String makeLine(OrderedProperties orderedProperties, String string) {
        return orderedProperties.getOriginal(string) + "=" + orderedProperties.getProperty(string);
    }

    public static Vector commaString2Vector(String string) {
        Vector<String> vector = new Vector<String>();
        while (true) {
            String string2;
            int n;
            if ((n = string.indexOf(44)) == -1) {
                string2 = string.trim();
                if (string2.length() > 0) {
                    vector.addElement(string2);
                }
                return vector;
            }
            string2 = string.substring(0, n).trim();
            if (string2.length() > 0) {
                vector.addElement(string2);
            }
            string = string.substring(n + 1);
        }
    }

    static String listArguments(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        if (vector != null && vector.size() > 0) {
            stringBuffer.append('(').append(vector.elementAt(0));
            for (int i = 1; i < vector.size(); ++i) {
                stringBuffer.append(", ").append(vector.elementAt(i));
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    DataDefinitionParseError fail(String string, String string2) {
        return new DataDefinitionParseError(this.dd.getName(), string, string2, string2.length());
    }

    DataDefinitionParseError fail(IOException iOException) {
        return new DataDefinitionParseError(this.dd.getName(), iOException);
    }

    void read(OrderedProperties orderedProperties, String string) throws IOException {
        this.read(orderedProperties, new BufferedReader(new StringReader(string)));
    }

    void read(OrderedProperties orderedProperties, URL uRL) throws IOException {
        this.read(orderedProperties, new BufferedReader(new InputStreamReader((InputStream)uRL.getContent())));
    }

    void read(OrderedProperties orderedProperties, BufferedReader bufferedReader) throws IOException {
        while (true) {
            String string;
            String string2 = null;
            string2 = bufferedReader.readLine();
            if (string2 == null) break;
            String string3 = string2.trim();
            int n = string2.indexOf(61);
            if (string3.length() == 0 || string3.charAt(0) == '#') continue;
            if (n == -1) {
                this.mpe.add(this.fail("non-empty, non-comment line without =", string2));
                continue;
            }
            String string4 = string2.substring(0, n);
            String string5 = string4.trim();
            if (string5.length() == 0) {
                this.mpe.add(this.fail("zero length key", string2));
                continue;
            }
            if (string5.charAt(0) == '!' && string5.length() == 1) {
                this.mpe.add(this.fail("zero length command", string2));
                continue;
            }
            if (string5.startsWith("!include")) {
                if (string5.length() > 8) {
                    this.mpe.add(this.fail("unknown command: " + string5, string2));
                    continue;
                }
                while (orderedProperties.get(string5) != null) {
                    string5 = string5 + "_";
                }
            }
            if (orderedProperties.putLast(string5, string4, string = string2.substring(n + 1)) == null) continue;
            this.mpe.add(this.fail("ambiguous key " + string5, string2));
        }
        bufferedReader.close();
    }

    public void parseSubfields(String string) {
        switch (this.getFieldInfo(string).getIntegerType()) {
            case 2: 
            case 13: {
                this.parse_ptrOne_Subfields(string);
                break;
            }
            case 12: {
                this.parse_set_Subfields(string);
                break;
            }
        }
    }

    public void parse_ptrOne_Subfields(String string) {
        ((RecordParser)this.ptrOne_RecordParsers.get(string)).parse();
        this.getFieldInfo((String)string).extra2 = ((RecordParser)this.ptrOne_RecordParsers.get((Object)string)).dd.getTitleFieldName();
    }

    public void parse_set_Subfields(String string) {
        if (this.getFieldInfo((String)string).extra2 == null) {
            ((RecordInfo)this.subtableParser_subtables.get((Object)string)).title = ((DataDefinition)this.setParser_settbls.get(string)).getTitleFieldName();
            this.getFieldInfo((String)string).extra2 = ((RecordInfo)this.subtableParser_subtables.get((Object)string)).title;
        }
    }

    String acceptTitle(String string, String string2, String string3, String string4, Object object) {
        string4 = string4.trim();
        if (string2.equals("!title")) {
            DataDefinition dataDefinition = (DataDefinition)object;
            if (dataDefinition.getFieldDefinition(string4) == null) {
                return dataDefinition.getName() + " has no field called " + string4;
            }
            this.getFieldInfo((String)string).extra2 = string4;
            return null;
        }
        return this.addText(string, string2, string3, string4);
    }

    String addText(String string, String string2, String string3, String string4) {
        switch (this.getFieldInfo(string).getIntegerType()) {
            case 0: 
            case 1: {
                return this.add_ptr_Text(string, string2, string3, string4);
            }
            case 2: 
            case 13: {
                return this.add_ptrOne_Text(string, string2, string3, string4);
            }
            case 12: {
                return this.add_set_Text(string, string2, string3, string4);
            }
        }
        return this.base_addText(string, string2, string3, string4);
    }

    String base_addText(String string, String string2, String string3, String string4) {
        return "subfield not allowed";
    }

    String add_ptr_Text(String string, String string2, String string3, String string4) {
        return this.acceptTitle(string, string2, string3, string4, this.getFieldInfo((String)string).extra1);
    }

    String add_ptrOne_Text(String string, String string2, String string3, String string4) {
        if (((RecordParser)this.ptrOne_RecordParsers.get((Object)string)).text.putLast(string2, string3, string4) != null) {
            return "field already exists";
        }
        return null;
    }

    String add_set_Text(String string, String string2, String string3, String string4) {
        String string5 = this.acceptTitle(string, string2, string3, string4, (DataDefinition)this.setParser_settbls.get(string));
        if (string5 == null) {
            ((RecordInfo)this.subtableParser_subtables.get((Object)string)).title = string4.trim();
        }
        return string5;
    }

    void parse(String string, FieldCursor fieldCursor) throws DataDefinitionParseError {
        while (true) {
            if (fieldCursor.lookup("not")) {
                if (this.getFieldInfo((String)string).notNull) {
                    throw fieldCursor.fail("too many not null");
                }
                fieldCursor.expect("null");
                fieldCursor.expectWhitespace();
                this.getFieldInfo((String)string).notNull = true;
                continue;
            }
            if (fieldCursor.lookup("fixed")) {
                fieldCursor.expectWhitespace();
                if (this.getFieldInfo((String)string).fixed) {
                    throw fieldCursor.fail("too many fixed");
                }
                this.getFieldInfo((String)string).fixed = true;
                continue;
            }
            if (!fieldCursor.lookup("unique")) break;
            fieldCursor.expectWhitespace();
            if (this.getFieldInfo((String)string).unique) {
                throw fieldCursor.fail("already unique");
            }
            this.getFieldInfo((String)string).unique = true;
        }
        if (this.setType(string, fieldCursor.expectTypeLiteral(), fieldCursor) == null) {
            String string2 = this.definedTypes.getProperty(this.getFieldInfo((String)string).type);
            if (string2 == null) {
                throw fieldCursor.fail("unknown type: " + this.getFieldInfo((String)string).type);
            }
            fieldCursor.substitute(this.getFieldInfo((String)string).type.length(), string2);
            if (this.setType(string, fieldCursor.expectTypeLiteral(), fieldCursor) == null) {
                throw fieldCursor.fail("unknown type: " + this.getFieldInfo((String)string).type);
            }
        }
        this.getFieldInfo((String)string).description = this.getFieldInfo((String)string).description == null ? this.getFieldInfo((String)string).name : this.getFieldInfo((String)string).description;
    }

    String setType(String string, String string2, FieldCursor fieldCursor) throws DataDefinitionParseError {
        String string3 = string2;
        this.getFieldInfo((String)string).type = string2;
        while (FieldInfo.integerTypeMap.get(this.getFieldInfo((String)string).type) != null) {
            this.parse1(string, fieldCursor);
            if (this.getFieldInfo((String)string).type.equals(string3)) {
                return string3;
            }
            string3 = this.getFieldInfo((String)string).type;
        }
        return null;
    }

    void parse1(String string, FieldCursor fieldCursor) {
        switch (this.getFieldInfo(string).getIntegerType()) {
            case 7: {
                this.charEnum_parse1(string, fieldCursor);
                return;
            }
            case 6: {
                this.char_parse1(string, fieldCursor);
                return;
            }
            case 5: {
                this.intEnum_parse1(string, fieldCursor);
                return;
            }
            case 4: {
                this.int_parse1(string, fieldCursor);
                return;
            }
            case 2: {
                this.ptrOne_parse1(string, fieldCursor);
                return;
            }
            case 0: 
            case 1: {
                this.ptr_parse1(string, fieldCursor);
                return;
            }
            case 16: {
                this.setCharEnum_parse1(string, fieldCursor);
                return;
            }
            case 13: {
                this.setComplex_parse1(string, fieldCursor);
                return;
            }
            case 17: {
                this.setIntEnum_parse1(string, fieldCursor);
                return;
            }
            case 12: {
                this.set_parse1(string, fieldCursor);
                return;
            }
            case 8: {
                this.text_parse1(string, fieldCursor);
                return;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                this.simple_parse1(string, fieldCursor);
                return;
            }
        }
    }

    public void int_parse1(String string, FieldCursor fieldCursor) {
        if (!fieldCursor.lookup("{")) {
            this.getFieldInfo((String)string).description = fieldCursor.lookupDescription();
            return;
        }
        this.getFieldInfo((String)string).type = "intEnum";
    }

    public void intEnum_parse1(String string, FieldCursor fieldCursor) {
        fieldCursor.expectIntEnum(this.getFieldInfo(string));
        this.getFieldInfo((String)string).description = fieldCursor.lookupDescription();
    }

    public void char_parse1(String string, FieldCursor fieldCursor) {
        if (!fieldCursor.lookup("{")) {
            fieldCursor.expect("[");
            Integer n = fieldCursor.expectInteger();
            if (n > 255 || n < 0) {
                throw fieldCursor.fail("char size must be between 0 and 255, not " + n.toString());
            }
            this.getFieldInfo((String)string).extra2 = n;
            fieldCursor.expect("]");
            this.getFieldInfo((String)string).description = fieldCursor.lookupDescription();
            return;
        }
        this.getFieldInfo((String)string).type = "charEnum";
    }

    public void charEnum_parse1(String string, FieldCursor fieldCursor) {
        fieldCursor.expectCharEnum(this.getFieldInfo(string));
        this.getFieldInfo((String)string).description = fieldCursor.lookupDescription();
    }

    public void simple_parse1(String string, FieldCursor fieldCursor) {
        this.getFieldInfo((String)string).description = fieldCursor.lookupDescription();
    }

    public void text_parse1(String string, FieldCursor fieldCursor) throws DataDefinitionParseError {
        if (this.getFieldInfo(string).isUnique()) {
            throw fieldCursor.fail("text fields can't be declared unique");
        }
    }

    public void setComplex_parse1(String string, FieldCursor fieldCursor) {
        this.ptrOne_parse1(string, fieldCursor);
        ((RecordInfo)this.subtableParser_subtables.get((Object)string)).mainPtr = this.addPtrHere(string);
    }

    public void ptrOne_parse1(String string, FieldCursor fieldCursor) {
        this.makeSubtable(string, fieldCursor);
        this.ptrOne_RecordParsers.put(string, new RecordParser((RecordInfo)this.subtableParser_subtables.get(string), this));
    }

    public void setCharEnum_parse1(String string, FieldCursor fieldCursor) {
        FieldInfo fieldInfo = new FieldInfo((RecordInfo)this.subtableParser_subtables.get(string), "enum");
        this.makeSubtable(string, fieldCursor);
        ((RecordInfo)this.subtableParser_subtables.get((Object)string)).mainPtr = this.addPtrHere(string);
        ((RecordInfo)this.subtableParser_subtables.get(string)).addField1(fieldInfo);
        ((RecordInfo)this.subtableParser_subtables.get((Object)string)).title = fieldInfo.name;
        ((RecordInfo)this.subtableParser_subtables.get((Object)string)).setField = fieldInfo.name;
        fieldInfo.type = "charEnum";
        fieldCursor.expectCharEnum(fieldInfo);
        this.getFieldInfo((String)string).description = fieldCursor.lookupDescription();
        fieldInfo.description = this.getFieldInfo(string).getDescription() == null ? fieldInfo.name : this.getFieldInfo(string).getDescription();
    }

    public void setIntEnum_parse1(String string, FieldCursor fieldCursor) {
        FieldInfo fieldInfo = new FieldInfo((RecordInfo)this.subtableParser_subtables.get(string), "enum");
        this.makeSubtable(string, fieldCursor);
        ((RecordInfo)this.subtableParser_subtables.get((Object)string)).mainPtr = this.addPtrHere(string);
        ((RecordInfo)this.subtableParser_subtables.get(string)).addField1(fieldInfo);
        ((RecordInfo)this.subtableParser_subtables.get((Object)string)).title = fieldInfo.name;
        ((RecordInfo)this.subtableParser_subtables.get((Object)string)).setField = fieldInfo.name;
        fieldInfo.type = "intEnum";
        fieldCursor.expectIntEnum(fieldInfo);
        this.getFieldInfo((String)string).description = fieldCursor.lookupDescription();
        fieldInfo.description = this.getFieldInfo(string).getDescription() == null ? fieldInfo.name : this.getFieldInfo(string).getDescription();
    }

    public void ptr_parse1(String string, FieldCursor fieldCursor) {
        DataDefinition dataDefinition = fieldCursor.lookupTableSpecifier();
        if (dataDefinition != null) {
            this.getFieldInfo((String)string).extra1 = dataDefinition;
        }
        try {
            this.getFieldInfo((String)string).description = fieldCursor.lookupDescription();
        }
        catch (DataDefinitionParseError dataDefinitionParseError) {
            throw fieldCursor.fail("table specifier or nothing expected");
        }
        if (dataDefinition != null) {
            return;
        }
        this.getFieldInfo((String)string).type = "ptrOne";
    }

    public void set_parse1(String string, FieldCursor fieldCursor) {
        if (this.getFieldInfo(string).isUnique()) {
            throw fieldCursor.fail("sets can't be declared unique");
        }
        DataDefinition dataDefinition = fieldCursor.lookupTableSpecifier();
        if (dataDefinition == null) {
            String string2 = fieldCursor.lookupTypeLiteral();
            if (string2 == null) {
                try {
                    this.getFieldInfo((String)string).description = fieldCursor.lookupDescription();
                }
                catch (DataDefinitionParseError dataDefinitionParseError) {
                    throw fieldCursor.fail("table specifier, enumeration type, or nothing expected");
                }
                this.getFieldInfo((String)string).type = "setComplex";
                return;
            }
            String string3 = this.enumSet(string, fieldCursor, string2);
            if (string3 != null) {
                this.getFieldInfo((String)string).type = string3;
                return;
            }
            String string4 = fieldCursor.rp.definedTypes.getProperty(string2);
            if (string4 == null) {
                throw fieldCursor.fail("table, char{}, int{} or macro type expected after set");
            }
            fieldCursor.substitute(string2.length(), string4);
            string3 = this.enumSet(string, fieldCursor, fieldCursor.expectTypeLiteral());
            if (string3 != null) {
                this.getFieldInfo((String)string).type = string3;
                return;
            }
            throw fieldCursor.fail("int{} or char{} macro expected after set");
        }
        this.makeSubtable(string, fieldCursor);
        ((RecordInfo)this.subtableParser_subtables.get((Object)string)).mainPtr = this.addPtrHere(string);
        this.setParser_settbls.put(string, dataDefinition);
        ((RecordInfo)this.subtableParser_subtables.get((Object)string)).setField = this.addPtr(string, ((RecordInfo)this.setParser_settbls.get(string)).getBaseName(), dataDefinition);
    }

    String enumSet(String string, FieldCursor fieldCursor, String string2) {
        if (fieldCursor.lookup("{")) {
            String string3;
            this.getFieldInfo((String)string).type = string3 = "set" + string2 + "Enum";
            if (string3 != null) {
                return string3;
            }
            fieldCursor.fail("int{} or char{} expected after set");
        }
        return null;
    }

    void makeSubtable(String string, FieldCursor fieldCursor) {
        this.subtableParser_here.put(string, this.dd);
        this.subtableParser_subtables.put(string, ((RecordInfo)this.subtableParser_here.get(string)).makeSubtable(this.getFieldInfo((String)string).name));
        ((RecordInfo)this.subtableParser_subtables.get(string)).addStandardFields(((RecordInfo)this.subtableParser_subtables.get((Object)string)).subfield);
        this.getFieldInfo((String)string).extra1 = (RecordInfo)this.subtableParser_subtables.get(string);
    }

    String addPtr(String string, String string2, DataDefinition dataDefinition) {
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            string2 = string2.substring(n + 1);
        }
        while (((RecordInfo)this.subtableParser_subtables.get((Object)string)).fields.get(string2) != null) {
            string2 = string2 + "_";
        }
        FieldInfo fieldInfo = new FieldInfo((RecordInfo)this.subtableParser_subtables.get(string), string2);
        ((RecordInfo)this.subtableParser_subtables.get(string)).addField1(fieldInfo);
        fieldInfo.fixed = true;
        fieldInfo.notNull = true;
        fieldInfo.type = "ptrRel";
        fieldInfo.extra1 = dataDefinition;
        fieldInfo.description = "relational pointer";
        return string2;
    }

    String addPtrHere(String string) {
        ((RecordInfo)this.subtableParser_subtables.get((Object)string)).relations = 1;
        if (((RecordInfo)this.subtableParser_here.get(string)).getParentField() != null) {
            return this.addPtr(string, ((RecordInfo)this.subtableParser_here.get((Object)string)).subfield, (RecordInfo)this.subtableParser_here.get(string));
        }
        return this.addPtr(string, ((RecordInfo)this.subtableParser_here.get((Object)string)).name, (RecordInfo)this.subtableParser_here.get(string));
    }
}

