/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.controller.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.makumba.AttributeNotFoundException;
import org.makumba.DataDefinition;
import org.makumba.InvalidValueException;
import org.makumba.LogicException;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.controller.Logic;
import org.makumba.controller.http.ControllerFilter;
import org.makumba.controller.http.RequestAttributes;
import org.makumba.controller.http.ResponderOp;
import org.makumba.util.NamedResourceFactory;
import org.makumba.util.NamedResources;

public abstract class Responder
implements Serializable {
    public static final String responderName = "__makumba__responder__";
    public static final String formSessionName = "__makumba__formSession__";
    public static final String anonymousResult = "___mak___edited___";
    public static final String defaultMessage = "changes done";
    public static final String basePointerName = "__makumba__base__";
    protected int identity;
    protected transient Object controller;
    protected String controllerClassname;
    protected String database;
    protected String message = "changes done";
    protected String multipleSubmitMsg;
    protected String resultAttribute = "___mak___edited___";
    protected String handler;
    protected String basePointerType;
    protected String newType;
    protected String addField;
    protected String operation;
    protected ResponderOp op;
    static Hashtable indexedCache = new Hashtable();
    public static String makumbaResponderBaseDirectory;
    static NamedResources cache;
    transient int groupCounter = 0;
    protected transient String storedSuffix = "";
    protected transient String storedParentSuffix = "";
    static final char suffixSeparator = '_';
    static Integer ZERO;
    static Comparator bySuffix;
    public static final String RESPONSE_STRING_NAME = "makumba.response";
    static final String resultNamePrefix = "org.makumba.controller.resultOf_";
    static Hashtable responderOps;

    public void setHttpRequest(HttpServletRequest httpServletRequest) throws LogicException {
        this.controller = RequestAttributes.getAttributes(httpServletRequest).getRequestController();
        this.database = RequestAttributes.getAttributes(httpServletRequest).getRequestDatabase();
    }

    public void setOperation(String string) {
        this.operation = string;
        this.op = (ResponderOp)responderOps.get(string);
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setMultipleSubmitMsg(String string) {
        this.multipleSubmitMsg = string;
    }

    public void setHandler(String string) {
        this.handler = string;
    }

    public void setBasePointerType(String string) {
        this.basePointerType = string;
    }

    public void setResultAttribute(String string) {
        this.resultAttribute = string;
    }

    public void setAddField(String string) {
        this.addField = string;
    }

    public void setNewType(DataDefinition dataDefinition) {
        this.newType = dataDefinition.getName();
    }

    protected abstract void postDeserializaton();

    public String responderKey() {
        return this.basePointerType + this.message + this.resultAttribute + this.database + this.operation + this.controller.getClass().getName() + this.handler + this.addField + this.newType;
    }

    public int getPrototype() {
        String string = this.op.verify(this);
        if (string != null) {
            throw new MakumbaError("Bad responder configuration " + string);
        }
        return ((Responder)Responder.cache.getResource((Object)this)).identity;
    }

    public void setParentResponder(Responder responder, Responder responder2) {
        this.storedSuffix = "_" + ++responder2.groupCounter;
        this.storedParentSuffix = responder.storedSuffix;
    }

    public String getSuffix() {
        return this.storedSuffix;
    }

    static Integer suffix(String string) {
        int n = string.indexOf(95);
        if (n == -1) {
            return ZERO;
        }
        if ((n = (string = string.substring(n + 1)).indexOf(95)) != -1) {
            string = string.substring(0, n);
        }
        return new Integer(Integer.parseInt(string));
    }

    static Iterator getResponderCodes(HttpServletRequest httpServletRequest) {
        TreeSet<Object> treeSet = new TreeSet<Object>(bySuffix);
        Object object = RequestAttributes.getParameters(httpServletRequest).getParameter(responderName);
        if (object != null) {
            if (object instanceof String) {
                treeSet.add(object);
            } else {
                treeSet.addAll((Vector)object);
            }
        }
        return treeSet.iterator();
    }

    private static String validResponderFilename(int n) {
        return new String(makumbaResponderBaseDirectory + "/") + String.valueOf(n).replaceAll("-", "_");
    }

    protected static void setResponderWorkingDir(HttpServletRequest httpServletRequest) {
        if (makumbaResponderBaseDirectory == null) {
            System.out.println("had an empty responder dir - working dir ==> " + httpServletRequest.getSession().getServletContext().getAttribute("javax.servlet.context.tempdir"));
            String string = httpServletRequest.getSession().getServletContext().getAttribute("javax.servlet.context.tempdir") + System.getProperty("file.separator") + "makumba-responders" + System.getProperty("file.separator");
            makumbaResponderBaseDirectory = string + httpServletRequest.getContextPath();
            if (!new File(makumbaResponderBaseDirectory).exists()) {
                new File(string).mkdir();
                new File(makumbaResponderBaseDirectory).mkdir();
            }
            System.out.println("base dir: " + makumbaResponderBaseDirectory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void response(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Responder.setResponderWorkingDir(httpServletRequest);
        if (httpServletRequest.getAttribute(RESPONSE_STRING_NAME) != null) {
            return;
        }
        httpServletRequest.setAttribute(RESPONSE_STRING_NAME, (Object)"");
        String string = "";
        Iterator iterator = Responder.getResponderCodes(httpServletRequest);
        while (iterator.hasNext()) {
            Object object;
            String string2;
            String string3 = string2 = (String)iterator.next();
            String string4 = "";
            String string5 = null;
            int n = string2.indexOf(95);
            if (n != -1) {
                string3 = string2.substring(0, n);
                string4 = string2.substring(n);
                string5 = "";
                n = string4.indexOf(95, 1);
                if (n != -1) {
                    string5 = string4.substring(n);
                    string4 = string4.substring(0, n);
                }
            }
            Integer n2 = new Integer(Integer.parseInt(string3));
            Responder responder = (Responder)indexedCache.get(n2);
            String string6 = Responder.validResponderFilename(n2);
            if (responder == null) {
                object = null;
                try {
                    object = new ObjectInputStream(new FileInputStream(string6));
                    responder = (Responder)((ObjectInputStream)object).readObject();
                    responder.postDeserializaton();
                    responder.controller = Logic.getController(responder.controllerClassname);
                }
                catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                    MakumbaSystem.getMakumbaLogger("controller").log(Level.SEVERE, "Error while trying to check for responder on the HDD: could not read from file " + string6, unsupportedClassVersionError);
                    new File(string6).delete();
                    throw new InvalidValueException("Responder cannot be re-used due to Makumba version change! Please reload this page.");
                }
                catch (IOException iOException) {
                    MakumbaSystem.getMakumbaLogger("controller").log(Level.SEVERE, "Error while trying to check for responder on the HDD: could not read from file " + string6, iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    MakumbaSystem.getMakumbaLogger("controller").log(Level.SEVERE, "Error while trying to check for responder on the HDD: class not found: " + string6, classNotFoundException);
                }
                finally {
                    if (object != null) {
                        try {
                            ((ObjectInputStream)object).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (responder == null) {
                    throw new InvalidValueException("Responder cannot be found, probably due to server restart. Please reload this page.");
                }
            }
            try {
                Object object2;
                object = (String)RequestAttributes.getParameters(httpServletRequest).getParameter(formSessionName);
                if (responder.multipleSubmitMsg != null && !responder.multipleSubmitMsg.equals("") && object != null) {
                    object2 = null;
                    try {
                        object2 = MakumbaSystem.getConnectionTo(RequestAttributes.getAttributes(httpServletRequest).getRequestDatabase());
                        Vector vector = object2.executeQuery("SELECT ms FROM org.makumba.controller.MultipleSubmit ms WHERE ms.formSession=$1", object);
                        if (vector.size() == 0) {
                            throw new LogicException(responder.multipleSubmitMsg);
                        }
                        if (vector.size() >= 1) {
                            GregorianCalendar gregorianCalendar = new GregorianCalendar();
                            gregorianCalendar.add(10, -5);
                            Object[] objectArray = new Object[]{object, gregorianCalendar.getTime()};
                            object2.delete("org.makumba.controller.MultipleSubmit ms", "ms.formSession=$1 OR ms.TS_create<$2", objectArray);
                        }
                    }
                    finally {
                        object2.close();
                    }
                }
                object2 = responder.op.respondTo(httpServletRequest, responder, string4, string5);
                string = "<font color=green>" + responder.message + "</font>";
                if (object2 != null) {
                    httpServletRequest.setAttribute(responder.resultAttribute, object2);
                    httpServletRequest.setAttribute(resultNamePrefix + string4, object2);
                }
                httpServletRequest.setAttribute("makumba.successfulResponse", (Object)"yes");
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                ControllerFilter.treatException(attributeNotFoundException, httpServletRequest, httpServletResponse);
                continue;
            }
            catch (LogicException logicException) {
                MakumbaSystem.getMakumbaLogger("logic.error").log(Level.INFO, "error", logicException);
                string = Responder.errorMessage(logicException);
                httpServletRequest.setAttribute(responder.resultAttribute, Pointer.Null);
                httpServletRequest.setAttribute(resultNamePrefix + string4, Pointer.Null);
            }
            catch (Throwable throwable) {
                ControllerFilter.treatException(throwable, httpServletRequest, httpServletResponse);
            }
            if (!string4.equals("")) continue;
            httpServletRequest.setAttribute(RESPONSE_STRING_NAME, (Object)string);
        }
    }

    public static String errorMessage(Throwable throwable) {
        return "<font color=red>" + throwable.getMessage() + "</font>";
    }

    public Pointer getHttpBasePointer(HttpServletRequest httpServletRequest, String string) {
        return new Pointer(this.basePointerType, (String)RequestAttributes.getParameters(httpServletRequest).getParameter(basePointerName + string));
    }

    public abstract Dictionary getHttpData(HttpServletRequest var1, String var2);

    static {
        cache = new NamedResources("controller.responders", new NamedResourceFactory(){
            private static final long serialVersionUID = 1L;

            public Object getHashObject(Object object) {
                return ((Responder)object).responderKey();
            }

            public Object makeResource(Object object, Object object2) {
                Responder responder = (Responder)object;
                responder.identity = object2.hashCode();
                String string = Responder.validResponderFilename(responder.identity);
                if (indexedCache.get(new Integer(responder.identity)) == null) {
                    try {
                        if (!new File(string).exists()) {
                            responder.controllerClassname = responder.controller.getClass().getName();
                            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
                            objectOutputStream.writeObject(responder);
                            objectOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        MakumbaSystem.getMakumbaLogger("controller").log(Level.SEVERE, "Error while trying to check for responder on the HDD: could not read from file " + string, iOException);
                    }
                }
                indexedCache.put(new Integer(responder.identity), object);
                return object;
            }
        });
        ZERO = new Integer(0);
        bySuffix = new Comparator(){

            public int compare(Object object, Object object2) {
                return Responder.suffix((String)object).compareTo(Responder.suffix((String)object2));
            }

            public boolean equals(Object object) {
                return false;
            }
        };
        responderOps = new Hashtable();
        responderOps.put("edit", new ResponderOp(){
            private static final long serialVersionUID = 1L;

            public Object respondTo(HttpServletRequest httpServletRequest, Responder responder, String string, String string2) throws LogicException {
                return Logic.doEdit(responder.controller, responder.basePointerType, responder.getHttpBasePointer(httpServletRequest, string), responder.getHttpData(httpServletRequest, string), new RequestAttributes(responder.controller, httpServletRequest, responder.database), responder.database, RequestAttributes.getConnectionProvider(httpServletRequest));
            }

            public String verify(Responder responder) {
                return null;
            }
        });
        responderOps.put("simple", new ResponderOp(){
            private static final long serialVersionUID = 1L;

            public Object respondTo(HttpServletRequest httpServletRequest, Responder responder, String string, String string2) throws LogicException {
                return Logic.doOp(responder.controller, responder.handler, responder.getHttpData(httpServletRequest, string), new RequestAttributes(responder.controller, httpServletRequest, responder.database), responder.database, RequestAttributes.getConnectionProvider(httpServletRequest));
            }

            public String verify(Responder responder) {
                return null;
            }
        });
        responderOps.put("new", new ResponderOp(){
            private static final long serialVersionUID = 1L;

            public Object respondTo(HttpServletRequest httpServletRequest, Responder responder, String string, String string2) throws LogicException {
                return Logic.doNew(responder.controller, responder.newType, responder.getHttpData(httpServletRequest, string), new RequestAttributes(responder.controller, httpServletRequest, responder.database), responder.database, RequestAttributes.getConnectionProvider(httpServletRequest));
            }

            public String verify(Responder responder) {
                return null;
            }
        });
        responderOps.put("add", new ResponderOp(){
            private static final long serialVersionUID = 1L;

            public Object respondTo(HttpServletRequest httpServletRequest, Responder responder, String string, String string2) throws LogicException {
                return Logic.doAdd(responder.controller, responder.basePointerType + "->" + responder.addField, responder.getHttpBasePointer(httpServletRequest, string), responder.getHttpData(httpServletRequest, string), new RequestAttributes(responder.controller, httpServletRequest, responder.database), responder.database, RequestAttributes.getConnectionProvider(httpServletRequest));
            }

            public String verify(Responder responder) {
                return null;
            }
        });
        responderOps.put("addToNew", new ResponderOp(){
            private static final long serialVersionUID = 1L;

            public Object respondTo(HttpServletRequest httpServletRequest, Responder responder, String string, String string2) throws LogicException {
                return Logic.doAdd(responder.controller, responder.newType + "->" + responder.addField, (Pointer)httpServletRequest.getAttribute(Responder.resultNamePrefix + string2), responder.getHttpData(httpServletRequest, string), new RequestAttributes(responder.controller, httpServletRequest, responder.database), responder.database, RequestAttributes.getConnectionProvider(httpServletRequest));
            }

            public String verify(Responder responder) {
                return null;
            }
        });
        responderOps.put("deleteLink", new ResponderOp(){
            private static final long serialVersionUID = 1L;

            public Object respondTo(HttpServletRequest httpServletRequest, Responder responder, String string, String string2) throws LogicException {
                return Logic.doDelete(responder.controller, responder.basePointerType, responder.getHttpBasePointer(httpServletRequest, string), new RequestAttributes(responder.controller, httpServletRequest, responder.database), responder.database, RequestAttributes.getConnectionProvider(httpServletRequest));
            }

            public String verify(Responder responder) {
                return null;
            }
        });
        responderOps.put("deleteForm", new ResponderOp(){

            public Object respondTo(HttpServletRequest httpServletRequest, Responder responder, String string, String string2) throws LogicException {
                return Logic.doDelete(responder.controller, responder.basePointerType, responder.getHttpBasePointer(httpServletRequest, string), new RequestAttributes(responder.controller, httpServletRequest, responder.database), responder.database, RequestAttributes.getConnectionProvider(httpServletRequest));
            }

            public String verify(Responder responder) {
                return null;
            }
        });
    }
}

