/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.makumba.ConfigFileError;
import org.makumba.DBError;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.db.DBConnection;
import org.makumba.db.DBConnectionWrapper;
import org.makumba.db.Query;
import org.makumba.db.Table;
import org.makumba.db.Update;
import org.makumba.util.ClassResource;
import org.makumba.util.NamedResourceFactory;
import org.makumba.util.NamedResources;
import org.makumba.util.ResourcePool;
import org.makumba.util.RuntimeWrappedException;
import org.makumba.util.SoftNamedResources;
import org.makumba.view.dateFormatter;

public abstract class Database {
    NamedResources queries;
    NamedResources updates;
    int nconn = 0;
    int initConnections = 1;
    protected ResourcePool connections = new ResourcePool(){

        public Object create() {
            ++Database.this.nconn;
            Database.this.config.put("jdbc_connections", "" + Database.this.nconn);
            return Database.this.makeDBConnection();
        }

        public void renew(Object object) {
            ((DBConnection)object).commit();
        }

        public void close(Object object) {
            ((DBConnection)object).close();
        }
    };
    int dbsv;
    Properties config = null;
    Class tableclass;
    String configName;
    Hashtable queryCache = new Hashtable();
    String fullName;
    static Class[] theProp = new Class[]{Properties.class};
    static int dbs = NamedResources.makeStaticCache("Databases open", new NamedResourceFactory(){
        private static final long serialVersionUID = 1L;

        protected Object makeResource(Object object) {
            Properties properties = new Properties();
            String string = (String)object;
            try {
                properties.load(ClassResource.get(string + ".properties").openStream());
            }
            catch (Exception exception) {
                throw new ConfigFileError(string + ".properties");
            }
            try {
                String string2 = string;
                string = string.substring(string.lastIndexOf(47) + 1);
                int n = string.indexOf(95);
                String string3 = string.substring(0, n);
                properties.put("#host", string3);
                int n2 = string.indexOf(95, n + 1);
                if (Character.isDigit(string.charAt(n + 1))) {
                    properties.put("#host", string3 + ":" + string.substring(n + 1, n2));
                    n = n2;
                    n2 = string.indexOf(95, n + 1);
                }
                properties.put("#sqlEngine", string.substring(n + 1, n2));
                properties.put("#database", string.substring(n2 + 1));
                String string4 = (String)properties.get("dbclass");
                if (string4 == null && (string4 = org.makumba.db.sql.Database.getEngineProperty(properties.getProperty("#sqlEngine") + ".dbclass")) == null) {
                    string4 = "org.makumba.db.sql.Database";
                }
                properties.put("db.name", string);
                Object[] objectArray = new Object[]{properties};
                try {
                    Database database = (Database)Class.forName(string4).getConstructor(theProp).newInstance(objectArray);
                    database.configName = string;
                    database.fullName = string2;
                    database.tables = new NamedResources("Database tables for " + string, database.tableFactory);
                    return database;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new MakumbaError(invocationTargetException.getTargetException());
                }
            }
            catch (Exception exception) {
                throw new MakumbaError(exception);
            }
        }
    });
    static int dbsel = NamedResources.makeStaticCache("Database selection files", new NamedResourceFactory(){
        private static final long serialVersionUID = 1L;

        protected Object makeResource(Object object) {
            Properties properties = new Properties();
            try {
                InputStream inputStream = ClassResource.get((String)object).openStream();
                properties.load(inputStream);
                inputStream.close();
            }
            catch (Exception exception) {
                throw new ConfigFileError((String)object);
            }
            return properties;
        }
    });
    NamedResources tables;
    NamedResourceFactory tableFactory = new NamedResourceFactory(){
        private static final long serialVersionUID = 1L;

        public Object getHashObject(Object object) {
            return ((DataDefinition)object).getName();
        }

        public Object makeResource(Object object, Object object2) throws Throwable {
            return Database.this.tableclass.newInstance();
        }

        public void configureResource(Object object, Object object2, Object object3) {
            Database.this.configureTable((Table)object3, (DataDefinition)object);
            Database.this.addTable(((Table)object3).getDataDefinition().getName());
        }
    };

    public String getName() {
        return this.configName;
    }

    public void initConnections() {
        try {
            this.connections.init(this.initConnections);
        }
        catch (Exception exception) {
            throw new DBError(exception);
        }
    }

    protected void closeConnections() {
        this.connections.close();
    }

    public void close() {
        MakumbaSystem.getMakumbaLogger("db.init").info("closing  " + this.getConfiguration() + "\n\tat " + dateFormatter.debugTime.format(new Date()));
        this.tables.close();
        this.queries.close();
        this.updates.close();
        this.closeConnections();
    }

    public DBConnection getDBConnection() {
        try {
            return new DBConnectionWrapper((DBConnection)this.connections.get());
        }
        catch (Exception exception) {
            throw new DBError(exception);
        }
    }

    protected abstract DBConnection makeDBConnection();

    public int getDbsv() {
        return this.dbsv;
    }

    public abstract Pointer getPointer(String var1, int var2);

    public String getConfiguration() {
        return this.fullName;
    }

    public String getConfiguration(String string) {
        if (string.equals("resource_pool_size")) {
            return String.valueOf(this.connections.getSize());
        }
        return this.config.getProperty(string);
    }

    static String findInHostProperties(Properties properties, String string) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            int n = string2.indexOf(35);
            try {
                if (n != -1 && !InetAddress.getByName(string2.substring(0, n)).equals(InetAddress.getLocalHost()) || !string.endsWith(string2.substring(n + 1))) continue;
                return properties.getProperty(string2);
            }
            catch (UnknownHostException unknownHostException) {
            }
        }
        return null;
    }

    public static String findDatabaseName(Properties properties) {
        String string = System.getProperty("user.dir");
        URL uRL = ClassResource.get("/");
        String string2 = uRL != null ? uRL.toString() : null;
        String string3 = Database.findInHostProperties(properties, string);
        if (string3 != null || string2 != null && (string3 = Database.findInHostProperties(properties, string2)) != null || (string3 = Database.findInHostProperties(properties, "default")) != null) {
            return string3;
        }
        return properties.getProperty("default");
    }

    public static Database findDatabase(Properties properties) {
        return Database.getDatabase(Database.findDatabaseName(properties));
    }

    public static Database findDatabase(String string) {
        return Database.getDatabase(Database.findDatabaseName(string));
    }

    public static String findDatabaseName(String string) {
        try {
            return Database.findDatabaseName((Properties)NamedResources.getStaticCache(dbsel).getResource(string));
        }
        catch (RuntimeWrappedException runtimeWrappedException) {
            if (runtimeWrappedException.getReason() instanceof MakumbaError) {
                throw (MakumbaError)runtimeWrappedException.getReason();
            }
            throw runtimeWrappedException;
        }
    }

    public static Database getDatabase(String string) {
        try {
            return (Database)NamedResources.getStaticCache(dbs).getResource(string);
        }
        catch (RuntimeWrappedException runtimeWrappedException) {
            if (runtimeWrappedException.getReason() instanceof MakumbaError) {
                throw (MakumbaError)runtimeWrappedException.getReason();
            }
            throw runtimeWrappedException;
        }
    }

    protected Database(Properties properties) {
        this.config = properties;
        this.configName = properties.getProperty("db.name");
        String string = properties.getProperty("initConnections");
        if (string != null) {
            this.initConnections = Integer.parseInt(string.trim());
        }
        properties.put("jdbc_connections", "0");
        try {
            this.dbsv = new Integer((String)properties.get("dbsv"));
            this.tableclass = this.getTableClassConfigured();
            properties.put("alter#org.makumba.db.Catalog", "true");
            properties.put("alter#org.makumba.db.Lock", "true");
        }
        catch (Exception exception) {
            throw new MakumbaError(exception);
        }
        this.queries = new SoftNamedResources("Database " + this.getName() + " query objects", new NamedResourceFactory(){
            private static final long serialVersionUID = 1L;

            public Object makeResource(Object object) {
                return Database.this.prepareQueryImpl((String)object);
            }
        });
        this.updates = new SoftNamedResources("Database " + this.getName() + " update objects", new NamedResourceFactory(){
            private static final long serialVersionUID = 1L;

            public Object makeResource(Object object) {
                Object[] objectArray = (Object[])object;
                return Database.this.prepareUpdateImpl((String)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
            }

            protected Object getHashObject(Object object) {
                Object[] objectArray = (Object[])object;
                return "" + objectArray[0] + "####" + objectArray[1] + "######" + objectArray[2];
            }
        });
    }

    protected Class getTableClassConfigured() {
        return null;
    }

    public abstract String OQLDate(Date var1);

    public Table getTable(String string) {
        int n;
        if (string.indexOf(47) != -1 && (string = string.replace('/', '.')).charAt(0) == '.') {
            string = string.substring(1);
        }
        if ((n = string.indexOf("->")) == -1) {
            return this.getTable(MakumbaSystem.getDataDefinition(string));
        }
        Table table = this.getTable(string.substring(0, n));
        while ((n = (string = string.substring(n + 2)).indexOf("->")) != -1) {
            table = table.getRelatedTable(string.substring(0, n));
        }
        table = table.getRelatedTable(string);
        return table;
    }

    public Table getTable(DataDefinition dataDefinition) {
        return (Table)this.tables.getResource(dataDefinition);
    }

    public static String findConfig(Properties properties, String string) {
        String string2 = null;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string.startsWith(string3) || string2 != null && string2.length() >= string3.length()) continue;
            string2 = string3;
        }
        return string2;
    }

    public abstract Query prepareQueryImpl(String var1);

    public abstract Update prepareUpdateImpl(String var1, String var2, String var3);

    public abstract int getMinPointerValue();

    public abstract int getMaxPointerValue();

    public void deleteFrom(DBConnection dBConnection, String string, DBConnection dBConnection2, boolean bl) {
        DataDefinition dataDefinition = MakumbaSystem.getDataDefinition(string);
        MakumbaSystem.getMakumbaLogger("db.admin.delete").info("deleted " + this.getTable(string).deleteFrom(dBConnection, dBConnection2, bl) + " old objects from " + string);
        Enumeration enumeration = dataDefinition.getFieldNames().elements();
        while (enumeration.hasMoreElements()) {
            FieldDefinition fieldDefinition = dataDefinition.getFieldDefinition((String)enumeration.nextElement());
            if (!fieldDefinition.getType().startsWith("set") && !fieldDefinition.getType().equals("ptrOne")) continue;
            this.deleteFrom(dBConnection, fieldDefinition.getSubtable().getName(), dBConnection2, bl);
        }
    }

    public void deleteFrom(String string, String string2, boolean bl) {
        String[] stringArray = new String[]{string2};
        this.deleteFrom(string, stringArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFrom(String string, String[] stringArray, boolean bl) {
        DBConnection dBConnection = this.getDBConnection();
        DBConnection dBConnection2 = Database.getDatabase(string).getDBConnection();
        try {
            this.deleteFrom(dBConnection, stringArray, dBConnection2, bl);
        }
        finally {
            dBConnection.close();
            dBConnection2.close();
        }
    }

    public void deleteFrom(DBConnection dBConnection, String[] stringArray, DBConnection dBConnection2, boolean bl) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.deleteFrom(dBConnection, stringArray[i], dBConnection2, bl);
        }
    }

    public void copyFrom(String string, String string2, boolean bl) {
        String[] stringArray = new String[]{string2};
        this.copyFrom(string, stringArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(String string, String[] stringArray, boolean bl) {
        DBConnection dBConnection = this.getDBConnection();
        DBConnection dBConnection2 = Database.getDatabase(string).getDBConnection();
        try {
            this.copyFrom(dBConnection, stringArray, dBConnection2, bl);
        }
        finally {
            dBConnection.close();
            dBConnection2.close();
        }
    }

    public void copyFrom(DBConnection dBConnection, String[] stringArray, DBConnection dBConnection2, boolean bl) {
        this.deleteFrom(dBConnection, stringArray, dBConnection2, bl);
        for (int i = 0; i < stringArray.length; ++i) {
            this.copyFrom(dBConnection, stringArray[i], dBConnection2, bl);
        }
    }

    public void copyFrom(DBConnection dBConnection, String string, DBConnection dBConnection2, boolean bl) {
        DataDefinition dataDefinition = MakumbaSystem.getDataDefinition(string);
        this.getTable(string).copyFrom(dBConnection, dBConnection.getHostDatabase().getTable(string), dBConnection2, bl);
        Enumeration enumeration = dataDefinition.getFieldNames().elements();
        while (enumeration.hasMoreElements()) {
            FieldDefinition fieldDefinition = dataDefinition.getFieldDefinition((String)enumeration.nextElement());
            if (!fieldDefinition.getType().startsWith("set") && !fieldDefinition.getType().equals("ptrOne")) continue;
            this.copyFrom(dBConnection, fieldDefinition.getSubtable().getName(), dBConnection2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(String string, boolean bl) {
        DBConnection dBConnection = this.getDBConnection();
        DBConnection dBConnection2 = Database.findDatabase(string).getDBConnection();
        try {
            Vector vector = dBConnection2.executeQuery("SELECT c.name AS name FROM org.makumba.db.Catalog c", null);
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = (String)((Dictionary)vector.elementAt(i)).get("name");
                MakumbaSystem.getMakumbaLogger("db.admin.copy").info(string2);
                stringArray[i] = string2;
            }
            this.copyFrom(dBConnection, stringArray, dBConnection2, bl);
        }
        finally {
            dBConnection.close();
            dBConnection2.close();
        }
    }

    public void openTables(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.openTable(stringArray[i]);
        }
    }

    public void openTable(String string) {
        this.getTable(string);
        DataDefinition dataDefinition = MakumbaSystem.getDataDefinition(string);
        Enumeration enumeration = dataDefinition.getFieldNames().elements();
        while (enumeration.hasMoreElements()) {
            FieldDefinition fieldDefinition = dataDefinition.getFieldDefinition((String)enumeration.nextElement());
            if (!fieldDefinition.getType().startsWith("set") && !fieldDefinition.getType().equals("ptrOne")) continue;
            this.openTable(fieldDefinition.getSubtable().getName());
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void addTable(String string) {
        if (string.equals("org.makumba.db.Catalog")) {
            return;
        }
        DBConnection dBConnection = this.getDBConnection();
        try {
            Enumeration enumeration = dBConnection.executeQuery("SELECT c FROM org.makumba.db.Catalog c WHERE c.name=$1", string).elements();
            if (!enumeration.hasMoreElements()) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>(3);
                ((Dictionary)hashtable).put("name", string);
                this.getTable("org.makumba.db.Catalog").insertRecord(dBConnection, hashtable);
            }
        }
        finally {
            dBConnection.close();
        }
    }

    public Table makePseudoTable(DataDefinition dataDefinition) {
        Table table = null;
        try {
            table = (Table)this.tableclass.newInstance();
        }
        catch (Throwable throwable) {
            throw new MakumbaError(throwable);
        }
        this.configureTable(table, dataDefinition);
        return table;
    }

    void configureTable(Table table, DataDefinition dataDefinition) {
        table.db = this;
        table.setDataDefinition(dataDefinition);
        table.open(this.config);
    }
}

