/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.makumba.DBError;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.db.DBConnection;
import org.makumba.db.DBConnectionWrapper;
import org.makumba.db.Query;
import org.makumba.db.Update;
import org.makumba.db.sql.SQLDBConnection;
import org.makumba.db.sql.SQLPointer;
import org.makumba.db.sql.SQLUpdate;
import org.makumba.db.sql.TableManager;
import org.makumba.util.ClassResource;

public class Database
extends org.makumba.db.Database {
    Properties connectionConfig = new Properties();
    String url;
    String eng;
    Properties types = new Properties();
    boolean addUnderscore = true;
    Hashtable catalog = null;
    static final int DESIRED_TRANSACTION_LEVEL = 4;
    static Properties sqlDrivers = new Properties();

    public String getEngine() {
        return this.eng;
    }

    public static String getEngineProperty(String string) {
        return sqlDrivers.getProperty(string);
    }

    protected DBConnection makeDBConnection() {
        try {
            return new SQLDBConnection(this);
        }
        catch (SQLException sQLException) {
            Database.logException(sQLException);
            throw new DBError(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database(Properties properties) {
        super(properties);
        try {
            String string;
            this.url = this.getJdbcUrl(properties);
            properties.put("jdbc_url", this.url);
            Object object = properties.keys();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                if (!string.startsWith("sql.")) continue;
                this.connectionConfig.put(string.substring(4), properties.getProperty(string).trim());
            }
            if (this.connectionConfig.get("autoReconnect") == null) {
                this.connectionConfig.setProperty("autoReconnect", "true");
            }
            object = properties.getProperty("sql.driver");
            string = properties.getProperty("addUnderscore");
            if (string != null) {
                this.addUnderscore = string.equals("true");
            }
            if (object == null) {
                object = sqlDrivers.getProperty(this.getConfiguration("#sqlEngine"));
            }
            if (object == null) {
                object = sqlDrivers.getProperty(this.url.substring(5, this.url.indexOf(58, 6)));
            }
            MakumbaSystem.getMakumbaLogger("db.init").info("Makumba " + MakumbaSystem.getVersion() + " INIT: " + this.url);
            Class.forName((String)object);
            this.initConnections();
            String string2 = sqlDrivers.getProperty(this.getConfiguration("#sqlEngine") + ".staleConnectionTime");
            if (string2 != null) {
                long l = Long.parseLong(string2) * 60000L;
                this.connections.startStalePreventionThread(l / 2L, l);
            }
            DBConnectionWrapper dBConnectionWrapper = (DBConnectionWrapper)this.getDBConnection();
            SQLDBConnection sQLDBConnection = (SQLDBConnection)dBConnectionWrapper.getWrapped();
            try {
                properties.put("sql_engine.name", sQLDBConnection.getMetaData().getDatabaseProductName().trim());
                properties.put("sql_engine.version", sQLDBConnection.getMetaData().getDatabaseProductVersion().trim());
                properties.put("jdbc_driver.name", sQLDBConnection.getMetaData().getDriverName().trim());
                properties.put("jdbc_driver.version", sQLDBConnection.getMetaData().getDriverVersion().trim());
                MakumbaSystem.getMakumbaLogger("db.init").info("\tconnected to " + properties.get("sql_engine.name") + " version: " + properties.get("sql_engine.version") + "\n\tusing " + properties.get("jdbc_driver.name") + " version: " + properties.get("jdbc_driver.version") + "\n\tusing DBSV " + properties.get("dbsv"));
                if (!sQLDBConnection.getMetaData().supportsTransactionIsolationLevel(4)) {
                    MakumbaSystem.getMakumbaLogger("db.init").warning("transaction isolation level 4 not supported, using " + sQLDBConnection.getMetaData().getDefaultTransactionIsolation());
                }
                this.readCatalog(sQLDBConnection);
            }
            finally {
                dBConnectionWrapper.close();
            }
        }
        catch (Exception exception) {
            throw new MakumbaError(exception);
        }
    }

    protected void readCatalog(SQLDBConnection sQLDBConnection) throws SQLException {
        SQLException sQLException = null;
        Hashtable hashtable = new Hashtable();
        boolean bl = false;
        try {
            ResultSet resultSet = sQLDBConnection.getMetaData().getColumns(null, null, "%", null);
            if (resultSet == null) {
                bl = true;
            } else {
                while (resultSet.next()) {
                    String string = resultSet.getString("TABLE_NAME");
                    Vector<Hashtable<String, Object>> vector = (Vector<Hashtable<String, Object>>)hashtable.get(string);
                    if (vector == null) {
                        vector = new Vector<Hashtable<String, Object>>();
                        hashtable.put(string, vector);
                    }
                    Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>(5);
                    hashtable2.put("COLUMN_NAME", resultSet.getString("COLUMN_NAME"));
                    hashtable2.put("DATA_TYPE", new Integer(resultSet.getInt("DATA_TYPE")));
                    hashtable2.put("TYPE_NAME", resultSet.getString("TYPE_NAME"));
                    hashtable2.put("COLUMN_SIZE", new Integer(resultSet.getInt("COLUMN_SIZE")));
                    vector.addElement(hashtable2);
                }
            }
            resultSet.close();
        }
        catch (SQLException sQLException2) {
            bl = true;
            sQLException = sQLException2;
        }
        if (bl) {
            MakumbaSystem.getMakumbaLogger("db.init").severe("failed to read catalog " + sQLException);
        } else {
            this.catalog = hashtable;
        }
    }

    protected String getJdbcUrl(Properties properties) {
        String string = "jdbc:";
        this.eng = properties.getProperty("#sqlEngine");
        string = string + this.eng + ":";
        String string2 = Database.getEngineProperty(this.eng + ".localJDBC");
        if (string2 == null || !string2.equals("true")) {
            string = string + "//" + properties.getProperty("#host") + "/";
        }
        return string + properties.getProperty("#database");
    }

    public Query prepareQueryImpl(String string) {
        return new org.makumba.db.sql.Query((org.makumba.db.Database)this, string);
    }

    public Update prepareUpdateImpl(String string, String string2, String string3) {
        return new SQLUpdate(this, string, string2, string3);
    }

    public int getMinPointerValue() {
        return this.getDbsv() << SQLPointer.getMaskOrder();
    }

    public int getMaxPointerValue() {
        return (this.getDbsv() + 1 << SQLPointer.getMaskOrder()) - 1;
    }

    protected Class getTableClassConfigured() {
        try {
            String string = this.getConfiguration("tableclass");
            if (string != null || (string = sqlDrivers.getProperty(this.getConfiguration("#sqlEngine") + ".tableclass")) != null) {
                return Class.forName(string);
            }
            return this.getTableClass();
        }
        catch (Exception exception) {
            throw new MakumbaError(exception);
        }
    }

    protected Class getTableClass() {
        return TableManager.class;
    }

    public static String SQLEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer("'");
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuffer.append('\\');
            } else if (c == '\\') {
                stringBuffer.append('\\');
            } else if (c == '\"') {
                stringBuffer.append('\\');
            } else if (c == '\u0000') {
                stringBuffer.append("\\0");
                continue;
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    protected int getMaxTableNameLength() {
        return 64;
    }

    protected int getMaxFieldNameLength() {
        return 64;
    }

    protected String getTableName(String string) {
        String string2 = string;
        if (!this.addUnderscore) {
            string2 = "." + string2.toLowerCase();
        }
        string2 = string2.replace('.', '_').replace('(', '_').replace(')', '_').replace('>', '_').replace('-', '_');
        if ((string2 = string2 + (this.addUnderscore ? "_" : "")).length() <= this.getMaxTableNameLength()) {
            return string2;
        }
        String string3 = Integer.toString(string2.hashCode(), 36).replace('-', '_');
        String string4 = string2.substring(0, this.getMaxTableNameLength() - 3 - string3.length());
        return string4 + "___" + string3;
    }

    protected String getFieldName(String string) {
        String string2 = string;
        if (!this.addUnderscore && !string.startsWith("TS_")) {
            string2 = string2.substring(0, 1).toLowerCase() + string2.substring(1);
        }
        string2 = string2.replace('.', '_');
        if ((string2 = string2 + (this.addUnderscore ? "_" : "")).length() <= this.getMaxFieldNameLength()) {
            return string2;
        }
        String string3 = Integer.toString(string2.hashCode(), 36).replace('-', '_');
        String string4 = string2.substring(0, this.getMaxFieldNameLength() - 3 - string3.length());
        return string4 + "___" + string3;
    }

    protected void checkState(SQLException sQLException, String string) {
        this.checkState(sQLException, string, null);
    }

    protected void checkState(SQLException sQLException, String string, String string2) {
        string = sqlDrivers.getProperty(this.getConfiguration("#sqlEngine") + "." + string);
        if (string != null && sQLException.getSQLState().equals(string)) {
            return;
        }
        MakumbaSystem.getMakumbaLogger("db.init.tablechecking").log(Level.SEVERE, "" + sQLException.getSQLState(), sQLException);
        throw new DBError(sQLException, string2);
    }

    protected int exec(PreparedStatement preparedStatement) {
        try {
            MakumbaSystem.getMakumbaLogger("db.update.execution").fine(preparedStatement.toString());
            preparedStatement.execute();
            int n = preparedStatement.getUpdateCount();
            return n;
        }
        catch (SQLException sQLException) {
            if (this.isDuplicateException(sQLException)) {
                return -1;
            }
            Database.logException(sQLException);
            throw new DBError(sQLException);
        }
    }

    protected boolean isDuplicateException(SQLException sQLException) {
        return sQLException.getMessage().toLowerCase().indexOf("duplicate") != -1;
    }

    static void logException(SQLException sQLException) {
        Database.logException(sQLException, null);
    }

    static void logException(SQLException sQLException, DBConnection dBConnection) {
        String string = "";
        if (dBConnection != null) {
            string = dBConnection.toString() + " ";
        }
        for (SQLException sQLException2 = sQLException; sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            string = string + sQLException2.getMessage() + " SQL state: " + sQLException2.getSQLState() + " error code :" + sQLException2.getErrorCode() + "\n";
        }
        MakumbaSystem.getMakumbaLogger("db.exception").warning("" + string);
    }

    public String OQLDate(Date date) {
        return "date\"" + new Timestamp(date.getTime()) + "\"";
    }

    public Pointer getPointer(String string, int n) {
        return new SQLPointer(string, this.getDbsv(), n);
    }

    public boolean supportsLimitInQuery() {
        return true;
    }

    public String getLimitSyntax() {
        return "LIMIT ?, ?";
    }

    public boolean isLimitOffsetFirst() {
        return true;
    }

    static {
        try {
            sqlDrivers.load(ClassResource.get("org/makumba/db/sql/sqlEngines.properties").openStream());
        }
        catch (Exception exception) {
            throw new MakumbaError(exception);
        }
    }
}

