/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.loader.Loader;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;

public class ScrollableResultsImpl
implements ScrollableResults {
    private final ResultSet rs;
    private final PreparedStatement ps;
    private final SessionImplementor sess;
    private final Loader loader;
    private final QueryParameters queryParameters;
    private final Type[] types;
    private Constructor holderConstructor;
    private Object[] currentRow;

    public boolean scroll(int i) throws HibernateException {
        try {
            boolean result = this.rs.relative(i);
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.sess.getFactory().getSQLExceptionConverter(), sqle, "could not advance using scroll()");
        }
    }

    public boolean first() throws HibernateException {
        try {
            boolean result = this.rs.first();
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.sess.getFactory().getSQLExceptionConverter(), sqle, "could not advance using first()");
        }
    }

    public boolean last() throws HibernateException {
        try {
            boolean result = this.rs.last();
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.sess.getFactory().getSQLExceptionConverter(), sqle, "could not advance using last()");
        }
    }

    public boolean next() throws HibernateException {
        try {
            boolean result = this.rs.next();
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.sess.getFactory().getSQLExceptionConverter(), sqle, "could not advance using next()");
        }
    }

    public boolean previous() throws HibernateException {
        try {
            boolean result = this.rs.previous();
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.sess.getFactory().getSQLExceptionConverter(), sqle, "could not advance using previous()");
        }
    }

    public Object[] get() throws HibernateException {
        return this.currentRow;
    }

    public Object get(int col) throws HibernateException {
        return this.currentRow[col];
    }

    private Object getFinal(int col, Type returnType) throws HibernateException {
        if (this.holderConstructor != null) {
            throw new HibernateException("query specifies a holder class");
        }
        if (returnType.getReturnedClass() == this.types[col].getReturnedClass()) {
            return this.get(col);
        }
        return this.throwInvalidColumnTypeException(col, this.types[col], returnType);
    }

    private Object getNonFinal(int col, Type returnType) throws HibernateException {
        if (this.holderConstructor != null) {
            throw new HibernateException("query specifies a holder class");
        }
        if (returnType.getReturnedClass().isAssignableFrom(this.types[col].getReturnedClass())) {
            return this.get(col);
        }
        return this.throwInvalidColumnTypeException(col, this.types[col], returnType);
    }

    public ScrollableResultsImpl(ResultSet rs, PreparedStatement ps, SessionImplementor sess, Loader loader, QueryParameters queryParameters, Type[] types, Class holderClass) throws MappingException {
        this.rs = rs;
        this.ps = ps;
        this.sess = sess;
        this.loader = loader;
        this.queryParameters = queryParameters;
        this.types = types;
        if (holderClass != null) {
            this.holderConstructor = ReflectHelper.getConstructor(holderClass, types);
        }
    }

    public BigDecimal getBigDecimal(int col) throws HibernateException {
        return (BigDecimal)this.getFinal(col, Hibernate.BIG_DECIMAL);
    }

    public BigInteger getBigInteger(int col) throws HibernateException {
        return (BigInteger)this.getFinal(col, Hibernate.BIG_INTEGER);
    }

    public byte[] getBinary(int col) throws HibernateException {
        return (byte[])this.getFinal(col, Hibernate.BINARY);
    }

    public String getText(int col) throws HibernateException {
        return (String)this.getFinal(col, Hibernate.TEXT);
    }

    public Blob getBlob(int col) throws HibernateException {
        return (Blob)this.getNonFinal(col, Hibernate.BLOB);
    }

    public Clob getClob(int col) throws HibernateException {
        return (Clob)this.getNonFinal(col, Hibernate.CLOB);
    }

    public Boolean getBoolean(int col) throws HibernateException {
        return (Boolean)this.getFinal(col, Hibernate.BOOLEAN);
    }

    public Byte getByte(int col) throws HibernateException {
        return (Byte)this.getFinal(col, Hibernate.BYTE);
    }

    public Character getCharacter(int col) throws HibernateException {
        return (Character)this.getFinal(col, Hibernate.CHARACTER);
    }

    public Date getDate(int col) throws HibernateException {
        return (Date)this.getNonFinal(col, Hibernate.TIMESTAMP);
    }

    public Calendar getCalendar(int col) throws HibernateException {
        return (Calendar)this.getNonFinal(col, Hibernate.CALENDAR);
    }

    public Double getDouble(int col) throws HibernateException {
        return (Double)this.getFinal(col, Hibernate.DOUBLE);
    }

    public Float getFloat(int col) throws HibernateException {
        return (Float)this.getFinal(col, Hibernate.FLOAT);
    }

    public Integer getInteger(int col) throws HibernateException {
        return (Integer)this.getFinal(col, Hibernate.INTEGER);
    }

    public Long getLong(int col) throws HibernateException {
        return (Long)this.getFinal(col, Hibernate.LONG);
    }

    public Short getShort(int col) throws HibernateException {
        return (Short)this.getFinal(col, Hibernate.SHORT);
    }

    public String getString(int col) throws HibernateException {
        return (String)this.getFinal(col, Hibernate.STRING);
    }

    public void afterLast() throws HibernateException {
        try {
            this.rs.afterLast();
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.sess.getFactory().getSQLExceptionConverter(), sqle, "exception calling afterLast()");
        }
    }

    public void beforeFirst() throws HibernateException {
        try {
            this.rs.beforeFirst();
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.sess.getFactory().getSQLExceptionConverter(), sqle, "exception calling beforeFirst()");
        }
    }

    public void close() throws HibernateException {
        try {
            this.sess.getBatcher().closeQueryStatement(this.ps, this.rs);
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.sess.getFactory().getSQLExceptionConverter(), sqle, "could not close results");
        }
    }

    public Locale getLocale(int col) throws HibernateException {
        return (Locale)this.getFinal(col, Hibernate.LOCALE);
    }

    public TimeZone getTimeZone(int col) throws HibernateException {
        return (TimeZone)this.getNonFinal(col, Hibernate.TIMEZONE);
    }

    public Type getType(int i) {
        return this.types[i];
    }

    public boolean isFirst() throws HibernateException {
        try {
            return this.rs.isFirst();
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.sess.getFactory().getSQLExceptionConverter(), sqle, "exception calling isFirst()");
        }
    }

    public boolean isLast() throws HibernateException {
        try {
            return this.rs.isLast();
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.sess.getFactory().getSQLExceptionConverter(), sqle, "exception calling isLast()");
        }
    }

    private Object throwInvalidColumnTypeException(int i, Type type, Type returnType) throws HibernateException {
        throw new HibernateException("incompatible column types: " + type.getName() + ", " + returnType.getName());
    }

    public int getRowNumber() throws HibernateException {
        try {
            return this.rs.getRow() - 1;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.sess.getFactory().getSQLExceptionConverter(), sqle, "exception calling getRow()");
        }
    }

    public boolean setRowNumber(int rowNumber) throws HibernateException {
        if (rowNumber >= 0) {
            ++rowNumber;
        }
        try {
            boolean result = this.rs.absolute(rowNumber);
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.sess.getFactory().getSQLExceptionConverter(), sqle, "could not advance using absolute()");
        }
    }

    private void prepareCurrentRow(boolean underlyingScrollSuccessful) throws HibernateException {
        if (!underlyingScrollSuccessful) {
            this.currentRow = null;
            return;
        }
        Object result = this.loader.loadSingleRow(this.rs, this.sess, this.queryParameters, false);
        this.currentRow = result != null && result.getClass().isArray() ? (Object[])result : new Object[]{result};
        if (this.holderConstructor != null) {
            try {
                this.currentRow = new Object[]{this.holderConstructor.newInstance(this.currentRow)};
            }
            catch (Throwable t) {
                throw new QueryException("Could not instantiate: " + this.holderConstructor.getDeclaringClass(), t);
            }
        }
    }
}

