/*
 * Decompiled with CFR 0.152.
 */
package org.makumba;

import java.io.Serializable;
import org.makumba.InvalidValueException;
import org.makumba.NullObject;

public class Pointer
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int MASK_ORDER = 24;
    protected long n;
    protected String type;
    public static Object Null = new NullObject("null");
    public static Object NullInteger = new NullObject("null integer");
    public static Object NullReal = new NullObject("null real");
    public static Object NullString = new NullObject("null char");
    public static Object NullText = new NullObject("null text");
    public static Object NullDate = new NullObject("null date");
    public static Object NullSet = new NullObject("null set");

    protected Pointer() {
    }

    public int getDbsv() {
        return (int)(this.n >> 24);
    }

    public int getUid() {
        return (int)(this.n & 0xFFFFFFL);
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.getType() + "[" + this.getDbsv() + ":" + this.getUid() + "]";
    }

    static long crc(long l) {
        long l2 = 0L;
        for (int i = 0; i < 32; ++i) {
            if ((l & 1L) == 1L) {
                ++l2;
            }
            l >>= 1;
        }
        return l2;
    }

    public String toExternalForm() {
        long l = (long)this.type.hashCode() & 0xFFFFFFFFL;
        return Long.toString((Pointer.crc(this.n) & 0xFL) << 32 | this.n ^ l, 36);
    }

    public Pointer(String string, String string2) {
        this.type = string;
        long l = (long)string.hashCode() & 0xFFFFFFFFL;
        long l2 = 0L;
        try {
            l2 = Long.parseLong(string2, 36);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidValueException("invalid pointer value: " + string2);
        }
        this.n = l2 & 0xFFFFFFFFL;
        this.n ^= l;
        if (l2 >> 32 != (Pointer.crc(this.n) & 0xFL)) {
            throw new InvalidValueException("invalid external pointer for type " + string + " : " + string2);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Pointer)) {
            return false;
        }
        Pointer pointer = (Pointer)object;
        if (!pointer.getType().equals(this.getType())) {
            System.err.println("warning: " + new InvalidValueException(this, pointer));
            return false;
        }
        return pointer.getDbsv() == this.getDbsv() && pointer.getUid() == this.getUid();
    }

    public int hashCode() {
        return ("" + this.longValue()).hashCode() * this.getType().hashCode();
    }

    public long longValue() {
        return this.n;
    }
}

