/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql.oql;

import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.Token;
import antlr.collections.AST;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.DataDefinitionParseError;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaSystem;
import org.makumba.OQLAnalyzer;
import org.makumba.db.Database;
import org.makumba.db.sql.TableManager;
import org.makumba.db.sql.oql.IdAST;
import org.makumba.db.sql.oql.OQLAST;
import org.makumba.db.sql.oql.ParamAST;
import org.makumba.db.sql.oql.Projection;

public class QueryAST
extends OQLAST
implements OQLAnalyzer {
    private static final long serialVersionUID = 1L;
    String originalQuery;
    AST fromAST;
    AST whereAST;
    AST groupAST;
    AST orderAST;
    AST afterWhereAST;
    AST firstProjection;
    QueryAST superQuery;
    String oneProjectionLabel;
    Vector projections = new Vector();
    Vector projectionLabels;
    Hashtable projectionLabelSearch = new Hashtable();
    Vector parameters = new Vector();
    DataDefinition resultInfo;
    DataDefinition paramInfo;
    Hashtable labels = new Hashtable();
    Hashtable aliases = new Hashtable();
    Vector joins = new Vector();
    Hashtable joinNames = new Hashtable();
    Vector expressions = new Vector();
    Vector expressionIdentifiers = new Vector();

    public QueryAST() {
    }

    public QueryAST(Token token) {
        super(token);
    }

    public void setOQL(String string) {
        this.originalQuery = string;
    }

    public String getOQL() {
        return this.originalQuery;
    }

    public void setFromAST(AST aST) {
        this.fromAST = aST;
    }

    public void setWhereAST(AST aST) {
        this.whereAST = aST;
    }

    public void setGroupAST(AST aST) {
        this.groupAST = aST;
        this.afterWhereAST = aST;
    }

    public void setOrderAST(AST aST) {
        this.orderAST = aST;
        if (this.groupAST == null) {
            this.afterWhereAST = aST;
        }
    }

    public void setSuperQuery(QueryAST queryAST) {
        this.superQuery = queryAST;
    }

    public QueryAST getSuperQuery() {
        return this.superQuery;
    }

    public void addProjection(Projection projection) {
        this.projections.addElement(projection);
        if (projection.as.length() > 0) {
            this.projectionLabelSearch.put(projection.as, projection);
        }
    }

    public void addParameter(ParamAST paramAST) {
        this.parameters.addElement(paramAST);
    }

    public int parameterNumber() {
        return this.parameters.size();
    }

    public int parameterAt(int n) {
        return ((ParamAST)((Object)this.parameters.elementAt((int)n))).number;
    }

    public DataDefinition getProjectionType() {
        if (this.oneProjectionLabel != null) {
            return (DataDefinition)this.labels.get(this.oneProjectionLabel);
        }
        return this.resultInfo;
    }

    public DataDefinition getParameterTypes() {
        return this.paramInfo;
    }

    public DataDefinition getLabelType(String string) {
        String string2 = (String)this.aliases.get(string);
        if (string2 != null) {
            string = string2;
        }
        return (DataDefinition)this.labels.get(string);
    }

    public void setOneProjection(String string) {
        this.oneProjectionLabel = string;
    }

    void computeProjectionTypes() throws RecognitionException {
        if (this.oneProjectionLabel != null) {
            if (this.labels.get(this.oneProjectionLabel) == null) {
                throw new SemanticException("undefined projection label: \"" + this.oneProjectionLabel + "\"");
            }
        } else {
            this.resultInfo = MakumbaSystem.getTemporaryDataDefinition("Result for " + this.originalQuery);
            for (int i = 0; i < this.projections.size(); ++i) {
                Object object;
                Projection projection = (Projection)this.projections.elementAt(i);
                if (projection.as == null || projection.as.length() == 0) {
                    projection.as = "col" + (i + 1);
                }
                if ((object = projection.expr.getMakumbaType()) == null) {
                    System.out.println("\u0007\n\nno type computed for " + projection.expr.getText() + "\n\n");
                    object = "int";
                }
                if (object.toString().startsWith("set")) {
                    throw new SemanticException("You cannot select a set; projection \"" + projection.as + "\" with expression \"" + (Object)((Object)projection.expr) + "\" has type " + object);
                }
                FieldDefinition fieldDefinition = object instanceof String ? MakumbaSystem.makeFieldOfType(projection.as, (String)object) : MakumbaSystem.makeFieldWithName(projection.as, (FieldDefinition)object);
                this.resultInfo.addField(fieldDefinition);
            }
        }
    }

    public void computeParameterTypes() {
        if (this.parameters.size() == 0) {
            return;
        }
        this.paramInfo = MakumbaSystem.getTemporaryDataDefinition("Parameters for " + this.originalQuery);
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParamAST paramAST = (ParamAST)((Object)this.parameters.elementAt(i));
            String string = "param" + i;
            FieldDefinition fieldDefinition = paramAST.makumbaType instanceof String ? MakumbaSystem.makeFieldOfType(string, (String)paramAST.makumbaType) : MakumbaSystem.makeFieldWithName(string, (FieldDefinition)paramAST.makumbaType);
            this.paramInfo.addField(fieldDefinition);
        }
    }

    String addJoin(String string, String string2, String string3, String string4, DataDefinition dataDefinition) {
        this.joins.addElement(new Join(string, string2, string3, string4));
        this.joinNames.put(string + "." + string2, string3);
        this.labels.put(string3, dataDefinition);
        return string3;
    }

    String join(String string, String string2, String string3) throws RecognitionException {
        String string4 = (String)this.joinNames.get(string + "." + string2);
        if (string4 != null) {
            return string4;
        }
        DataDefinition dataDefinition = null;
        DataDefinition dataDefinition2 = null;
        DataDefinition dataDefinition3 = (DataDefinition)this.labels.get(string);
        String string5 = dataDefinition3.getIndexPointerFieldName();
        FieldDefinition fieldDefinition = dataDefinition3.getFieldDefinition(string2);
        if (fieldDefinition == null) {
            throw new SemanticException("no such field \"" + string2 + "\" in makumba type \"" + dataDefinition3.getName() + "\"");
        }
        try {
            dataDefinition = fieldDefinition.getForeignTable();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            dataDefinition2 = fieldDefinition.getSubtable();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string6 = string;
        if (string3 != null) {
            string6 = string3;
        }
        while (this.labels.get(string6) != null) {
            string6 = string6 + "x";
        }
        if (fieldDefinition.getType().equals("ptr")) {
            return this.addJoin(string, string2, string6, dataDefinition.getIndexPointerFieldName(), dataDefinition);
        }
        if (fieldDefinition.getType().equals("ptrOne")) {
            return this.addJoin(string, string2, string6, dataDefinition2.getIndexPointerFieldName(), dataDefinition2);
        }
        if (fieldDefinition.getType().equals("setComplex") || fieldDefinition.getType().equals("setintEnum") || fieldDefinition.getType().equals("setcharEnum")) {
            return this.addJoin(string, string5, string6, string5, dataDefinition2);
        }
        if (fieldDefinition.getType().equals("set")) {
            string6 = string + "x";
            while (this.labels.get(string6) != null) {
                string6 = string6 + "x";
            }
            this.addJoin(string, string5, string6, string5, dataDefinition2);
            this.labels.put(string6, dataDefinition2);
            String string7 = string;
            if (string3 != null) {
                string7 = string3;
            }
            while (this.labels.get(string7) != null) {
                string7 = string7 + "x";
            }
            return this.addJoin(string6, dataDefinition2.getSetMemberFieldName(), string7, dataDefinition.getIndexPointerFieldName(), dataDefinition);
        }
        throw new RecognitionException("\"" + string2 + "\" is not a set or pointer in makumba type \"" + dataDefinition3.getName() + "\"");
    }

    public void addFrom(String string, String string2) throws RecognitionException {
        block10: {
            String string3 = string;
            DataDefinition dataDefinition = null;
            try {
                dataDefinition = MakumbaSystem.getDataDefinition(string3);
            }
            catch (DataDefinitionNotFoundError dataDefinitionNotFoundError) {
            }
            catch (DataDefinitionParseError dataDefinitionParseError) {
                throw new RecognitionException(dataDefinitionParseError.getMessage());
            }
            if (dataDefinition != null) {
                this.labels.put(string2, dataDefinition);
                return;
            }
            int n = string3.indexOf(46);
            if (n > 0) {
                String string4 = string3.substring(0, n);
                while (true) {
                    String string5;
                    if (this.labels.get(string4) == null) {
                        string5 = (String)this.aliases.get(string4);
                        if (string5 == null) {
                            throw new SemanticException("could not find type \"" + string + "\" or label \"" + string4 + "\"");
                        }
                        string4 = string5;
                    }
                    string5 = string3 = string3.substring(n + 1);
                    n = string3.indexOf(46);
                    if (n == -1) {
                        this.join(string4, string5, string2);
                        break block10;
                    }
                    string5 = string3.substring(0, n);
                    string4 = this.join(string4, string5, null);
                }
            }
            if (this.labels.get(string) == null) {
                throw new SemanticException("could not find type \"" + string + "\"");
            }
            this.aliases.put(string2, string);
        }
    }

    public void addExpression(AST aST) {
        this.expressions.addElement(aST);
    }

    void computeExpressionTypes() throws RecognitionException {
        Enumeration enumeration = this.expressions.elements();
        while (enumeration.hasMoreElements()) {
            OQLAST oQLAST = (OQLAST)((Object)enumeration.nextElement());
            oQLAST.getMakumbaType();
        }
    }

    public void addExpressionIdentifier(AST aST) {
        this.expressionIdentifiers.addElement(aST);
    }

    void treatExpressionIdentifiers() throws RecognitionException {
        Enumeration enumeration = this.expressionIdentifiers.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            DataDefinition dataDefinition;
            String string2;
            AST aST = (AST)enumeration.nextElement();
            IdAST idAST = (IdAST)aST;
            idAST.query = this;
            String string3 = aST.getText();
            String string4 = null;
            String string5 = string3;
            int n = string3.indexOf(".");
            String string6 = string3;
            if (n != -1) {
                string6 = string3.substring(0, n);
            }
            if ((string2 = (String)this.aliases.get(string6)) != null) {
                string6 = string2;
            }
            if ((dataDefinition = (DataDefinition)this.labels.get(string6)) == null) {
                if (n == -1 && this.projectionLabelSearch.get(string6) != null) {
                    boolean bl = true;
                    for (AST aST2 = aST; aST2 != null; aST2 = aST2.getNextSibling()) {
                        if (aST2 != this.afterWhereAST) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        idAST.projectionLabel = string6;
                        continue;
                    }
                }
                throw new SemanticException("undefined label: \"" + string6 + "\"");
            }
            if (n != -1) {
                while (true) {
                    FieldDefinition fieldDefinition;
                    string4 = string3 = string3.substring(n + 1);
                    n = string3.indexOf(46);
                    if (n != -1) {
                        string4 = string3.substring(0, n);
                    }
                    if ((fieldDefinition = dataDefinition.getFieldDefinition(string4)) == null) {
                        throw new SemanticException("no such field \"" + string4 + "\" in makumba type \"" + dataDefinition.getName() + "\"");
                    }
                    if ((fieldDefinition.getType().equals("set") || fieldDefinition.getType().equals("setComplex")) && n != -1) {
                        throw new SemanticException("set joins not allowed outside where clause; \"" + string5 + "\" contains reference to \"" + dataDefinition.getName() + "->" + string4 + "\"");
                    }
                    if (n == -1) break;
                    string6 = this.join(string6, string4, null);
                    dataDefinition = fieldDefinition.getPointedType();
                }
            }
            idAST.label = string6;
            idAST.field = string4;
            if (idAST.field == null && dataDefinition.getParentField() != null && ((string = dataDefinition.getParentField().getType()).equals("setintEnum") || string.equals("setcharEnum"))) {
                idAST.field = "enum";
            }
            if (idAST.field == null) {
                idAST.field = dataDefinition.getIndexPointerFieldName();
            }
            idAST.makumbaType = dataDefinition.getFieldDefinition(idAST.field);
        }
    }

    protected void writeDistinct(Database database, StringBuffer stringBuffer) {
        if (this.getFirstChild().getText().toLowerCase().equals("distinct")) {
            stringBuffer.append(" DISTINCT ");
            this.firstProjection = this.getFirstChild().getNextSibling();
        } else {
            this.firstProjection = this.getFirstChild();
        }
    }

    protected void writeProjection(Database database, StringBuffer stringBuffer) {
        if (this.oneProjectionLabel != null) {
            stringBuffer.append(" ").append(this.oneProjectionLabel).append(".*");
        } else {
            for (AST aST = this.firstProjection; aST != this.fromAST; aST = aST.getNextSibling()) {
                stringBuffer.append(" ").append(((OQLAST)aST).writeInSQLQuery(database));
            }
        }
    }

    protected void writeFrom(Database database, StringBuffer stringBuffer) {
        boolean bl = false;
        Enumeration enumeration = this.labels.keys();
        while (enumeration.hasMoreElements()) {
            if (bl) {
                stringBuffer.append(",");
            }
            bl = true;
            String string = (String)enumeration.nextElement();
            stringBuffer.append(this.getTableName(string, database)).append(" ").append(string);
        }
    }

    protected String getTableName(String string, Database database) {
        DataDefinition dataDefinition = (DataDefinition)this.labels.get(string);
        try {
            return ((TableManager)database.getTable(dataDefinition)).getDBName();
        }
        catch (NullPointerException nullPointerException) {
            return dataDefinition.getName();
        }
    }

    protected String getFieldName(String string, String string2, Database database) {
        DataDefinition dataDefinition = (DataDefinition)this.labels.get(string);
        try {
            return ((TableManager)database.getTable(dataDefinition)).getFieldDBName(string2);
        }
        catch (NullPointerException nullPointerException) {
            return string2;
        }
    }

    protected void writeJoins(Database database, StringBuffer stringBuffer) {
        boolean bl = false;
        Enumeration enumeration = this.joins.elements();
        while (enumeration.hasMoreElements()) {
            Join join = (Join)enumeration.nextElement();
            if (bl) {
                stringBuffer.append(" AND ");
            }
            bl = true;
            stringBuffer.append(join.label1).append(".").append(this.getFieldName(join.label1, join.field1, database)).append("= ").append(join.label2).append(".").append(this.getFieldName(join.label2, join.field2, database));
        }
    }

    protected void writeConditions(Database database, StringBuffer stringBuffer) {
        stringBuffer.append("(");
        for (AST aST = this.whereAST.getNextSibling(); aST != this.afterWhereAST; aST = aST.getNextSibling()) {
            stringBuffer.append(" ").append(((OQLAST)aST).writeInSQLQuery(database));
        }
        stringBuffer.append(")");
    }

    protected void writeAfterWhere(Database database, StringBuffer stringBuffer) {
        for (AST aST = this.afterWhereAST; aST != null; aST = aST.getNextSibling()) {
            stringBuffer.append(" ").append(((OQLAST)aST).writeInSQLQuery(database));
        }
    }

    public void prepare() throws RecognitionException {
        this.treatExpressionIdentifiers();
        this.computeExpressionTypes();
        this.computeProjectionTypes();
        this.computeParameterTypes();
    }

    public String writeInSQLQuery(Database database) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        this.writeDistinct(database, stringBuffer);
        this.writeProjection(database, stringBuffer);
        if (this.labels.size() > 0) {
            stringBuffer.append(" FROM ");
            this.writeFrom(database, stringBuffer);
        }
        boolean bl2 = bl = this.joins.size() > 0;
        if (this.whereAST != null || bl) {
            stringBuffer.append(" WHERE ");
            if (bl) {
                this.writeJoins(database, stringBuffer);
            }
            if (this.whereAST != null) {
                if (bl) {
                    stringBuffer.append(" AND ");
                }
                this.writeConditions(database, stringBuffer);
            }
        }
        this.writeAfterWhere(database, stringBuffer);
        return stringBuffer.toString();
    }

    class Join {
        String label1;
        String field1;
        String label2;
        String field2;

        public Join(String string, String string2, String string3, String string4) {
            this.label1 = string;
            this.label2 = string3;
            this.field1 = string2;
            this.field2 = string4;
        }

        public String toString() {
            return this.label1 + "." + this.field1 + " JOIN " + this.label2 + "." + this.field2;
        }
    }
}

