/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.makumba.AttributeNotFoundException;
import org.makumba.ConfigFileError;
import org.makumba.DBError;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.DataDefinitionParseError;
import org.makumba.InvalidFieldTypeException;
import org.makumba.InvalidValueException;
import org.makumba.LogicException;
import org.makumba.LogicInvocationError;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.NoSuchFieldException;
import org.makumba.OQLParseError;
import org.makumba.ProgrammerError;
import org.makumba.UnauthorizedException;
import org.makumba.devel.errorViewer;
import org.makumba.util.JspParseData;
import org.makumba.util.RuntimeWrappedException;
import org.makumba.view.jsptaglib.MakumbaJspException;
import org.makumba.view.jsptaglib.MakumbaTag;
import org.makumba.view.jsptaglib.TomcatJsp;

public class TagExceptionServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    static Object[][] errors = new Object[][]{{OQLParseError.class, "query"}, {DataDefinitionNotFoundError.class, "data definition not found"}, {DataDefinitionParseError.class, "data definition parse"}, {DBError.class, "database"}, {ConfigFileError.class, "configuration"}, {ProgrammerError.class, "programmer"}, {MakumbaJspException.class, "page"}, {AttributeNotFoundException.class, "attribute not set"}, {UnauthorizedException.class, "authorization"}, {InvalidValueException.class, "invalid value"}, {InvalidFieldTypeException.class, "invalid field type"}, {NoSuchFieldException.class, "no such field"}, {LogicException.class, "business logic"}};

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        Throwable throwable = (Throwable)httpServletRequest.getAttribute("javax.servlet.jsp.jspException");
        Throwable throwable2 = null;
        Throwable throwable3 = throwable;
        while (true) {
            if (throwable instanceof LogicException) {
                throwable2 = ((LogicException)throwable).getReason();
            } else if (throwable instanceof MakumbaError && !(throwable instanceof OQLParseError)) {
                throwable2 = ((MakumbaError)throwable).getReason();
            } else if (throwable instanceof LogicInvocationError) {
                throwable2 = ((LogicInvocationError)throwable).getReason();
            } else {
                if (!(throwable instanceof RuntimeWrappedException)) break;
                throwable2 = ((RuntimeWrappedException)throwable).getReason();
            }
            if (throwable2 == null) break;
            throwable = throwable2;
        }
        if (throwable.getClass().getName().startsWith(TomcatJsp.getJspCompilerPackage())) {
            this.knownError("JSP compilation error", throwable, throwable3, httpServletRequest, printWriter);
            return;
        }
        for (int i = 0; i < errors.length; ++i) {
            if (!((Class)errors[i][0]).isInstance(throwable) && (throwable2 == null || !((Class)errors[i][0]).isInstance(throwable = throwable2))) continue;
            this.knownError("Makumba " + errors[i][1] + " error", throwable, throwable3, httpServletRequest, printWriter);
            return;
        }
        this.unknownError(throwable3, throwable, printWriter, httpServletRequest);
        printWriter.flush();
    }

    void knownError(String string, Throwable throwable, Throwable throwable2, HttpServletRequest httpServletRequest, PrintWriter printWriter) {
        String string2 = this.trace(throwable);
        String string3 = this.shortTrace(string2);
        String string4 = throwable.getMessage();
        String string5 = null;
        string4 = this.formatTagData() + string4;
        if (throwable2 instanceof LogicInvocationError || string2.indexOf("at org.makumba.abstr.Logic") != -1) {
            string4 = string4 + "\n\n" + string3;
        } else {
            string5 = string3;
        }
        try {
            errorViewer errorViewer2 = new errorViewer(httpServletRequest, this, string, string4, string5);
            errorViewer2.parseText(printWriter);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeWrappedException(iOException);
        }
    }

    String formatTagData() {
        String string = "During analysis of the following tag (and possibly tags inside it):";
        JspParseData.TagData tagData = MakumbaTag.getAnalyzedTag();
        if (tagData == null) {
            string = "During running of:";
            tagData = MakumbaTag.getRunningTag();
        }
        if (tagData == null) {
            string = "While executing inside this body tag, but most probably _not_ due to the tag:";
            tagData = MakumbaTag.getCurrentBodyTag();
        }
        if (tagData == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            JspParseData.tagDataLine(tagData, stringBuffer);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            return string + "\n" + tagData.getStart().getFile().getCanonicalPath() + ":" + tagData.getStart().getLine() + ":" + tagData.getStart().getColumn() + ":" + tagData.getEnd().getLine() + ":" + tagData.getEnd().getColumn() + "\n" + stringBuffer.toString() + "\n\n";
        }
        catch (IOException iOException) {
            throw new MakumbaError(iOException.toString());
        }
    }

    String trace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    String shortTrace(String string) {
        int n = string.indexOf("at org.makumba.controller.Logic");
        if (n != -1) {
            if ((n = (string = string.substring(0, n)).indexOf("at sun.reflect")) != -1) {
                string = string.substring(0, n);
            }
        } else {
            n = string.indexOf("at javax.servlet.http.HttpServlet.service(HttpServlet.java");
            if (n != -1) {
                string = string.substring(0, n);
            } else {
                n = string.indexOf("at org.makumba.controller.http.ControllerFilter.doFilter(ControllerFilter.java");
                if (n != -1) {
                    string = string.substring(0, n);
                } else {
                    MakumbaSystem.getMakumbaLogger("devel").severe("servlet or filter call not found in stacktrace");
                }
            }
        }
        return string;
    }

    void unknownError(Throwable throwable, Throwable throwable2, PrintWriter printWriter, HttpServletRequest httpServletRequest) throws IOException, ServletException {
        Throwable throwable3 = throwable2;
        String string = "";
        String string2 = "";
        if (throwable instanceof LogicInvocationError) {
            string = "Error in business logic code";
        } else if (this.trace(throwable3).indexOf("org.makumba") != -1) {
            string = "Internal Makumba error";
            string2 = "Please report to the developers.\n\n";
            if (throwable2 instanceof ServletException && (throwable3 = ((ServletException)throwable2).getRootCause()) == null) {
                throwable3 = throwable2;
            }
        } else {
            string = "Error in JSP Java scriplet or servlet container";
        }
        if (throwable3 instanceof SQLException) {
            string = "SQL " + string;
            string2 = "The problem is related to SQL:\n\t SQLstate: " + ((SQLException)throwable3).getSQLState() + "\n" + "\tErrorCode: " + ((SQLException)throwable3).getErrorCode() + "\n" + "\t  Message: " + throwable3.getMessage() + "\n\n" + "Refer to your SQL server's documentation for error explanation.\n" + "Please check the configuration of your webapp and SQL server.\n" + string2;
        }
        string2 = this.formatTagData() + string2 + this.shortTrace(this.trace(throwable3));
        try {
            errorViewer errorViewer2 = new errorViewer(httpServletRequest, this, string, string2, null);
            errorViewer2.parseText(printWriter);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeWrappedException(iOException);
        }
    }
}

