/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makumba.MakumbaSystem;
import org.makumba.util.SyntaxPoint;

public class SourceSyntaxPoints {
    File file;
    PreprocessorClient client;
    long lastChanged;
    TreeSet syntaxPoints = new TreeSet();
    ArrayList lineBeginnings = new ArrayList();
    ArrayList fileBeginningIndexes = new ArrayList();
    ArrayList fileBeginnings = new ArrayList();
    String originalText;
    String content;
    int offset;
    SourceSyntaxPoints parent;

    public String toString() {
        return this.file.toString() + " " + this.offset;
    }

    public SourceSyntaxPoints(File file, PreprocessorClient preprocessorClient) {
        this(file, preprocessorClient, null, 0);
    }

    public SourceSyntaxPoints(File file, PreprocessorClient preprocessorClient, SourceSyntaxPoints sourceSyntaxPoints, int n) {
        this.offset = n;
        this.parent = sourceSyntaxPoints;
        this.file = file;
        this.client = preprocessorClient;
        this.lastChanged = this.file.lastModified();
        this.content = this.originalText = this.readFile();
        this.fileBeginningIndexes.add(new Integer(0));
        this.fileBeginnings.add(this);
        this.findLineBreaks();
        for (int i = 0; i < this.client.getCommentPatterns().length; ++i) {
            this.unComment(i);
        }
        if (this.client.getIncludePattern() != null) {
            this.include();
        }
    }

    void findLineBreaks() {
        int n = 0;
        int n2 = 1;
        int n3 = this.originalText.length();
        for (int i = 0; i < n3; ++i) {
            if (this.originalText.charAt(i) == '\r') {
                if (i + 1 < n3 && this.originalText.charAt(i + 1) == '\n') {
                    ++i;
                }
            } else if (this.originalText.charAt(i) != '\n') continue;
            this.addSyntaxPointsLine(n, i, "TextLine", new Integer(n2));
            n = i + 1;
            ++n2;
        }
        if (n < n3) {
            this.addSyntaxPointsLine(n, n3, "TextLine", new Integer(n2));
        }
    }

    public String getLineText(int n) {
        SyntaxPoint syntaxPoint = (SyntaxPoint)this.lineBeginnings.get(n - 1);
        if (n == this.lineBeginnings.size()) {
            return this.originalText.substring(syntaxPoint.getOriginalPosition());
        }
        SyntaxPoint syntaxPoint2 = (SyntaxPoint)this.lineBeginnings.get(n);
        return this.originalText.substring(syntaxPoint.getOriginalPosition(), syntaxPoint2.getOriginalPosition() - 1);
    }

    void include() {
        Matcher matcher;
        while ((matcher = this.client.getIncludePattern().matcher(this.content)).find()) {
            this.client.treatInclude(matcher.start(), this.content.substring(matcher.start(), matcher.end()), this);
        }
        return;
    }

    public void include(File file, int n, String string) {
        SourceSyntaxPoints sourceSyntaxPoints = new SourceSyntaxPoints(file, this.client, this, n);
        int n2 = sourceSyntaxPoints.getContent().length() - string.length();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.content.substring(0, n)).append(sourceSyntaxPoints.getContent()).append(this.content.substring(n + string.length()));
        this.content = stringBuffer.toString();
        Iterator iterator = this.syntaxPoints.iterator();
        while (iterator.hasNext()) {
            SyntaxPoint syntaxPoint = (SyntaxPoint)iterator.next();
            if (syntaxPoint.position <= n) continue;
            syntaxPoint.moveByInclude(n2);
        }
        int n3 = this.fileBeginningIndexes.size() - 1;
        if ((Integer)this.fileBeginningIndexes.get(n3) == n) {
            this.fileBeginnings.set(n3, sourceSyntaxPoints);
        } else {
            this.fileBeginningIndexes.add(new Integer(n));
            this.fileBeginnings.add(sourceSyntaxPoints);
        }
        this.fileBeginningIndexes.add(new Integer(n + n2));
        this.fileBeginnings.add(this);
    }

    void unComment(int n) {
        Matcher matcher = this.client.getCommentPatterns()[n].matcher(this.content);
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            stringBuffer.append(this.content.substring(n2, matcher.start()));
            for (int i = matcher.start(); i < matcher.end(); ++i) {
                stringBuffer.append(' ');
            }
            n2 = matcher.end();
            MakumbaSystem.getMakumbaLogger("syntaxpoint.comment").fine("UNCOMMENT " + this.client.getCommentPatternNames()[n] + " : " + matcher.group());
            this.addSyntaxPoints(matcher.start() + this.offset, matcher.end() + this.offset, this.client.getCommentPatternNames()[n], null);
        }
        stringBuffer.append(this.content.substring(n2));
        this.content = stringBuffer.toString();
    }

    public SyntaxPoint.End addSyntaxPoints(int n, int n2, String string, Object object) {
        return this.findSourceFile(n).addSyntaxPoints1(n, n2, string, object);
    }

    SyntaxPoint.End addSyntaxPoints1(int n, int n2, String string, Object object) {
        SyntaxPoint.End end = this.addSyntaxPointsCommon(n, n2, string, object);
        this.setLineAndColumn(end);
        this.setLineAndColumn((SyntaxPoint)end.getOtherInfo());
        return end;
    }

    void setLineAndColumn(SyntaxPoint syntaxPoint) {
        SyntaxPoint syntaxPoint2 = (SyntaxPoint)this.lineBeginnings.get(-1 * Collections.binarySearch(this.lineBeginnings, syntaxPoint) - 2);
        syntaxPoint.line = syntaxPoint2.line;
        syntaxPoint.column = syntaxPoint.position - syntaxPoint2.position + 1;
        syntaxPoint.sourceFile = this;
    }

    SourceSyntaxPoints findSourceFile(int n) {
        int n2 = Collections.binarySearch(this.fileBeginningIndexes, new Integer(n));
        if (n2 < 0) {
            n2 = -n2 - 2;
        }
        return (SourceSyntaxPoints)this.fileBeginnings.get(n2);
    }

    SyntaxPoint.End addSyntaxPointsCommon(int n, int n2, String string, Object object) {
        final String string2 = string;
        final Object object2 = object;
        SyntaxPoint syntaxPoint = new SyntaxPoint(n){

            public String getType() {
                return string2;
            }

            public Object getOtherInfo() {
                return object2;
            }
        };
        this.syntaxPoints.add(syntaxPoint);
        SyntaxPoint.End end = (SyntaxPoint.End)SyntaxPoint.makeEnd(syntaxPoint, n2);
        this.syntaxPoints.add(end);
        return end;
    }

    void addSyntaxPointsLine(int n, int n2, String string, Object object) {
        SyntaxPoint.End end = this.addSyntaxPointsCommon(n, n2, string, object);
        end.moveByInclude(this.offset);
        SyntaxPoint syntaxPoint = (SyntaxPoint)end.getOtherInfo();
        syntaxPoint.moveByInclude(this.offset);
        syntaxPoint.line = end.line = ((Integer)syntaxPoint.getOtherInfo()).intValue();
        syntaxPoint.column = 1;
        end.column = n2 - n + 1;
        end.sourceFile = syntaxPoint.sourceFile = this;
        this.lineBeginnings.add(syntaxPoint);
    }

    boolean unchanged() {
        if (this.file.lastModified() != this.lastChanged) {
            return false;
        }
        Iterator iterator = this.fileBeginnings.iterator();
        while (iterator.hasNext()) {
            SourceSyntaxPoints sourceSyntaxPoints = (SourceSyntaxPoints)iterator.next();
            if (sourceSyntaxPoints == this || sourceSyntaxPoints.unchanged()) continue;
            return false;
        }
        return true;
    }

    String readFile() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));
            char[] cArray = new char[2048];
            while ((n = bufferedReader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    String getContent() {
        return this.content;
    }

    public SyntaxPoint[] getSyntaxPoints() {
        ArrayList arrayList = new ArrayList(this.syntaxPoints);
        Collections.sort(arrayList);
        SyntaxPoint[] syntaxPointArray = arrayList.toArray(new SyntaxPoint[this.syntaxPoints.size()]);
        int n = 0;
        while (n + 1 < syntaxPointArray.length) {
            if (syntaxPointArray[n].getType().equals("TextLine") && syntaxPointArray[n + 1].getType().equals("TextLine") && syntaxPointArray[n].getLine() == syntaxPointArray[n + 1].getLine() && syntaxPointArray[n].getColumn() == syntaxPointArray[n + 1].getColumn() && !syntaxPointArray[n].isBegin() && syntaxPointArray[n + 1].isBegin()) {
                SyntaxPoint syntaxPoint = syntaxPointArray[n];
                syntaxPointArray[n] = syntaxPointArray[n + 1];
                syntaxPointArray[n + 1] = syntaxPoint;
            }
            ++n;
        }
        return syntaxPointArray;
    }

    static interface PreprocessorClient {
        public void treatInclude(int var1, String var2, SourceSyntaxPoints var3);

        public Pattern[] getCommentPatterns();

        public String[] getCommentPatternNames();

        public Pattern getIncludePattern();

        public String getIncludePatternName();
    }
}

