/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.ObjectDeletedException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheKey;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.def.AbstractReassociateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;

public class AbstractLockUpgradeEventListener
extends AbstractReassociateEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$def$AbstractLockUpgradeEventListener == null ? (class$org$hibernate$event$def$AbstractLockUpgradeEventListener = AbstractLockUpgradeEventListener.class$("org.hibernate.event.def.AbstractLockUpgradeEventListener")) : class$org$hibernate$event$def$AbstractLockUpgradeEventListener));
    static /* synthetic */ Class class$org$hibernate$event$def$AbstractLockUpgradeEventListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void upgradeLock(Object object, EntityEntry entry, LockMode requestedLockMode, SessionImplementor source) throws HibernateException {
        CacheConcurrencyStrategy.SoftLock lock;
        CacheKey ck;
        if (!requestedLockMode.greaterThan(entry.getLockMode())) return;
        if (entry.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("attempted to lock a deleted instance", entry.getId(), entry.getPersister().getEntityName());
        }
        EntityPersister persister = entry.getPersister();
        if (log.isTraceEnabled()) {
            log.trace((Object)("locking " + MessageHelper.infoString(persister, entry.getId(), source.getFactory()) + " in mode: " + requestedLockMode));
        }
        if (persister.hasCache()) {
            ck = new CacheKey(entry.getId(), persister.getIdentifierType(), persister.getRootEntityName(), source.getEntityMode(), source.getFactory());
            lock = persister.getCache().lock(ck, entry.getVersion());
        } else {
            ck = null;
            lock = null;
        }
        try {
            persister.lock(entry.getId(), entry.getVersion(), object, requestedLockMode, source);
            entry.setLockMode(requestedLockMode);
            Object var9_8 = null;
            if (!persister.hasCache()) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!persister.hasCache()) throw throwable;
            persister.getCache().release(ck, lock);
            throw throwable;
        }
        persister.getCache().release(ck, lock);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

