/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.abstr;

import java.io.Serializable;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.DataDefinitionParseError;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.NoSuchFieldException;
import org.makumba.abstr.FieldInfo;
import org.makumba.abstr.RecordParser;
import org.makumba.util.NamedResourceFactory;
import org.makumba.util.NamedResources;
import org.makumba.util.RuntimeWrappedException;

public class RecordInfo
implements Serializable,
DataDefinition {
    private static final long serialVersionUID = 1L;
    URL origin;
    String name;
    Properties templateValues;
    Vector fieldOrder = new Vector();
    String title;
    String indexName;
    static final String createName = "TS_create";
    static final String modifyName = "TS_modify";
    String mainPtr;
    String setField;
    int relations = 0;
    Hashtable fields = new Hashtable();
    String subfield;
    String ptrSubfield = "";
    String subfieldPtr = "";
    RecordInfo papa;
    static int infos = NamedResources.makeStaticCache("Data definitions parsed", new NamedResourceFactory(){
        private static final long serialVersionUID = 1L;

        protected Object getHashObject(Object object) {
            URL uRL = RecordParser.findDataDefinition((String)object, "mdd");
            if (uRL == null) {
                throw new DataDefinitionNotFoundError((String)object);
            }
            return uRL;
        }

        protected Object makeResource(Object object, Object object2) {
            String string = (String)object;
            if (string.indexOf(47) != -1) {
                string = string.replace('/', '.').substring(1);
            }
            return new RecordInfo((URL)object2, string);
        }

        protected void configureResource(Object object, Object object2, Object object3) {
            new RecordParser().parse((RecordInfo)object3);
        }
    });

    void addStandardFields(String string) {
        this.indexName = string;
        FieldInfo fieldInfo = new FieldInfo(this, this.indexName);
        fieldInfo.type = "ptrIndex";
        fieldInfo.description = "Unique index";
        fieldInfo.fixed = true;
        fieldInfo.notNull = true;
        fieldInfo.unique = true;
        this.addField1(fieldInfo);
        fieldInfo = new FieldInfo(this, modifyName);
        fieldInfo.type = "dateModify";
        fieldInfo.notNull = true;
        fieldInfo.description = "Last modification date";
        this.addField1(fieldInfo);
        fieldInfo = new FieldInfo(this, createName);
        fieldInfo.type = "dateCreate";
        fieldInfo.description = "Creation date";
        fieldInfo.fixed = true;
        fieldInfo.notNull = true;
        this.addField1(fieldInfo);
    }

    public boolean isTemporary() {
        return this.origin == null;
    }

    RecordInfo() {
        this.name = "temp" + this.hashCode();
    }

    public RecordInfo(String string) {
        this.name = string;
        this.origin = null;
    }

    protected void addField1(FieldDefinition fieldDefinition) {
        this.fieldOrder.addElement(fieldDefinition.getName());
        this.fields.put(fieldDefinition.getName(), fieldDefinition);
        ((FieldInfo)fieldDefinition).dd = this;
    }

    public void addField(FieldDefinition fieldDefinition) {
        if (!this.isTemporary()) {
            throw new RuntimeException("can't add field to non-temporary type");
        }
        this.addField1(fieldDefinition);
    }

    RecordInfo(URL uRL, String string) {
        this.name = string;
        this.origin = uRL;
    }

    RecordInfo(RecordInfo recordInfo, String string) {
        this.name = recordInfo.name;
        this.origin = recordInfo.origin;
        this.subfield = string;
        this.papa = recordInfo;
        this.ptrSubfield = this.papa.ptrSubfield + "->" + string;
        this.subfieldPtr = this.papa.subfieldPtr + string + "->";
    }

    public static DataDefinition getRecordInfo(String string) {
        int n = string.indexOf("->");
        if (n == -1) {
            try {
                return RecordInfo.getSimpleRecordInfo(string);
            }
            catch (DataDefinitionNotFoundError dataDefinitionNotFoundError) {
                n = string.lastIndexOf(".");
                if (n == -1) {
                    throw dataDefinitionNotFoundError;
                }
                try {
                    return RecordInfo.getRecordInfo(string.substring(0, n) + "->" + string.substring(n + 1));
                }
                catch (DataDefinitionParseError dataDefinitionParseError) {
                    throw dataDefinitionNotFoundError;
                }
            }
        }
        DataDefinition dataDefinition = RecordInfo.getRecordInfo(string.substring(0, n));
        while ((n = (string = string.substring(n + 2)).indexOf("->")) != -1) {
            dataDefinition = dataDefinition.getFieldDefinition(string.substring(0, n)).getSubtable();
        }
        dataDefinition = dataDefinition.getFieldDefinition(string).getSubtable();
        return dataDefinition;
    }

    public static synchronized DataDefinition getSimpleRecordInfo(String string) {
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '.') {
                if (bl) {
                    throw new DataDefinitionParseError("two consecutive dots not allowed in type name");
                }
                bl = true;
            } else {
                bl = false;
            }
            if (string.charAt(i) == '/' || string.charAt(i) == '.' || (i != 0 || Character.isJavaIdentifierStart(string.charAt(i))) && (i <= 0 || Character.isJavaIdentifierPart(string.charAt(i)))) continue;
            throw new DataDefinitionParseError("Invalid character \"" + string.charAt(i) + "\" in type name \"" + string + "\"");
        }
        if (string.indexOf(47) != -1 && (string = string.replace('/', '.')).charAt(0) == '.') {
            string = string.substring(1);
        }
        DataDefinition dataDefinition = null;
        try {
            dataDefinition = (DataDefinition)NamedResources.getStaticCache(infos).getResource(string);
        }
        catch (RuntimeWrappedException runtimeWrappedException) {
            if (runtimeWrappedException.getReason() instanceof DataDefinitionParseError) {
                throw (DataDefinitionParseError)runtimeWrappedException.getReason();
            }
            if (runtimeWrappedException.getReason() instanceof MakumbaError) {
                throw (MakumbaError)runtimeWrappedException.getReason();
            }
            throw runtimeWrappedException;
        }
        if (string.indexOf("./") == -1) {
            ((RecordInfo)dataDefinition).name = string;
        } else {
            MakumbaSystem.getMakumbaLogger("debug.abstr").severe("shit happens: " + string);
        }
        return dataDefinition;
    }

    public Vector getFieldNames() {
        return (Vector)this.fieldOrder.clone();
    }

    public FieldDefinition getFieldDefinition(String string) {
        return (FieldDefinition)this.fields.get(string);
    }

    public FieldDefinition getFieldDefinition(int n) {
        if (n < 0 || n >= this.fieldOrder.size()) {
            return null;
        }
        return this.getFieldDefinition((String)this.fieldOrder.elementAt(n));
    }

    public String getName() {
        return this.name + this.ptrSubfield;
    }

    String getBaseName() {
        return this.name;
    }

    public String fieldPrefix() {
        return this.subfieldPtr;
    }

    DataDefinition makeSubtable(String string) {
        return new RecordInfo(this, string);
    }

    public String getIndexPointerFieldName() {
        return this.indexName;
    }

    public String getSetOwnerFieldName() {
        return this.mainPtr;
    }

    public String getTitleFieldName() {
        return this.title;
    }

    public String getCreationDateFieldName() {
        return createName;
    }

    public String getLastModificationDateFieldName() {
        return modifyName;
    }

    public FieldDefinition getParentField() {
        if (this.papa == null) {
            return null;
        }
        return this.papa.getFieldDefinition(this.subfield);
    }

    public String getSetMemberFieldName() {
        return this.setField;
    }

    public void checkFieldNames(Dictionary dictionary) {
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!(k instanceof String)) {
                throw new NoSuchFieldException(this, "Dictionaries passed to makumba DB operations should have String keys. Key <" + k + "> is of type " + k.getClass() + this.getName());
            }
            if (this.getFieldDefinition((String)k) == null) {
                throw new NoSuchFieldException(this, (String)k);
            }
            String string = (String)k;
        }
    }

    public String toString() {
        return this.getName();
    }
}

