/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.controller.http;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.makumba.MakumbaError;
import org.makumba.UnauthorizedException;
import org.makumba.controller.http.AllowedException;
import org.makumba.controller.http.RequestAttributes;
import org.makumba.controller.http.Responder;
import org.makumba.util.DbConnectionProvider;
import org.makumba.view.jsptaglib.MakumbaTag;

public class ControllerFilter
implements Filter {
    public static final String ORIGINAL_REQUEST = "org.makumba.originalRequest";
    static FilterConfig conf;
    private static ThreadLocal requestThreadLocal;

    public void init(FilterConfig filterConfig) {
        conf = filterConfig;
    }

    public static HttpServletRequest getRequest() {
        return (HttpServletRequest)requestThreadLocal.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        MakumbaTag.initializeThread();
        boolean bl = this.shouldFilter((HttpServletRequest)servletRequest);
        requestThreadLocal.set(servletRequest);
        DbConnectionProvider dbConnectionProvider = RequestAttributes.getConnectionProvider((HttpServletRequest)servletRequest);
        if (bl) {
            try {
                try {
                    RequestAttributes.getAttributes((HttpServletRequest)servletRequest);
                }
                catch (Throwable throwable) {
                    ControllerFilter.treatException(throwable, (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
                    dbConnectionProvider.close();
                    return;
                }
                Responder.response((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
                if (ControllerFilter.wasException((HttpServletRequest)servletRequest)) {
                    return;
                }
            }
            finally {
                dbConnectionProvider.close();
            }
        }
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        catch (AllowedException allowedException) {
        }
        catch (Throwable throwable) {
            ControllerFilter.treatException(throwable, (HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
            return;
        }
        finally {
            dbConnectionProvider.close();
        }
    }

    public boolean shouldFilter(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getRequestURI();
        if (string.startsWith("/dataDefinitions") || string.startsWith("/logic") || string.startsWith("/classes")) {
            return false;
        }
        String string2 = null;
        try {
            string2 = new URL(httpServletRequest.getRequestURL().toString()).getFile();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (string2.endsWith(".jsp") || string2.endsWith(".html")) {
            return true;
        }
        if (string2.endsWith(".jspx")) {
            return false;
        }
        File file = new File(conf.getServletContext().getRealPath(httpServletRequest.getRequestURI()));
        if (file.isDirectory()) {
            return true;
        }
        return !file.exists();
    }

    public void destroy() {
    }

    public static void treatException(Throwable throwable, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        httpServletResponse.setContentType("text/html");
        httpServletRequest.setAttribute("javax.servlet.jsp.jspException", (Object)throwable);
        if (!(httpServletRequest.getAttribute("org.makumba.exceptionTreated") != null || throwable instanceof UnauthorizedException && ControllerFilter.login(httpServletRequest, httpServletResponse))) {
            try {
                httpServletRequest.getRequestDispatcher("/servlet/org.makumba.devel.TagExceptionServlet").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            catch (ServletException servletException) {
                servletException.printStackTrace();
                throw new MakumbaError(servletException);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new MakumbaError(iOException);
            }
            finally {
                MakumbaTag.initializeThread();
            }
        }
        ControllerFilter.setWasException(httpServletRequest);
        httpServletRequest.setAttribute("org.makumba.exceptionTreated", (Object)"yes");
    }

    public static void setWasException(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute("org.makumba.wasException", (Object)"yes");
    }

    public static boolean wasException(HttpServletRequest httpServletRequest) {
        return "yes".equals(httpServletRequest.getAttribute("org.makumba.wasException"));
    }

    public static String getLoginPage(String string) {
        String string2 = conf.getServletContext().getRealPath("/");
        String string3 = "/";
        String string4 = "/login.jsp";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreElements()) {
            if (new File(string2 + "login.jsp").exists()) {
                string4 = string3 + "login.jsp";
            }
            String string5 = stringTokenizer.nextToken() + "/";
            string2 = string2 + string5;
            string3 = string3 + string5;
        }
        if (new File(string2 + "login.jsp").exists()) {
            string4 = string3 + "login.jsp";
        }
        return string4;
    }

    protected static boolean login(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = ControllerFilter.getLoginPage(httpServletRequest.getServletPath());
        if (string == null) {
            return false;
        }
        while (httpServletRequest instanceof HttpServletRequestWrapper) {
            httpServletRequest = (HttpServletRequest)((HttpServletRequestWrapper)httpServletRequest).getRequest();
        }
        httpServletRequest.setAttribute(ORIGINAL_REQUEST, (Object)httpServletRequest);
        try {
            httpServletRequest.getRequestDispatcher(string).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
        return true;
    }

    static {
        requestThreadLocal = new ThreadLocal();
    }
}

