/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.hibernate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.hibernate.cfg.Configuration;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaSystem;
import org.makumba.db.hibernate.HibernateUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MddToMapping
extends HibernateUtils {
    public static final String generatedMappingPath = "work/generated-hibernate-mappings";
    private List mddsDone = new ArrayList();
    private LinkedList mddsToDo = new LinkedList();
    Set takenColumnNames;
    Map columnNames;

    public MddToMapping(Vector vector, Configuration configuration) throws TransformerConfigurationException, SAXException {
        for (int i = 0; i < vector.size(); ++i) {
            this.generateMapping(MakumbaSystem.getDataDefinition((String)vector.elementAt(i)), configuration);
        }
        while (!this.mddsToDo.isEmpty()) {
            this.generateMapping((DataDefinition)this.mddsToDo.removeFirst(), configuration);
        }
    }

    public MddToMapping(DataDefinition dataDefinition, Configuration configuration) throws TransformerConfigurationException, SAXException {
        this.generateMapping(dataDefinition, configuration);
        while (!this.mddsToDo.isEmpty()) {
            this.generateMapping((DataDefinition)this.mddsToDo.removeFirst(), configuration);
        }
    }

    public void generateMapping(DataDefinition dataDefinition, Configuration configuration) throws TransformerConfigurationException, SAXException {
        if (this.mddsDone.contains(dataDefinition.getName())) {
            return;
        }
        this.mddsDone.add(dataDefinition.getName());
        this.takenColumnNames = new HashSet();
        this.columnNames = new HashMap();
        String string = this.arrowToDoubleUnderscore(dataDefinition.getName()) + ".hbm.xml";
        StreamResult streamResult = new StreamResult("work/generated-hibernate-mappings/" + string);
        SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
        Transformer transformer = transformerHandler.getTransformer();
        transformer.setOutputProperty("doctype-public", "-//Hibernate/Hibernate Mapping DTD 3.0//EN");
        transformer.setOutputProperty("doctype-system", "http://hibernate.sourceforge.net/hibernate-mapping-3.0.dtd");
        transformer.setOutputProperty("indent", "yes");
        transformerHandler.setResult(streamResult);
        transformerHandler.startDocument();
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", "auto-import", "", "false");
        transformerHandler.startElement("", "", "hibernate-mapping", attributesImpl);
        attributesImpl.clear();
        attributesImpl.addAttribute("", "", "name", "", this.arrowToDoubleUnderscore(dataDefinition.getName()));
        attributesImpl.addAttribute("", "", "table", "", this.dotToUnderscore(this.arrowToDoubleDot(dataDefinition.getName())) + "_");
        transformerHandler.startElement("", "", "class", attributesImpl);
        block13: for (int i = 0; i < dataDefinition.getFieldNames().size(); ++i) {
            FieldDefinition fieldDefinition = dataDefinition.getFieldDefinition(i);
            attributesImpl.clear();
            switch (fieldDefinition.getIntegerType()) {
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 15: {
                    attributesImpl.addAttribute("", "", "name", "", this.checkJavaReserved(fieldDefinition.getName()));
                    attributesImpl.addAttribute("", "", "column", "", this.columnName(fieldDefinition.getName()));
                    transformerHandler.startElement("", "", "property", attributesImpl);
                    transformerHandler.endElement("", "", "property");
                    continue block13;
                }
                case 6: {
                    attributesImpl.addAttribute("", "", "name", "", this.checkJavaReserved(fieldDefinition.getName()));
                    transformerHandler.startElement("", "", "property", attributesImpl);
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "", "name", "", this.columnName(fieldDefinition.getName()));
                    attributesImpl.addAttribute("", "", "length", "", String.valueOf(fieldDefinition.getWidth()));
                    transformerHandler.startElement("", "", "column", attributesImpl);
                    transformerHandler.endElement("", "", "column");
                    transformerHandler.endElement("", "", "property");
                    continue block13;
                }
                case 0: {
                    attributesImpl.addAttribute("", "", "name", "", this.checkJavaReserved(fieldDefinition.getName()));
                    attributesImpl.addAttribute("", "", "column", "", this.columnName(fieldDefinition.getName()));
                    attributesImpl.addAttribute("", "", "cascade", "", "all");
                    attributesImpl.addAttribute("", "", "class", "", this.arrowToDoubleUnderscore(fieldDefinition.getPointedType().getName()));
                    transformerHandler.startElement("", "", "many-to-one", attributesImpl);
                    transformerHandler.endElement("", "", "many-to-one");
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "", "name", "", "hibernate_" + fieldDefinition.getName());
                    attributesImpl.addAttribute("", "", "type", "", "org.makumba.db.hibernate.customtypes.PointerUserType");
                    attributesImpl.addAttribute("", "", "column", "", this.columnName(fieldDefinition.getName()));
                    attributesImpl.addAttribute("", "", "insert", "", "false");
                    attributesImpl.addAttribute("", "", "update", "", "false");
                    attributesImpl.addAttribute("", "", "access", "", "org.makumba.db.hibernate.propertyaccess.HibernatePrimaryKey");
                    transformerHandler.startElement("", "", "property", attributesImpl);
                    transformerHandler.endElement("", "", "property");
                    this.mddsToDo.add(fieldDefinition.getPointedType());
                    continue block13;
                }
                case 2: {
                    attributesImpl.addAttribute("", "", "name", "", this.checkJavaReserved(fieldDefinition.getName()));
                    attributesImpl.addAttribute("", "", "column", "", this.columnName(fieldDefinition.getName()));
                    attributesImpl.addAttribute("", "", "cascade", "", "all");
                    attributesImpl.addAttribute("", "", "unique", "", "true");
                    transformerHandler.startElement("", "", "many-to-one", attributesImpl);
                    transformerHandler.endElement("", "", "many-to-one");
                    this.mddsToDo.add(fieldDefinition.getPointedType());
                    continue block13;
                }
                case 3: {
                    attributesImpl.addAttribute("", "", "name", "", "primaryKey");
                    attributesImpl.addAttribute("", "", "column", "", this.columnName(fieldDefinition.getName()));
                    transformerHandler.startElement("", "", "id", attributesImpl);
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "", "class", "", "increment");
                    transformerHandler.startElement("", "", "generator", attributesImpl);
                    transformerHandler.endElement("", "", "generator");
                    transformerHandler.endElement("", "", "id");
                    continue block13;
                }
                case 8: {
                    attributesImpl.addAttribute("", "", "name", "", this.checkJavaReserved(fieldDefinition.getName()));
                    attributesImpl.addAttribute("", "", "type", "", "org.makumba.db.hibernate.customtypes.TextUserType");
                    transformerHandler.startElement("", "", "property", attributesImpl);
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "", "name", "", this.columnName(fieldDefinition.getName()));
                    attributesImpl.addAttribute("", "", "sql-type", "", "longblob");
                    transformerHandler.startElement("", "", "column", attributesImpl);
                    transformerHandler.endElement("", "", "column");
                    transformerHandler.endElement("", "", "property");
                    continue block13;
                }
                case 12: {
                    attributesImpl.addAttribute("", "", "name", "", this.checkJavaReserved(fieldDefinition.getName()));
                    attributesImpl.addAttribute("", "", "table", "", dataDefinition.getName().replaceAll("\\.", "_").replaceAll("->", "__") + "__" + fieldDefinition.getName() + "_");
                    attributesImpl.addAttribute("", "", "cascade", "", "all-delete-orphan");
                    transformerHandler.startElement("", "", "bag", attributesImpl);
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "", "column", "", this.columnName(dataDefinition.getIndexPointerFieldName()));
                    transformerHandler.startElement("", "", "key", attributesImpl);
                    transformerHandler.endElement("", "", "key");
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "", "class", "", this.arrowToDoubleUnderscore(fieldDefinition.getPointedType().getName()));
                    attributesImpl.addAttribute("", "", "formula", "", this.columnName(fieldDefinition.getPointedType().getIndexPointerFieldName()));
                    transformerHandler.startElement("", "", "many-to-many", attributesImpl);
                    transformerHandler.endElement("", "", "many-to-many");
                    transformerHandler.endElement("", "", "bag");
                    this.mddsToDo.add(fieldDefinition.getPointedType());
                    continue block13;
                }
                case 13: 
                case 16: 
                case 17: {
                    attributesImpl.addAttribute("", "", "name", "", this.checkJavaReserved(fieldDefinition.getName()));
                    attributesImpl.addAttribute("", "", "inverse", "", "true");
                    attributesImpl.addAttribute("", "", "cascade", "", "none");
                    transformerHandler.startElement("", "", "bag", attributesImpl);
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "", "column", "", this.columnName(dataDefinition.getIndexPointerFieldName()));
                    transformerHandler.startElement("", "", "key", attributesImpl);
                    transformerHandler.endElement("", "", "key");
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "", "class", "", this.arrowToDoubleUnderscore(fieldDefinition.getPointedType().getName()));
                    transformerHandler.startElement("", "", "one-to-many", attributesImpl);
                    transformerHandler.endElement("", "", "one-to-many");
                    transformerHandler.endElement("", "", "bag");
                    this.mddsToDo.add(fieldDefinition.getSubtable());
                    continue block13;
                }
                case 1: {
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "", "name", "", this.checkJavaReserved(fieldDefinition.getName()));
                    attributesImpl.addAttribute("", "", "column", "", this.columnName(fieldDefinition.getName()));
                    attributesImpl.addAttribute("", "", "class", "", this.arrowToDoubleUnderscore(fieldDefinition.getPointedType().getName()));
                    transformerHandler.startElement("", "", "many-to-one", attributesImpl);
                    transformerHandler.endElement("", "", "many-to-one");
                    continue block13;
                }
                default: {
                    try {
                        throw new Exception("Unmapped type: " + fieldDefinition.getName() + "-" + fieldDefinition.getType());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        transformerHandler.endElement("", "", "class");
        transformerHandler.endElement("", "", "hibernate-mapping");
        transformerHandler.endDocument();
        configuration.addResource(string);
    }

    private String columnName(String string) {
        String string2 = (String)this.columnNames.get(string);
        if (string2 != null) {
            return string2;
        }
        string2 = string + "_";
        while (this.takenColumnNames.contains(string2.toLowerCase())) {
            string2 = string2 + "_";
        }
        this.takenColumnNames.add(string2.toLowerCase());
        this.columnNames.put(string, string2);
        return this.arrowToDoubleUnderscore(string2);
    }
}

