/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.makumba.DBError;
import org.makumba.db.DBConnection;
import org.makumba.db.sql.Database;
import org.makumba.db.sql.SQLDBConnection;

public class MsSqlDatabase
extends Database {
    public MsSqlDatabase(Properties properties) {
        super(MsSqlDatabase.addProperties(properties));
    }

    private static Properties addProperties(Properties properties) {
        properties.put("sql.DatabaseName", properties.getProperty("#database"));
        properties.put("sql.SelectMethod", "Cursor");
        return properties;
    }

    protected String getJdbcUrl(Properties properties) {
        super.getJdbcUrl(properties);
        String string = "jdbc:microsoft:sqlserver://";
        String string2 = properties.getProperty("#host");
        string2 = string2.replaceAll("!", "\\\\");
        string = string + string2;
        return string;
    }

    protected DBConnection makeDBConnection() {
        SQLDBConnection sQLDBConnection = (SQLDBConnection)super.makeDBConnection();
        try {
            Statement statement = sQLDBConnection.createStatement();
            statement.execute("SET QUOTED_IDENTIFIER OFF");
        }
        catch (SQLException sQLException) {
            MsSqlDatabase.logException(sQLException);
            throw new DBError(sQLException);
        }
        return sQLDBConnection;
    }

    public boolean supportsLimitInQuery() {
        return false;
    }
}

