/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.util;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.makumba.util.NameValue;
import org.makumba.util.NamedResourceFactory;
import org.makumba.util.RuntimeWrappedException;
import org.makumba.util.SoftNamedResources;

public class NamedResources
implements Serializable {
    private static final long serialVersionUID = 1L;
    static boolean soft_static_caches;
    NamedResourceFactory f;
    String name;
    Map values = new HashMap();
    int hits;
    int misses;
    static List staticCaches;
    static Vector allCaches;

    public static void cleanup() {
        int n;
        for (n = 0; n < staticCaches.size(); ++n) {
            ((NamedResources)staticCaches.get(n)).close();
        }
        staticCaches.clear();
        for (n = 0; n < allCaches.size(); ++n) {
            ((WeakReference)allCaches.elementAt(n)).clear();
        }
        allCaches.clear();
    }

    public static synchronized int makeStaticCache(String string, NamedResourceFactory namedResourceFactory, boolean bl) {
        staticCaches.add(bl ? new SoftNamedResources(string, namedResourceFactory) : new NamedResources(string, namedResourceFactory));
        return staticCaches.size() - 1;
    }

    public static synchronized int makeStaticCache(String string, NamedResourceFactory namedResourceFactory) {
        return NamedResources.makeStaticCache(string, namedResourceFactory, soft_static_caches);
    }

    public static NamedResources getStaticCache(int n) {
        return (NamedResources)staticCaches.get(n);
    }

    public static Map getCacheInfo() {
        HashMap<String, int[]> hashMap = new HashMap<String, int[]>();
        for (int i = 0; i < allCaches.size(); ++i) {
            NamedResources namedResources = (NamedResources)((WeakReference)allCaches.elementAt(i)).get();
            if (namedResources == null) continue;
            int[] nArray = (int[])hashMap.get(namedResources.getName());
            if (nArray == null) {
                nArray = new int[3];
                hashMap.put(namedResources.getName(), nArray);
            }
            nArray[0] = nArray[0] + namedResources.size();
            nArray[1] = nArray[1] + namedResources.hits;
            nArray[2] = nArray[2] + namedResources.misses;
        }
        return hashMap;
    }

    public NamedResources(String string, NamedResourceFactory namedResourceFactory) {
        this.name = string;
        this.f = namedResourceFactory;
        allCaches.addElement(new WeakReference<NamedResources>(this));
    }

    public boolean knowResource(Object object) {
        try {
            return this.values.get(this.f.getHashObject(object)) != null;
        }
        catch (Throwable throwable) {
            throw new RuntimeWrappedException(throwable);
        }
    }

    public Object getSupplementary() {
        return this.f.supplementary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResource(Object object) {
        NameValue nameValue = null;
        NamedResources namedResources = this;
        synchronized (namedResources) {
            Object object2 = null;
            try {
                object2 = this.f.getHashObject(object);
            }
            catch (Throwable throwable) {
                throw new RuntimeWrappedException(throwable);
            }
            nameValue = this.getNameValue(object, object2);
        }
        return nameValue.getResource();
    }

    protected NameValue getNameValue(Object object, Object object2) {
        NameValue nameValue = (NameValue)this.values.get(object2);
        if (nameValue == null) {
            ++this.misses;
            nameValue = new NameValue(object, object2, this.f);
            this.values.put(object2, nameValue);
        } else {
            ++this.hits;
        }
        return nameValue;
    }

    public int size() {
        return this.values.size();
    }

    public String getName() {
        return this.name;
    }

    public void close() {
        Iterator iterator = this.values.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = this.values.get(iterator.next());
            if (object instanceof Reference && (object = ((Reference)object).get()) == null || !(((NameValue)object).returner instanceof NameValue)) continue;
            Object object2 = ((NameValue)object).getResource();
            Method method = null;
            if (object2 == null) continue;
            try {
                method = object2.getClass().getMethod("close", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
            try {
                method.invoke(object2, (Object[])null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.values.clear();
    }

    static {
        String string = null;
        try {
            string = System.getProperty("makumba.soft-static-caches");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string != null) {
            string = string.trim();
        }
        soft_static_caches = "true".equals(string);
        staticCaches = new ArrayList();
        allCaches = new Vector();
    }
}

