/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.view.html;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Dictionary;
import java.util.Hashtable;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.view.ComposedQuery;
import org.makumba.view.FieldFormatter;
import org.makumba.view.RecordFormatter;
import org.makumba.view.dateFormatter;
import org.makumba.view.html.FieldViewer;
import org.makumba.view.html.charViewer;
import org.makumba.view.html.textViewer;
import org.makumba.view.intEnumFormatter;
import org.makumba.view.ptrFormatter;
import org.makumba.view.timestampFormatter;

public class RecordViewer
extends RecordFormatter {
    public RecordViewer(ComposedQuery composedQuery) {
        super(composedQuery);
    }

    public RecordViewer(DataDefinition dataDefinition, Hashtable hashtable) {
        super(dataDefinition, hashtable);
    }

    protected String applyParameters(FieldFormatter fieldFormatter, Dictionary dictionary, String string) {
        if (dictionary.get("urlEncode") != null) {
            try {
                return URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        return string;
    }

    protected void initFormatters() {
        this.formatterArray = new FieldFormatter[this.dd.getFieldNames().size()];
        block8: for (int i = 0; i < this.dd.getFieldNames().size(); ++i) {
            FieldDefinition fieldDefinition = this.dd.getFieldDefinition(i);
            switch (fieldDefinition.getIntegerType()) {
                case 6: {
                    this.formatterArray[i] = charViewer.getInstance();
                    continue block8;
                }
                case 8: {
                    this.formatterArray[i] = textViewer.getInstance();
                    continue block8;
                }
                case 9: {
                    this.formatterArray[i] = dateFormatter.getInstance();
                    continue block8;
                }
                case 10: 
                case 11: {
                    this.formatterArray[i] = timestampFormatter.getInstance();
                    continue block8;
                }
                case 5: {
                    this.formatterArray[i] = intEnumFormatter.getInstance();
                    continue block8;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.formatterArray[i] = ptrFormatter.getInstance();
                    continue block8;
                }
                default: {
                    this.formatterArray[i] = FieldViewer.getInstance();
                }
            }
        }
    }
}

