/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.controller.jsp;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.makumba.AttributeNotFoundException;
import org.makumba.Attributes;
import org.makumba.LogicException;
import org.makumba.controller.http.RequestAttributes;

public class PageAttributes
implements Attributes {
    PageContext pageContext;

    public static PageAttributes getAttributes(PageContext pageContext) {
        if (pageContext.getAttribute("makumba.attributes") == null) {
            pageContext.setAttribute("makumba.attributes", (Object)new PageAttributes(pageContext));
        }
        return (PageAttributes)pageContext.getAttribute("makumba.attributes");
    }

    PageAttributes(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public static void setAttribute(PageContext pageContext, String string, Object object) {
        if (object != null) {
            pageContext.setAttribute(string, object);
            pageContext.removeAttribute(string + "_null");
        } else {
            pageContext.removeAttribute(string);
            pageContext.setAttribute(string + "_null", (Object)"null");
        }
    }

    public Object setAttribute(String string, Object object) throws LogicException {
        return RequestAttributes.getAttributes((HttpServletRequest)this.pageContext.getRequest()).setAttribute(string, object);
    }

    public void removeAttribute(String string) throws LogicException {
        RequestAttributes.getAttributes((HttpServletRequest)this.pageContext.getRequest()).removeAttribute(string);
    }

    public boolean hasAttribute(String string) {
        try {
            return RequestAttributes.getAttributes((HttpServletRequest)this.pageContext.getRequest()).hasAttribute(string) || this.checkPageForAttribute(string) != RequestAttributes.notFound;
        }
        catch (LogicException logicException) {
            return false;
        }
    }

    public String toString() {
        String[] stringArray = new String[]{"Session", "Application", "Request", "Page"};
        int[] nArray = new int[]{3, 4, 2, 1};
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            string = string + stringArray[i] + ": {";
            Enumeration enumeration = this.pageContext.getAttributeNamesInScope(nArray[i]);
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                string = string + string2 + "=" + this.pageContext.getAttribute(string2, nArray[i]);
                if (!enumeration.hasMoreElements()) continue;
                string = string + ", ";
            }
            string = string + "}\n";
        }
        return string;
    }

    public Object getAttribute(String string) throws LogicException {
        RequestAttributes requestAttributes = RequestAttributes.getAttributes((HttpServletRequest)this.pageContext.getRequest());
        Object object = requestAttributes.checkSessionForAttribute(string);
        if (object != RequestAttributes.notFound) {
            return object;
        }
        object = requestAttributes.checkServletLoginForAttribute(string);
        if (object != RequestAttributes.notFound) {
            return object;
        }
        object = this.checkPageForAttribute(string);
        if (object != RequestAttributes.notFound) {
            return object;
        }
        object = requestAttributes.checkLogicForAttribute(string);
        if (object != RequestAttributes.notFound) {
            return object;
        }
        object = requestAttributes.checkParameterForAttribute(string);
        if (object != RequestAttributes.notFound) {
            return object;
        }
        throw new AttributeNotFoundException(string);
    }

    public Object checkPageForAttribute(String string) {
        String string2 = string + "_null";
        Object object = this.pageContext.getAttribute(string);
        if (object != null) {
            return object;
        }
        if (this.pageContext.getAttribute(string2) != null) {
            return null;
        }
        return RequestAttributes.notFound;
    }
}

