/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.makumba.DBError;
import org.makumba.DataDefinition;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaError;
import org.makumba.MakumbaSystem;
import org.makumba.NoSuchFieldException;
import org.makumba.OQLAnalyzer;
import org.makumba.db.DBConnection;
import org.makumba.db.DBConnectionWrapper;
import org.makumba.db.Database;
import org.makumba.db.sql.ParameterAssigner;
import org.makumba.db.sql.SQLDBConnection;
import org.makumba.db.sql.TableManager;
import org.makumba.db.sql.oql.QueryAST;
import org.makumba.util.ArrayMap;

public class Query
implements org.makumba.db.Query {
    String query;
    TableManager resultHandler;
    String command;
    ParameterAssigner assigner;
    String limitSyntax;
    boolean offsetFirst;
    boolean supportsLimitInQuery;
    String insertIn;
    TableManager insertHandler;

    public String getCommand() {
        return this.command;
    }

    public Query(Database database, String string, String string2) {
        this(database, MakumbaSystem.getOQLAnalyzer(string), string2);
    }

    public Query(Database database, OQLAnalyzer oQLAnalyzer, String string) {
        this.command = ((QueryAST)oQLAnalyzer).writeInSQLQuery(database);
        this.resultHandler = (TableManager)database.makePseudoTable(oQLAnalyzer.getProjectionType());
        this.assigner = new ParameterAssigner(database, oQLAnalyzer);
        this.limitSyntax = ((org.makumba.db.sql.Database)database).getLimitSyntax();
        this.offsetFirst = ((org.makumba.db.sql.Database)database).isLimitOffsetFirst();
        this.supportsLimitInQuery = ((org.makumba.db.sql.Database)database).supportsLimitInQuery();
        this.insertIn = string;
        if (string != null && string.length() > 0) {
            this.analyzeInsertIn(oQLAnalyzer.getProjectionType(), database);
        }
    }

    public Vector execute(Object[] objectArray, DBConnection dBConnection, int n, int n2) {
        String string = this.command;
        if (this.supportsLimitInQuery) {
            string = string + " " + this.limitSyntax;
        }
        PreparedStatement preparedStatement = ((SQLDBConnection)dBConnection).getPreparedStatement(string);
        try {
            String string2 = this.assigner.assignParameters(preparedStatement, objectArray);
            if (this.supportsLimitInQuery) {
                int n3;
                int n4 = n3 = n2 == -1 ? Integer.MAX_VALUE : n2;
                if (this.offsetFirst) {
                    preparedStatement.setInt(this.assigner.tree.parameterNumber() + 1, n);
                    preparedStatement.setInt(this.assigner.tree.parameterNumber() + 2, n3);
                } else {
                    preparedStatement.setInt(this.assigner.tree.parameterNumber() + 1, n3);
                    preparedStatement.setInt(this.assigner.tree.parameterNumber() + 2, n);
                }
            }
            if (string2 != null) {
                throw new InvalidValueException("Errors while trying to assign arguments to query:\n" + string + "\n" + string2);
            }
            MakumbaSystem.getMakumbaLogger("db.query.execution").fine("" + preparedStatement);
            Date date = new Date();
            ResultSet resultSet = null;
            try {
                resultSet = preparedStatement.executeQuery();
            }
            catch (SQLException sQLException) {
                org.makumba.db.sql.Database.logException(sQLException, dBConnection);
                throw new DBError(sQLException, string);
            }
            long l = new Date().getTime() - date.getTime();
            MakumbaSystem.getMakumbaLogger("db.query.performance").fine("" + l + " ms " + string);
            return this.goThru(resultSet, this.resultHandler);
        }
        catch (SQLException sQLException) {
            throw new DBError(sQLException);
        }
    }

    Vector goThru(ResultSet resultSet, TableManager tableManager) {
        int n = tableManager.keyIndex.size();
        Vector<ArrayMap> vector = new Vector<ArrayMap>(100, 100);
        try {
            while (resultSet.next()) {
                Object[] objectArray = new Object[n];
                tableManager.fillResult(resultSet, objectArray);
                vector.addElement(new ArrayMap(tableManager.keyIndex, objectArray));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new DBError(sQLException, tableManager.getDataDefinition().getName());
        }
        return vector;
    }

    void analyzeInsertIn(DataDefinition dataDefinition, Database database) {
        DataDefinition dataDefinition2 = MakumbaSystem.getDataDefinition(this.insertIn);
        Iterator iterator = dataDefinition.getFieldNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (dataDefinition2.getFieldDefinition(string) != null) continue;
            throw new NoSuchFieldException(dataDefinition2, string);
        }
        this.insertHandler = (TableManager)database.getTable(dataDefinition2);
    }

    public int insert(Object[] objectArray, DBConnection dBConnection) {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.resultHandler.getDataDefinition().getFieldNames().iterator();
        while (object.hasNext()) {
            stringBuffer.append(string);
            string = ",";
            stringBuffer.append(this.insertHandler.getFieldDBName((String)object.next()));
        }
        object = "temp_" + (int)(Math.random() * 10000.0);
        String string2 = "INSERT INTO " + (String)object + " ( " + stringBuffer + ") " + this.command;
        try {
            SQLDBConnection sQLDBConnection = (SQLDBConnection)((DBConnectionWrapper)dBConnection).getWrapped();
            this.resultHandler.create(sQLDBConnection, (String)object, true);
            PreparedStatement preparedStatement = sQLDBConnection.getPreparedStatement(string2);
            String string3 = this.assigner.assignParameters(preparedStatement, objectArray);
            if (string3 != null) {
                throw new InvalidValueException("Errors while trying to assign arguments to query:\n" + string2 + "\n" + string3);
            }
            int n = preparedStatement.executeUpdate();
            string2 = "INSERT INTO " + this.insertHandler.getDBName() + " (" + stringBuffer + ") SELECT " + stringBuffer + " FROM " + (String)object;
            preparedStatement = sQLDBConnection.getPreparedStatement(string2);
            int n2 = preparedStatement.executeUpdate();
            if (n2 != n) {
                throw new MakumbaError("inserted in temp " + n + " inserted in final " + n2);
            }
            Statement statement = sQLDBConnection.createStatement();
            statement.execute("DROP TABLE " + (String)object);
            return n;
        }
        catch (SQLException sQLException) {
            throw new DBError(sQLException);
        }
    }
}

