/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLConnection;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.makumba.LogicNotFoundException;
import org.makumba.MakumbaSystem;
import org.makumba.controller.Logic;
import org.makumba.controller.http.ControllerFilter;
import org.makumba.devel.JspxJspAnalyzer;
import org.makumba.devel.LineViewer;
import org.makumba.util.ClassResource;
import org.makumba.util.JspParseData;
import org.makumba.util.SourceSyntaxPoints;
import org.makumba.util.SyntaxPoint;
import org.makumba.view.jsptaglib.TomcatJsp;

public class jspViewer
extends LineViewer {
    private static final String PROPERTIES_FILE_NAME = "jspSyntax.properties";
    private static Properties defaultTaglibProperties = new Properties();
    private static Properties taglibgSytleProperties;
    private static Properties SystemStyleProperties;
    private static final String DEFAULT_JSPSYSTEMTAG_STYLE;
    private static final String DEFAULT_JSPSCRIPLET_STYLE = "background:gold;color:green; border:red thin; font-weight: bold;";
    private static final String DEFAULT_JSPCOMMENT_STYLE = "color:gray;";
    private static final String DEFAULT_JSPEXPRESSIONLANGUAGE_STYLE = "font-style:italic;";
    private static Set syntaxKeys;
    boolean hasLogic;
    private SyntaxPoint[] sourceSyntaxPoints;
    private SourceSyntaxPoints syntaxPoints;
    private boolean hideComments = false;
    private boolean hideHTML = false;
    private boolean hideJSTLCore = false;
    private boolean hideJSTLFormat = false;
    private boolean hideMakumba = false;
    private boolean hideJava = false;

    private static void initProperties() {
        try {
            URLConnection uRLConnection = ClassResource.get(PROPERTIES_FILE_NAME).openConnection();
            Properties properties = new Properties();
            properties.load(uRLConnection.getInputStream());
            SystemStyleProperties.put("ExpressionLanguage", properties.getProperty("ExpressionLanguage", DEFAULT_JSPEXPRESSIONLANGUAGE_STYLE));
            SystemStyleProperties.put("JspScriptlet", properties.getProperty("JspScriptlet", DEFAULT_JSPSCRIPLET_STYLE));
            SystemStyleProperties.put("JspComment", properties.getProperty("JspComment", DEFAULT_JSPCOMMENT_STYLE));
            SystemStyleProperties.put("JSPSystemTag", properties.getProperty("JSPSystemTag", properties.getProperty("jsp", DEFAULT_JSPSYSTEMTAG_STYLE)));
            properties.remove("JspScriptlet");
            properties.remove("JspComment");
            properties.remove("JSPSystemTag");
            properties.remove("ExpressionLanguage");
            taglibgSytleProperties = properties;
        }
        catch (Throwable throwable) {
            MakumbaSystem.getMakumbaLogger("org.makumba.devel.sourceViewer").fine("JSP syntax highlighting properties file 'jspSyntax.properties' not found! Using default values.");
            SystemStyleProperties.put("ExpressionLanguage", DEFAULT_JSPEXPRESSIONLANGUAGE_STYLE);
            SystemStyleProperties.put("JspScriptlet", DEFAULT_JSPSCRIPLET_STYLE);
            SystemStyleProperties.put("JspComment", DEFAULT_JSPCOMMENT_STYLE);
            SystemStyleProperties.put("JSPSystemTag", DEFAULT_JSPSYSTEMTAG_STYLE);
            taglibgSytleProperties = defaultTaglibProperties;
        }
    }

    private int extraLength() {
        return 1;
    }

    public jspViewer(HttpServletRequest httpServletRequest, HttpServlet httpServlet) throws Exception {
        super(true, httpServletRequest, httpServlet);
        this.setSearchLevels(true, false, false, true);
        this.servlet = httpServlet;
        this.hideComments = Boolean.valueOf(String.valueOf(httpServletRequest.getParameter("hideComments")));
        this.hideHTML = Boolean.valueOf(String.valueOf(httpServletRequest.getParameter("hideHTML")));
        this.hideJSTLCore = Boolean.valueOf(String.valueOf(httpServletRequest.getParameter("hideJSTLCore")));
        this.hideJSTLFormat = Boolean.valueOf(String.valueOf(httpServletRequest.getParameter("hideJSTLFormat")));
        this.hideMakumba = Boolean.valueOf(String.valueOf(httpServletRequest.getParameter("hideMakumba")));
        this.hideJava = Boolean.valueOf(String.valueOf(httpServletRequest.getParameter("hideJava")));
        String string = TomcatJsp.getJspURI(httpServletRequest);
        string = string.substring(0, string.length() - 1);
        JspParseData jspParseData = JspParseData.getParseData(httpServlet.getServletContext().getRealPath("/"), string, JspxJspAnalyzer.getInstance());
        jspParseData.getAnalysisResult(null);
        this.syntaxPoints = jspParseData.getSyntaxPoints();
        this.sourceSyntaxPoints = jspParseData.getSyntaxPoints().getSyntaxPoints();
        this.contextPath = httpServletRequest.getContextPath();
        String string2 = httpServletRequest.getServletPath();
        this.virtualPath = string2.substring(0, string2.length() - this.extraLength());
        this.jspSourceViewExtension = string2.substring(string2.length() - this.extraLength());
        this.realPath = httpServlet.getServletConfig().getServletContext().getRealPath(this.virtualPath);
        this.reader = new FileReader(this.realPath);
        string2 = string2.substring(0, string2.indexOf(".")) + ".jsp";
        this.logicPath = this.contextPath + "/logic" + string2;
        this.hasLogic = !(Logic.getLogic(string2) instanceof LogicNotFoundException);
    }

    public void intro(PrintWriter printWriter) throws IOException {
        printWriter.print("<td>\n<table align=\"right\" cellpading=\"5\" cellspacing=\"5\">\n<tr>\n<td align=\"right\"><a href=\"" + this.contextPath + this.virtualPath + "\"><font color=\"darkblue\">execute</font></a>&nbsp;&nbsp;&nbsp;</td>\n" + "<td align=\"right\" bgcolor=\"darkblue\"><font color=\"lightblue\">source</font>&nbsp;&nbsp;&nbsp;</td>\n" + "<td align=\"right\"><a href=\"" + this.logicPath + "\"><font color=\"darkblue\">business logic" + (this.hasLogic ? "" : " (none)") + "</font></a></td>\n");
        String string = ControllerFilter.getLoginPage(this.virtualPath);
        if (string != null) {
            printWriter.print("<td align=\"right\">&nbsp;&nbsp;&nbsp;<a href=\"" + this.contextPath + string + "x\"><font color=\"darkblue\">login page</font></a></td>\n");
        }
        printWriter.print("</tr>\n</table>\n</td>\n</tr>\n<tr>\n<td align=\"right\"><form method=\"get\" action>\nHide: <input type=\"checkbox\" name=\"hideComments\" value=\"true\"" + (this.hideComments ? " checked=\"checked\"" : "") + ">Comments  \n" + "<input type=\"checkbox\" name=\"hideHTML\" value=\"true\"" + (this.hideHTML ? " checked=\"checked\"" : "") + ">HML  \n" + "<input type=\"checkbox\" name=\"hideJava\" value=\"true\"" + (this.hideJava ? " checked=\"checked\"" : "") + ">Java  \n" + "<input type=\"checkbox\" name=\"hideJSTLCore\" value=\"true\"" + (this.hideJSTLCore ? " checked=\"checked\"" : "") + ">JSTL Core  \n" + "<input type=\"checkbox\" name=\"hideJSTLFormat\" value=\"true\"" + (this.hideJSTLFormat ? " checked=\"checked\"" : "") + ">JSTL Format  \n" + "<input type=\"checkbox\" name=\"hideMakumba\" value=\"true\"" + (this.hideMakumba ? " checked=\"checked\"" : "") + ">Makumba  \n" + "<input type=\"submit\" value=\"apply\"> \n" + "</form>\n" + "</td>\n" + "</tr>\n");
    }

    public void parseText(PrintWriter printWriter) throws IOException {
        Date date = new Date();
        Object[] objectArray = syntaxKeys.toArray();
        this.printPageBegin(printWriter);
        SyntaxPoint syntaxPoint = null;
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.sourceSyntaxPoints.length; ++i) {
            SyntaxPoint syntaxPoint2 = this.sourceSyntaxPoints[i];
            String string = syntaxPoint2.getType();
            int n2 = syntaxPoint2.getLine();
            String string2 = this.syntaxPoints.getLineText(n2);
            int n3 = string2.length();
            if (syntaxPoint2.getOriginalColumn(n3) > this.syntaxPoints.getLineText(n2).length() + 1) {
                MakumbaSystem.getMakumbaLogger("org.makumba.devel.sourceViewer").finest("skipped syntax Point due to wrong offset: " + (syntaxPoint2.isBegin() ? "begin " : "end ") + syntaxPoint2.getType() + " " + syntaxPoint2.getLine() + ":" + syntaxPoint2.getColumn() + ":; linelength is: " + this.syntaxPoints.getLineText(n2).length());
                continue;
            }
            if (string.equals("TextLine") && syntaxPoint2.isBegin()) {
                syntaxPoint = syntaxPoint2;
                continue;
            }
            if (string.equals("TextLine") && !syntaxPoint2.isBegin()) {
                if (syntaxPoint2.getOriginalColumn(n3) > 1 && (!this.hideHTML || n > 0) && bl) {
                    stringBuffer.append(this.parseLine(this.htmlEscape(string2.substring(syntaxPoint.getOriginalColumn(n3) - 1, syntaxPoint2.getOriginalColumn(n3) - 1))));
                }
                if ((!stringBuffer.toString().trim().equals("") || n < 1 && !this.hideHTML || n > 0 && bl) && this.printLineNumbers) {
                    printWriter.print("\n<a style=\"font-weight: normal; \" name=\"" + n2 + "\" href=\"#" + n2 + "\" class=\"lineNo\">" + n2 + ":\t</a>");
                }
                printWriter.print(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                syntaxPoint = syntaxPoint2;
                continue;
            }
            if (!this.isTagToHighlight(string)) continue;
            if (syntaxPoint2.isBegin()) {
                if (++n > 1) {
                    bl2 = bl;
                    if (bl2) {
                        stringBuffer.append(this.parseLine(this.htmlEscape(string2.substring(syntaxPoint.getOriginalColumn(n3) - 1, syntaxPoint2.getOriginalColumn(n3) - 1))));
                    }
                } else if (syntaxPoint2.getOriginalColumn(n3) > 1 && !this.hideHTML && bl) {
                    stringBuffer.append(this.parseLine(this.htmlEscape(string2.substring(syntaxPoint.getOriginalColumn(n3) - 1, syntaxPoint2.getOriginalColumn(n3) - 1))));
                }
                String string3 = string2.substring(syntaxPoint2.getOriginalColumn(n3));
                if (string.equals("JspScriptlet")) {
                    if (this.hideJava) {
                        bl = false;
                    } else {
                        stringBuffer.append("<span style=\"" + SystemStyleProperties.get("JspScriptlet") + "; \">");
                    }
                } else if (string.equals("JspComment")) {
                    if (this.hideComments) {
                        bl = false;
                    } else {
                        stringBuffer.append("<span style=\"" + SystemStyleProperties.get("JspComment") + "; \">");
                    }
                } else if (string.equals("JSPSystemTag")) {
                    stringBuffer.append("<span style=\"" + SystemStyleProperties.get("JSPSystemTag") + "; \">");
                } else if (string.equals("ExpressionLanguage")) {
                    stringBuffer.append("<span style=\"" + SystemStyleProperties.get("ExpressionLanguage") + "; \">");
                } else {
                    if ((string3.startsWith("mak") || string3.startsWith("/mak")) && this.hideMakumba || (string3.startsWith("c") || string3.startsWith("/c")) && this.hideJSTLCore || (string3.startsWith("fmt") || string3.startsWith("/fmt")) && this.hideJSTLFormat) {
                        bl = false;
                    }
                    if (bl) {
                        for (int j = 0; j < objectArray.length; ++j) {
                            if (!string3.startsWith(String.valueOf(objectArray[j])) && !string3.startsWith(String.valueOf("/" + objectArray[j]))) continue;
                            stringBuffer.append("<span style=\"" + taglibgSytleProperties.get(objectArray[j]) + "; \">");
                            break;
                        }
                    }
                }
                syntaxPoint = syntaxPoint2;
                continue;
            }
            if (bl) {
                stringBuffer.append(this.parseLine(this.htmlEscape(string2.substring(syntaxPoint.getOriginalColumn(n3) - 1, syntaxPoint2.getOriginalColumn(n3) - 1))));
                stringBuffer.append("</span>");
            }
            bl = n > 1 ? bl2 : true;
            syntaxPoint = syntaxPoint2;
            --n;
        }
        this.printPageEnd(printWriter);
        double d = new Date().getTime() - date.getTime();
        MakumbaSystem.getMakumbaLogger("org.makumba.devel.sourceViewer").finer("Sourcecode viewer took :" + d / 1000.0 + " seconds");
    }

    private boolean isTagToHighlight(String string) {
        return string.equals("JspTagBegin") || string.equals("JspTagEnd") || string.equals("JspTagSimple") || string.equals("ExpressionLanguage") || this.isSystemtag(string);
    }

    private boolean isSystemtag(String string) {
        return string.equals("JspComment") || string.equals("JspScriptlet") || string.equals("JSPSystemTag");
    }

    static {
        defaultTaglibProperties.put("mak", "background:#eecccc; color:green; border:red thin; font-weight: bold; ");
        defaultTaglibProperties.put("jsp", "background:lightcyan; color:green; border:red thin; font-weight: bold; ");
        defaultTaglibProperties.put("fmt", "background::chartreuse; color:green; border:red thin; font-weight: bold; ");
        defaultTaglibProperties.put("c", "background:lightblue; color:green; border:red thin; font-weight: bold; ");
        taglibgSytleProperties = new Properties();
        SystemStyleProperties = new Properties();
        DEFAULT_JSPSYSTEMTAG_STYLE = defaultTaglibProperties.getProperty("jsp");
        jspViewer.initProperties();
        syntaxKeys = taglibgSytleProperties.keySet();
    }
}

