/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.util;

import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Stack;
import java.util.Vector;
import org.makumba.MakumbaSystem;
import org.makumba.util.StalePreventionThread;

public abstract class ResourcePool {
    Stack stack = new Stack();
    Stack timeStack = new Stack();
    Vector all = new Vector();
    WeakReference poolRef = new WeakReference<ResourcePool>(this);
    long sleeping;
    long stale;
    Thread stalePreventionThread;

    public abstract Object create() throws Exception;

    Object createAndCount() throws Exception {
        Object object = this.create();
        this.all.addElement(object);
        MakumbaSystem.getMakumbaLogger("util.pool").fine("pool size: " + this.all.size());
        return object;
    }

    public void init(int n) throws Exception {
        while (n > 0) {
            this.put(this.createAndCount());
            --n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() throws Exception {
        Stack stack = this.stack;
        synchronized (stack) {
            if (this.stack.isEmpty()) {
                return this.createAndCount();
            }
            this.timeStack.pop();
            MakumbaSystem.getMakumbaLogger("util.pool.member").fine("pool members: " + this.timeStack.size());
            return this.stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object) {
        Stack stack = this.stack;
        synchronized (stack) {
            this.stack.push(object);
            this.timeStack.push(new Date());
            MakumbaSystem.getMakumbaLogger("util.pool.member").fine("pool members: " + this.timeStack.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.poolRef.clear();
        Stack stack = this.stack;
        synchronized (stack) {
            if (this.stalePreventionThread != null) {
                this.stalePreventionThread.interrupt();
            }
            this.stack.clear();
            this.timeStack.clear();
            for (int i = 0; i < this.all.size(); ++i) {
                this.close(this.all.elementAt(i));
            }
            this.all.clear();
        }
    }

    protected void finalize() {
        this.close();
    }

    public void renew(Object object) {
    }

    public void close(Object object) {
    }

    public void startStalePreventionThread(long l, long l2) {
        this.sleeping = l;
        this.stale = l2;
        this.stalePreventionThread = new StalePreventionThread(this.poolRef, this.sleeping);
        this.stalePreventionThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renewAll() {
        Stack stack = this.stack;
        synchronized (stack) {
            for (int i = 0; i < this.timeStack.size(); ++i) {
                if (((Date)this.timeStack.elementAt(i)).getTime() + this.stale >= new Date().getTime() + this.sleeping) continue;
                MakumbaSystem.getMakumbaLogger("util.pool").fine("renewing resource " + this.stack.elementAt(i) + " not used since " + this.timeStack.elementAt(i));
                this.renew(this.stack.elementAt(i));
                this.timeStack.setElementAt(new Date(), i);
            }
        }
    }

    public int getSize() {
        return this.stack.size();
    }
}

