// /////////////////////////////
//  Makumba, Makumba tag library
//  Copyright (C) 2000-2003 http://www.makumba.org
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//  -------------
//  $Id: realEditor.java,v 2.3 2005/06/25 13:16:39 rosso_nero Exp $
//  $Name: makumba-0_5_16 $
/////////////////////////////////////

package org.makumba.controller.html;

import org.makumba.view.FieldFormatter;
import org.makumba.view.InvalidValueException;
import org.makumba.view.RecordFormatter;

public class realEditor extends intEditor {

	private static final class SingletonHolder {
		static final FieldEditor singleton = new realEditor();
	}

	private realEditor() {}

	public static FieldFormatter getInstance() {
		return SingletonHolder.singleton;
	}

	public Object readFrom(RecordFormatter rf, int fieldIndex, org.makumba.controller.http.HttpParameters par,
			String suffix) {
		Object o = par.getParameter(getInputName(rf, fieldIndex, suffix));

		if (o instanceof java.util.Vector) {
			throw new InvalidValueException(rf.expr[fieldIndex],
					"multiple value not accepted for real: " + o);
		}
		return toReal(rf, fieldIndex, o);
	}

}
