/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.abstr;

import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.DataDefinitionParseError;
import org.makumba.MakumbaSystem;
import org.makumba.abstr.FieldInfo;
import org.makumba.abstr.RecordParser;

public class FieldCursor {
    String toParse;
    int index = 0;
    RecordParser rp;

    public FieldCursor(RecordParser recordParser, String string) {
        this.rp = recordParser;
        this.toParse = string;
        this.index = string.indexOf(61) + 1;
    }

    public DataDefinitionParseError fail(String string) {
        return new DataDefinitionParseError(this.rp.dd.getName(), string, this.toParse, this.index);
    }

    void skipBlank() {
        try {
            while (Character.isWhitespace(this.toParse.charAt(this.index))) {
                ++this.index;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public boolean lookup(String string) {
        this.skipBlank();
        int n = string.length() + this.index;
        try {
            if (this.toParse.substring(this.index, n).equals(string)) {
                this.index = n;
                return true;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public void expect(String string) throws DataDefinitionParseError {
        if (!this.lookup(string)) {
            throw this.fail(string + " expected");
        }
    }

    public void expectWhitespace() throws DataDefinitionParseError {
        int n = this.index;
        this.skipBlank();
        if (n == this.index) {
            throw this.fail("some whitespace expected");
        }
    }

    public String lookupTypeLiteral() {
        return this.lookupIdentifier();
    }

    public String expectTypeLiteral() throws DataDefinitionParseError {
        String string = this.lookupTypeLiteral();
        if (string == null) {
            throw this.fail("type expected");
        }
        return string;
    }

    public String lookupEnumName() throws DataDefinitionParseError {
        this.skipBlank();
        if (!this.lookup("\"")) {
            throw this.fail("\"expected");
        }
        return this.upToExpect("\"");
    }

    public String expectEnumName() throws DataDefinitionParseError {
        String string = this.lookupEnumName();
        if (string == null) {
            throw this.fail("enumerator name expected");
        }
        return string;
    }

    public String lookupTableName() throws DataDefinitionParseError {
        this.skipBlank();
        int n = this.index;
        try {
            char c;
            while (Character.isLetter(c = this.toParse.charAt(n)) || Character.isDigit(c) || c == '_' || c == '-' || c == '.' || c == '/') {
                ++n;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        if (n == this.index) {
            return null;
        }
        return this.upTo(n);
    }

    public String lookupLetters() {
        this.skipBlank();
        int n = this.index;
        try {
            while (Character.isLetter(this.toParse.charAt(n))) {
                ++n;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        if (n == this.index) {
            return null;
        }
        return this.upTo(n);
    }

    public Integer lookupInteger() {
        this.skipBlank();
        int n = this.index;
        try {
            if (this.toParse.charAt(n) == '-') {
                ++n;
            }
            while (Character.isDigit(this.toParse.charAt(n))) {
                ++n;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        if (n == this.index) {
            return null;
        }
        try {
            return new Integer(this.upTo(n));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Integer expectInteger() throws DataDefinitionParseError {
        Integer n = this.lookupInteger();
        if (n == null) {
            throw this.fail("Integer expected");
        }
        return n;
    }

    String lookupIdentifier() {
        this.skipBlank();
        int n = this.index;
        try {
            char c;
            if (!Character.isLetter(this.toParse.charAt(n))) {
                return null;
            }
            ++n;
            while (Character.isDigit(c = this.toParse.charAt(n)) || Character.isLetter(c) || c == '_' || c == '-') {
                ++n;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        if (n == this.index) {
            return null;
        }
        return this.upTo(n);
    }

    String upToExpect(String string) throws DataDefinitionParseError {
        int n = this.index;
        int n2 = string.length() + this.index;
        try {
            while (!this.toParse.substring(this.index, n2).equals(string)) {
                ++this.index;
                ++n2;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw this.fail(string + " expected");
        }
        string = this.toParse.substring(n, this.index);
        this.index = n2;
        return string;
    }

    DataDefinition lookupTableSpecifier() throws DataDefinitionParseError {
        int n = this.index;
        String string = this.lookupTableName();
        if (string == null) {
            return null;
        }
        DataDefinition dataDefinition = null;
        try {
            dataDefinition = MakumbaSystem.getDataDefinition(string);
        }
        catch (DataDefinitionNotFoundError dataDefinitionNotFoundError) {
            // empty catch block
        }
        if (dataDefinition == null) {
            this.index = n;
            return null;
        }
        return dataDefinition;
    }

    void expectCharEnum(FieldInfo fieldInfo) throws DataDefinitionParseError {
        Vector<String> vector;
        fieldInfo.extra1 = vector = new Vector<String>();
        int n = 0;
        String string = this.lookupEnumName();
        if (string != null) {
            while (true) {
                int n2 = string.length();
                if (vector.contains(string)) {
                    throw this.fail("repeated name: " + string);
                }
                vector.addElement(string);
                if (n2 > n) {
                    n = n2;
                }
                if (!this.lookup(",")) break;
                string = this.expectEnumName();
            }
        }
        if (this.lookup("}")) {
            fieldInfo.extra2 = new Integer(n);
            return;
        }
        throw this.fail(" , or } epxected");
    }

    void expectIntEnum(FieldInfo fieldInfo) throws DataDefinitionParseError {
        Vector<Integer> vector = new Vector<Integer>();
        Vector<String> vector2 = new Vector<String>();
        Vector<Integer> vector3 = new Vector<Integer>();
        fieldInfo.extra1 = vector;
        fieldInfo.extra2 = vector2;
        fieldInfo.extra3 = vector3;
        String string = this.lookupEnumName();
        if (string != null) {
            while (true) {
                if (vector2.contains(string)) {
                    throw this.fail("repeated name: " + string);
                }
                vector2.addElement(string);
                this.expect("=");
                Integer n = this.expectInteger();
                vector.addElement(n);
                if (this.lookup("deprecated")) {
                    vector3.addElement(n);
                }
                if (!this.lookup(",")) break;
                string = this.expectEnumName();
            }
        }
        if (!this.lookup("}")) {
            throw this.fail("deprecated or , or } epxected");
        }
    }

    public String lookupDescription() throws DataDefinitionParseError {
        if (this.lookup(";")) {
            try {
                return this.toParse.substring(this.index);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return null;
            }
        }
        try {
            if (this.toParse.substring(this.index).trim().length() != 0) {
                throw this.fail("end of definition expected");
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    String upTo(int n) {
        String string = this.toParse.substring(this.index, n);
        this.index = n;
        return string;
    }

    public void substitute(int n, String string) {
        this.index -= n;
        this.toParse = this.toParse.substring(0, this.index) + string + this.toParse.substring(this.index + n);
    }
}

