/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.abstr;

import java.io.Serializable;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.Text;
import org.makumba.abstr.RecordParser;

public class FieldInfo
implements Serializable,
FieldDefinition {
    private static final long serialVersionUID = 1L;
    DataDefinition dd;
    static final HashMap integerTypeMap = new HashMap();
    String name;
    String type;
    boolean fixed;
    boolean notNull;
    boolean unique;
    Object defaultValue;
    String description;
    Object extra1;
    Object extra2;
    Object extra3;
    static final Date emptyDate;
    static final Object emptyInt;
    static final Object emptyReal;

    public DataDefinition getDataDefinition() {
        return this.dd;
    }

    public static FieldInfo getFieldInfo(String string, Object object, boolean bl) {
        if (object instanceof FieldInfo) {
            return new FieldInfo(string, (FieldInfo)object);
        }
        String string2 = ((String)object).trim();
        if (!bl || string2.indexOf(" ") == -1) {
            return new FieldInfo(string, string2);
        }
        string2 = string + "=" + string2;
        return (FieldInfo)new RecordParser().parse(string2).getFieldDefinition(string);
    }

    public static FieldInfo getFieldInfo(String string, Object object, boolean bl, String string2) {
        FieldInfo fieldInfo = FieldInfo.getFieldInfo(string, object, bl);
        fieldInfo.description = string2;
        return fieldInfo;
    }

    public FieldInfo(DataDefinition dataDefinition, String string) {
        this.dd = dataDefinition;
        this.name = string;
    }

    public FieldInfo(FieldInfo fieldInfo) {
        this(fieldInfo.dd, fieldInfo.name);
        this.type = fieldInfo.type;
        this.fixed = fieldInfo.fixed;
        this.notNull = fieldInfo.notNull;
        this.unique = fieldInfo.unique;
        this.defaultValue = fieldInfo.defaultValue;
        this.description = fieldInfo.description;
    }

    public FieldInfo(String string, FieldInfo fieldInfo) {
        this.name = string;
        this.type = fieldInfo.type;
        this.fixed = fieldInfo.fixed;
        this.notNull = fieldInfo.notNull;
        this.unique = fieldInfo.unique;
        this.defaultValue = fieldInfo.defaultValue;
        this.description = fieldInfo.description;
        this.extra1 = fieldInfo.extra1;
        this.extra2 = fieldInfo.extra2;
        this.extra3 = fieldInfo.extra3;
        if (this.type.equals("ptrIndex")) {
            this.type = "ptr";
            this.extra1 = fieldInfo.getDataDefinition();
        }
    }

    public FieldInfo(String string, String string2) {
        try {
            this.name = string;
            this.type = string2;
            this.fixed = false;
            this.notNull = false;
            this.unique = false;
            if (this.type.equals("char")) {
                this.extra2 = new Integer(255);
            } else if (this.type.startsWith("char")) {
                int n = this.type.indexOf("[");
                int n2 = this.type.indexOf("]");
                if (!this.type.endsWith("]") || this.type.substring(3, n).trim().length() > 1) {
                    throw new InvalidValueException("invalid char type " + this.type);
                }
                this.extra2 = new Integer(Integer.parseInt(this.type.substring(n + 1, n2)));
                this.type = "char";
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new InvalidValueException("bad type " + this.type);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidValueException("bad char[] size " + this.type);
        }
    }

    public boolean isAssignableFrom(FieldDefinition fieldDefinition) {
        switch (this.getIntegerType()) {
            case 4: {
                return this.is_int_AssignableFrom(fieldDefinition);
            }
            case 5: {
                return this.is_intEnum_AssignableFrom(fieldDefinition);
            }
            case 0: 
            case 1: {
                return this.is_ptrRel_AssignableFrom(fieldDefinition);
            }
            case 15: {
                return this.is_real_AssignableFrom(fieldDefinition);
            }
            case 12: {
                return this.is_set_AssignableFrom(fieldDefinition);
            }
        }
        return this.base_isAssignableFrom(fieldDefinition);
    }

    public boolean base_isAssignableFrom(FieldDefinition fieldDefinition) {
        return fieldDefinition.getType().equals("nil") || this.getType().equals(fieldDefinition.getType());
    }

    public boolean is_int_AssignableFrom(FieldDefinition fieldDefinition) {
        return this.base_isAssignableFrom(fieldDefinition) || fieldDefinition.getType().equals("intEnum");
    }

    public boolean is_intEnum_AssignableFrom(FieldDefinition fieldDefinition) {
        return this.is_int_AssignableFrom(fieldDefinition) || fieldDefinition.getType().equals("int") || fieldDefinition.getType().equals("char");
    }

    public boolean is_ptrRel_AssignableFrom(FieldDefinition fieldDefinition) {
        return "nil".equals(fieldDefinition.getType()) || this.getType().equals(fieldDefinition.getType()) && ((FieldInfo)fieldDefinition).extra1 instanceof DataDefinition && ((DataDefinition)((FieldInfo)fieldDefinition).extra1).getName().equals(this.getForeignTable().getName());
    }

    public boolean is_real_AssignableFrom(FieldDefinition fieldDefinition) {
        return this.base_isAssignableFrom(fieldDefinition) || fieldDefinition.getType().equals("intEnum") || fieldDefinition.getType().equals("int");
    }

    public boolean is_set_AssignableFrom(FieldDefinition fieldDefinition) {
        return "nil".equals(fieldDefinition.getType()) || this.getType().equals(fieldDefinition.getType()) && this.getForeignTable().getName().equals(fieldDefinition.getForeignTable().getName());
    }

    public String toString() {
        return this.getType();
    }

    public Object checkValue(Object object) {
        switch (this.getIntegerType()) {
            case 17: {
                return this.check_setintEnum_Value(object);
            }
        }
        return this.base_checkValue(object);
    }

    public Object base_checkValue(Object object) {
        if (!object.equals(this.getNull())) {
            return this.checkValueImpl(object);
        }
        return object;
    }

    public Object check_setintEnum_Value(Object object) {
        try {
            Object object2 = this.getEnum().checkValue(object);
            Vector<Object> vector = new Vector<Object>();
            if (object2 != null && object2 instanceof Integer) {
                vector.addElement(object2);
            }
            return vector;
        }
        catch (InvalidValueException invalidValueException) {
            this.normalCheck(object);
            Vector vector = (Vector)object;
            for (int i = 0; i < vector.size(); ++i) {
                if (vector.elementAt(i) == null || vector.elementAt(i).equals(Pointer.NullInteger)) {
                    throw new InvalidValueException(this, "set members cannot be null");
                }
                vector.setElementAt(this.getEnum().checkValue(vector.elementAt(i)), i);
            }
            return vector;
        }
    }

    public void checkInsert(Dictionary dictionary) {
        Object v = dictionary.get(this.getName());
        if (this.isNotNull() && (v == null || v.equals(this.getNull()))) {
            throw new InvalidValueException(this, "A non-null value is needed for notnull fields");
        }
        if (v != null) {
            dictionary.put(this.getName(), this.checkValue(v));
        }
    }

    public void checkUpdate(Dictionary dictionary) {
        Object v = dictionary.get(this.getName());
        if (v == null) {
            return;
        }
        if (this.isFixed()) {
            throw new InvalidValueException(this, "You cannot update a fixed field");
        }
        dictionary.put(this.getName(), this.checkValue(v));
    }

    public Vector getDeprecatedValues() {
        switch (this.getIntegerType()) {
            case 5: {
                return this.get_intEnum_DeprecatedValues();
            }
        }
        return null;
    }

    public Vector get_intEnum_DeprecatedValues() {
        return (Vector)this.extra3;
    }

    public Object getEmptyValue() {
        switch (this.getIntegerType()) {
            case 6: 
            case 7: 
            case 8: {
                return "";
            }
            case 9: 
            case 10: 
            case 11: {
                return emptyDate;
            }
            case 4: 
            case 5: {
                return emptyInt;
            }
            case 15: {
                return emptyReal;
            }
        }
        return null;
    }

    public Object getNull() {
        switch (this.getIntegerType()) {
            case 6: 
            case 7: {
                return Pointer.NullString;
            }
            case 9: 
            case 10: 
            case 11: {
                return Pointer.NullDate;
            }
            case 4: 
            case 5: {
                return Pointer.NullInteger;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 13: {
                return Pointer.Null;
            }
            case 15: {
                return Pointer.NullReal;
            }
            case 12: 
            case 16: 
            case 17: {
                return Pointer.NullSet;
            }
            case 8: {
                return Pointer.NullText;
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public String getName() {
        return this.getDataName();
    }

    public final String getDataName() {
        return this.name;
    }

    public boolean hasDescription() {
        return !this.description.equals(this.name);
    }

    public String getDescription() {
        if (this.description == null) {
            return this.name;
        }
        if (this.description.trim().equals("")) {
            return this.name;
        }
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public int getIntegerType() {
        return (Integer)integerTypeMap.get(this.getType());
    }

    public String getDataType() {
        switch (this.getIntegerType()) {
            case 6: 
            case 7: {
                return "char";
            }
            case 9: {
                return "datetime";
            }
            case 10: 
            case 11: {
                return "timestamp";
            }
            case 4: 
            case 5: {
                return "int";
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return "pointer";
            }
            case 15: {
                return "real";
            }
            case 12: {
                return "set";
            }
            case 16: {
                return "setchar";
            }
            case 13: {
                return "null";
            }
            case 17: {
                return "setint";
            }
            case 8: {
                return "text";
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public Class getJavaType() {
        switch (this.getIntegerType()) {
            case 6: 
            case 7: {
                return String.class;
            }
            case 9: 
            case 10: 
            case 11: {
                return Date.class;
            }
            case 4: 
            case 5: {
                return Integer.class;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return Pointer.class;
            }
            case 15: {
                return Double.class;
            }
            case 12: 
            case 16: 
            case 17: {
                return Vector.class;
            }
            case 13: {
                return null;
            }
            case 8: {
                return Text.class;
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public Object getDefaultValue() {
        if (this.defaultValue == null) {
            return this.getEmptyValue();
        }
        return this.defaultValue;
    }

    public Enumeration getValues() {
        switch (this.getIntegerType()) {
            case 5: 
            case 7: {
                return ((Vector)this.extra1).elements();
            }
            case 16: 
            case 17: {
                return ((Vector)this.getEnum().extra1).elements();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public Enumeration getNames() {
        switch (this.getIntegerType()) {
            default: 
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public int getEnumeratorSize() {
        switch (this.getIntegerType()) {
            case 5: 
            case 7: {
                return ((Vector)this.extra1).size();
            }
            case 16: 
            case 17: {
                return ((Vector)this.getEnum().extra1).size();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public String getStringAt(int n) {
        switch (this.getIntegerType()) {
            case 5: 
            case 7: {
                return ((Vector)this.extra1).elementAt(n).toString();
            }
            case 16: 
            case 17: {
                return ((Vector)this.getEnum().extra1).elementAt(n).toString();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public String getNameFor(int n) {
        switch (this.getIntegerType()) {
            case 5: {
                return this.get_intEnum_NameFor(n);
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public String get_intEnum_NameFor(int n) {
        Vector vector = (Vector)this.extra2;
        Vector vector2 = (Vector)this.extra1;
        for (int i = 0; i < vector2.size(); ++i) {
            if (!vector2.elementAt(i).equals(new Integer(n))) continue;
            return (String)vector.elementAt(i);
        }
        throw new InvalidValueException(this, "Can't find a name for " + n + " in " + vector2 + " with names " + vector);
    }

    public String getNameAt(int n) {
        switch (this.getIntegerType()) {
            case 7: {
                return (String)((Vector)this.extra1).elementAt(n);
            }
            case 5: {
                return (String)((Vector)this.extra2).elementAt(n);
            }
            case 16: {
                return (String)((Vector)this.getEnum().extra1).elementAt(n);
            }
            case 17: {
                return (String)((Vector)this.getEnum().extra2).elementAt(n);
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public int getDefaultInt() {
        switch (this.getIntegerType()) {
            case 4: 
            case 5: {
                return (Integer)this.getDefaultValue();
            }
            case 17: {
                return (Integer)this.getEnum().defaultValue;
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public int getIntAt(int n) {
        switch (this.getIntegerType()) {
            case 5: {
                return (Integer)((Vector)this.extra1).elementAt(n);
            }
            case 17: {
                return (Integer)((Vector)this.getEnum().extra1).elementAt(n);
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public String getDefaultString() {
        switch (this.getIntegerType()) {
            case 6: 
            case 7: 
            case 8: {
                return (String)this.getDefaultValue();
            }
            case 16: {
                return (String)this.getEnum().defaultValue;
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public int getWidth() {
        switch (this.getIntegerType()) {
            case 6: 
            case 7: {
                return (Integer)this.extra2;
            }
            case 16: {
                return (Integer)this.getEnum().extra2;
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public Object checkValueImpl(Object object) {
        switch (this.getIntegerType()) {
            case 6: {
                return this.check_char_ValueImpl(object);
            }
            case 7: {
                return this.check_charEnum_ValueImpl(object);
            }
            case 9: 
            case 10: 
            case 11: {
                return this.check_date_ValueImpl(object);
            }
            case 4: {
                return this.check_int_ValueImpl(object);
            }
            case 5: {
                return this.check_intEnum_ValueImpl(object);
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 17: {
                return this.check_ptrIndex_ValueImpl(object);
            }
            case 15: {
                return this.check_real_ValueImpl(object);
            }
            case 12: {
                return this.check_set_ValueImpl(object);
            }
            case 16: {
                return this.check_setcharEnum_ValueImpl(object);
            }
            case 13: {
                return this.check_setComplex_ValueImpl(object);
            }
            case 8: {
                return this.check_text_ValueImpl(object);
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public Object check_char_ValueImpl(Object object) {
        this.normalCheck(object);
        String string = (String)object;
        if (string.length() > this.getWidth()) {
            throw new InvalidValueException(this, "String too long for char[] field. Maximum width: " + this.getWidth() + " given width " + string.length() + ".\n\tGiven value <" + string + ">");
        }
        return object;
    }

    public Object check_charEnum_ValueImpl(Object object) {
        this.check_char_ValueImpl(object);
        Vector vector = (Vector)this.extra1;
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector.elementAt(i).equals(object)) continue;
            return object;
        }
        throw new InvalidValueException(this, "value set to char enumerator (" + object + ") is not a member of " + vector);
    }

    public Object check_date_ValueImpl(Object object) {
        return this.normalCheck(object);
    }

    public Object check_int_ValueImpl(Object object) {
        return this.normalCheck(object);
    }

    public Object check_intEnum_ValueImpl(Object object) {
        Vector vector = (Vector)this.extra2;
        Vector vector2 = (Vector)this.extra1;
        if (object instanceof Integer) {
            for (int i = 0; i < vector2.size(); ++i) {
                if (!vector2.elementAt(i).equals(object)) continue;
                return object;
            }
            throw new InvalidValueException(this, "int value set to int enumerator (" + object + ") is not a member of " + vector2);
        }
        if (!(object instanceof String)) {
            throw new InvalidValueException(this, "int enumerators only accept values of type Integer or String. Value supplied (" + object + ") is of type " + object.getClass().getName());
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector.elementAt(i).equals(object)) continue;
            return vector2.elementAt(i);
        }
        throw new InvalidValueException(this, "string value set to int enumerator (" + object + ") is neither a member of " + vector + " nor amember of " + vector2);
    }

    public Object check_ptrIndex_ValueImpl(Object object) {
        if (object instanceof Pointer) {
            if (!((Pointer)object).getType().equals(this.getPointedType().getName())) {
                throw new InvalidValueException((FieldDefinition)this, this.getPointedType().getName(), (Pointer)object);
            }
            return object;
        }
        if (object instanceof String) {
            return new Pointer(this.getPointedType().getName(), (String)object);
        }
        throw new InvalidValueException(this, "Only java.lang.String and org.makumba.Pointer are assignable to makumba pointers, given value <" + object + "> is of type " + object.getClass().getName());
    }

    public Object check_real_ValueImpl(Object object) {
        if (object instanceof Integer) {
            return object;
        }
        return this.normalCheck(object);
    }

    public Object check_set_ValueImpl(Object object) {
        try {
            Object object2 = this.check_ptrIndex_ValueImpl(object);
            Vector<Object> vector = new Vector<Object>();
            if (object2 != null && object2 instanceof Pointer) {
                vector.addElement(object2);
            }
            return vector;
        }
        catch (InvalidValueException invalidValueException) {
            this.normalCheck(object);
            Vector vector = (Vector)object;
            FieldDefinition fieldDefinition = this.getForeignTable().getFieldDefinition(this.getForeignTable().getIndexPointerFieldName());
            for (int i = 0; i < vector.size(); ++i) {
                if (vector.elementAt(i) == null || vector.elementAt(i).equals(Pointer.Null)) {
                    throw new InvalidValueException(this, "set members cannot be null");
                }
                try {
                    vector.setElementAt(fieldDefinition.checkValue(vector.elementAt(i)), i);
                    continue;
                }
                catch (InvalidValueException invalidValueException2) {
                    throw new InvalidValueException(this, "the set member <" + vector.elementAt(i) + "> is not assignable to pointers of type " + this.getForeignTable().getName());
                }
            }
            return vector;
        }
    }

    public Object check_setcharEnum_ValueImpl(Object object) {
        try {
            Object object2 = this.getEnum().checkValue(object);
            Vector<Object> vector = new Vector<Object>();
            if (object2 != null && object2 instanceof String) {
                vector.addElement(object2);
            }
            return vector;
        }
        catch (InvalidValueException invalidValueException) {
            this.normalCheck(object);
            Vector vector = (Vector)object;
            for (int i = 0; i < vector.size(); ++i) {
                if (vector.elementAt(i) == null || vector.elementAt(i).equals(Pointer.NullString)) {
                    throw new InvalidValueException(this, "set members cannot be null");
                }
                vector.setElementAt(this.getEnum().checkValue(vector.elementAt(i)), i);
            }
            return vector;
        }
    }

    public Object check_setComplex_ValueImpl(Object object) {
        throw new InvalidValueException(this, "subsets cannot be assigned directly");
    }

    public Object check_text_ValueImpl(Object object) {
        try {
            return Text.getText(object);
        }
        catch (InvalidValueException invalidValueException) {
            throw new InvalidValueException(this, invalidValueException.getMessage());
        }
    }

    FieldInfo getEnum() {
        return (FieldInfo)((DataDefinition)this.extra1).getFieldDefinition("enum");
    }

    public DataDefinition get_ptrOne_Subtable() {
        return (DataDefinition)this.extra1;
    }

    public Date getDefaultDate() {
        switch (this.getIntegerType()) {
            case 9: 
            case 10: 
            case 11: {
                return (Date)this.getDefaultValue();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public DataDefinition getForeignTable() {
        switch (this.getIntegerType()) {
            case 0: 
            case 1: {
                return this.get_ptrRel_ForeignTable();
            }
            case 12: {
                return this.get_set_ForeignTable();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public DataDefinition get_ptrRel_ForeignTable() {
        return (DataDefinition)this.extra1;
    }

    public DataDefinition get_set_ForeignTable() {
        if (this.extra3 == null) {
            return this.pointerToForeign().getForeignTable();
        }
        return (DataDefinition)this.extra3;
    }

    FieldDefinition pointerToForeign() {
        return this.getSubtable().getFieldDefinition((String)this.getSubtable().getFieldNames().elementAt(4));
    }

    public DataDefinition getSubtable() {
        switch (this.getIntegerType()) {
            case 2: 
            case 13: 
            case 16: 
            case 17: {
                return this.get_ptrOne_Subtable();
            }
            case 12: {
                return this.get_set_Subtable();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public DataDefinition get_set_Subtable() {
        return (DataDefinition)this.extra1;
    }

    public DataDefinition getPointedType() {
        switch (this.getIntegerType()) {
            case 3: {
                return this.get_ptrIndex_PointedType();
            }
            case 2: 
            case 13: 
            case 16: 
            case 17: {
                return this.get_ptrOne_PointedType();
            }
            case 0: 
            case 1: 
            case 12: {
                return this.get_ptrRel_PointedType();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public DataDefinition get_ptrIndex_PointedType() {
        return this.getDataDefinition();
    }

    public DataDefinition get_ptrOne_PointedType() {
        return this.getSubtable();
    }

    public DataDefinition get_ptrRel_PointedType() {
        return this.getForeignTable();
    }

    public String getTitleField() {
        switch (this.getIntegerType()) {
            case 0: 
            case 12: {
                return this.get_ptr_TitleField();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public String get_ptr_TitleField() {
        if (this.hasTitleFieldIndicated()) {
            return (String)this.extra2;
        }
        return this.getForeignTable().getTitleFieldName();
    }

    public boolean hasTitleFieldIndicated() {
        switch (this.getIntegerType()) {
            case 0: 
            case 12: {
                return this.has_ptr_TitleFieldIndicated();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public boolean has_ptr_TitleFieldIndicated() {
        return this.extra2 != null;
    }

    protected Object normalCheck(Object object) {
        if (!this.getJavaType().isInstance(object)) {
            throw new InvalidValueException((FieldDefinition)this, this.getJavaType(), object);
        }
        return object;
    }

    static {
        integerTypeMap.put("ptr", new Integer(0));
        integerTypeMap.put("ptrRel", new Integer(1));
        integerTypeMap.put("ptrOne", new Integer(2));
        integerTypeMap.put("ptrIndex", new Integer(3));
        integerTypeMap.put("int", new Integer(4));
        integerTypeMap.put("intEnum", new Integer(5));
        integerTypeMap.put("char", new Integer(6));
        integerTypeMap.put("charEnum", new Integer(7));
        integerTypeMap.put("text", new Integer(8));
        integerTypeMap.put("date", new Integer(9));
        integerTypeMap.put("dateCreate", new Integer(10));
        integerTypeMap.put("dateModify", new Integer(11));
        integerTypeMap.put("set", new Integer(12));
        integerTypeMap.put("setComplex", new Integer(13));
        integerTypeMap.put("nil", new Integer(14));
        integerTypeMap.put("real", new Integer(15));
        integerTypeMap.put("setcharEnum", new Integer(16));
        integerTypeMap.put("setintEnum", new Integer(17));
        GregorianCalendar gregorianCalendar = new GregorianCalendar(MakumbaSystem.getTimeZone());
        gregorianCalendar.clear();
        gregorianCalendar.set(1900, 0, 1);
        emptyDate = gregorianCalendar.getTime();
        emptyInt = new Integer(0);
        emptyReal = new Double(0.0);
    }
}

