/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.controller.http;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.makumba.AttributeNotFoundException;
import org.makumba.Attributes;
import org.makumba.LogicException;
import org.makumba.MakumbaSystem;
import org.makumba.UnauthenticatedException;
import org.makumba.UnauthorizedException;
import org.makumba.controller.Logic;
import org.makumba.controller.http.HttpParameters;
import org.makumba.controller.http.MultipartHttpParameters;
import org.makumba.util.DbConnectionProvider;

public class RequestAttributes
implements Attributes {
    public static final String PARAMETERS_NAME = "makumba.parameters";
    public static final String ATTRIBUTES_NAME = "makumba.attributes";
    public static final String CONTROLLER_NAME = "makumba.controller";
    HttpServletRequest request;
    Object controller;
    public static final String PROVIDER_ATTRIBUTE = "org.makumba.providerAttribute";
    public static final Object notFound = "not found";

    public String getRequestDatabase() {
        return MakumbaSystem.getDefaultDatabaseName();
    }

    public Object getRequestController() {
        return this.controller;
    }

    public static RequestAttributes getAttributes(HttpServletRequest httpServletRequest) throws LogicException {
        if (httpServletRequest.getAttribute(ATTRIBUTES_NAME) == null) {
            httpServletRequest.setAttribute(ATTRIBUTES_NAME, (Object)new RequestAttributes(httpServletRequest));
        }
        return (RequestAttributes)httpServletRequest.getAttribute(ATTRIBUTES_NAME);
    }

    RequestAttributes(HttpServletRequest httpServletRequest) throws LogicException {
        this(Logic.getLogic(httpServletRequest.getServletPath()), httpServletRequest, null);
    }

    RequestAttributes(Object object, HttpServletRequest httpServletRequest, String string) throws LogicException {
        block4: {
            if (string == null) {
                string = this.getRequestDatabase();
            }
            this.request = httpServletRequest;
            this.controller = object;
            if (httpServletRequest.getAttribute(CONTROLLER_NAME + object.getClass().getName()) == null) {
                httpServletRequest.setAttribute(CONTROLLER_NAME + object.getClass().getName(), object);
                try {
                    Logic.doInit(object, this, string, RequestAttributes.getConnectionProvider(httpServletRequest));
                }
                catch (UnauthorizedException unauthorizedException) {
                    if (httpServletRequest.getServletPath().endsWith("login.jsp")) break block4;
                    throw unauthorizedException;
                }
            }
        }
    }

    public static DbConnectionProvider getConnectionProvider(HttpServletRequest httpServletRequest) {
        DbConnectionProvider dbConnectionProvider = (DbConnectionProvider)httpServletRequest.getAttribute(PROVIDER_ATTRIBUTE);
        if (dbConnectionProvider == null) {
            dbConnectionProvider = new DbConnectionProvider();
            httpServletRequest.setAttribute(PROVIDER_ATTRIBUTE, (Object)dbConnectionProvider);
        }
        return dbConnectionProvider;
    }

    public static HttpParameters getParameters(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getAttribute(PARAMETERS_NAME) == null) {
            httpServletRequest.setAttribute(PARAMETERS_NAME, (Object)RequestAttributes.makeParameters(httpServletRequest));
        }
        return (HttpParameters)httpServletRequest.getAttribute(PARAMETERS_NAME);
    }

    public static HttpParameters makeParameters(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getContentType() != null && httpServletRequest.getContentType().indexOf("multipart") != -1) {
            return new MultipartHttpParameters(httpServletRequest);
        }
        return new HttpParameters(httpServletRequest);
    }

    public static void setAttribute(HttpServletRequest httpServletRequest, String string, Object object) {
        if (object != null) {
            httpServletRequest.setAttribute(string, object);
            httpServletRequest.removeAttribute(string + "_null");
        } else {
            httpServletRequest.removeAttribute(string);
            httpServletRequest.setAttribute(string + "_null", (Object)"null");
        }
    }

    public Object setAttribute(String string, Object object) {
        String string2 = string + "_null";
        HttpSession httpSession = this.request.getSession(true);
        Object object2 = httpSession.getAttribute(string);
        httpSession.setAttribute(string, object);
        if (object == null) {
            httpSession.setAttribute(string2, (Object)"null");
        } else {
            httpSession.removeAttribute(string2);
        }
        return object2;
    }

    public void removeAttribute(String string) throws LogicException {
        this.request.getSession(true).removeAttribute(string);
    }

    public boolean hasAttribute(String string) {
        try {
            return this.checkSessionForAttribute(string) != notFound || this.checkServletLoginForAttribute(string) != notFound || this.checkLogicForAttribute(string) != notFound || this.checkParameterForAttribute(string) != notFound;
        }
        catch (LogicException logicException) {
            return false;
        }
    }

    public String toString() {
        Object object;
        Object object2;
        Object object3;
        String string = "Makumba Atributes:\n";
        string = string + "\tSession: {";
        HttpSession httpSession = this.request.getSession(true);
        Enumeration enumeration = httpSession.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            string = string + (String)object3 + "=";
            object2 = httpSession.getAttribute((String)object3);
            string = object2 instanceof RequestAttributes ? string + object2.getClass() : string + object2;
            if (!enumeration.hasMoreElements()) continue;
            string = string + ", ";
        }
        string = string + "}\n";
        object3 = this.request.getAttributeNames();
        string = string + "\tRequest: {";
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            string = string + (String)object2 + "=";
            object = this.request.getAttribute((String)object2);
            string = object instanceof RequestAttributes ? string + object.getClass() : string + object;
            if (!object3.hasMoreElements()) continue;
            string = string + ", ";
        }
        string = string + "}\n";
        object2 = this.request.getParameterNames();
        string = string + "\tParameters: {";
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            string = string + (String)object + "=" + this.request.getParameter((String)object);
            if (!object2.hasMoreElements()) continue;
            string = string + ", ";
        }
        string = string + "}";
        return string;
    }

    public Object getAttribute(String string) throws LogicException {
        Object object = this.checkSessionForAttribute(string);
        if (object != notFound) {
            return object;
        }
        object = this.checkServletLoginForAttribute(string);
        if (object != notFound) {
            return object;
        }
        object = this.checkLogicForAttribute(string);
        if (object != notFound) {
            return object;
        }
        object = this.checkParameterForAttribute(string);
        if (object != notFound) {
            return object;
        }
        throw new AttributeNotFoundException(string);
    }

    public Object checkSessionForAttribute(String string) {
        String string2 = string + "_null";
        HttpSession httpSession = this.request.getSession(true);
        Object object = httpSession.getAttribute(string);
        if (object != null) {
            return object;
        }
        if (httpSession.getAttribute(string2) != null) {
            return null;
        }
        object = this.request.getAttribute(string);
        if (object != null) {
            return object;
        }
        if (this.request.getAttribute(string2) != null) {
            return null;
        }
        return notFound;
    }

    public Object checkServletLoginForAttribute(String string) {
        if (this.request.getRemoteUser() != null && this.request.isUserInRole(string)) {
            return this.request.getRemoteUser();
        }
        return notFound;
    }

    public Object checkLogicForAttribute(String string) throws LogicException {
        String string2 = string + "_null";
        HttpSession httpSession = this.request.getSession(true);
        boolean bl = false;
        Object object = null;
        try {
            object = Logic.getAttribute(this.getRequestController(), string, this, this.getRequestDatabase(), RequestAttributes.getConnectionProvider(this.request));
            if (object == null) {
                bl = true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (UnauthenticatedException unauthenticatedException) {
            unauthenticatedException.setAttributeName(string);
            throw unauthenticatedException;
        }
        if (object != null) {
            httpSession.setAttribute(string, object);
            return object;
        }
        if (bl) {
            httpSession.removeAttribute(string);
            httpSession.setAttribute(string2, (Object)"x");
            return null;
        }
        return notFound;
    }

    public Object checkParameterForAttribute(String string) {
        Object object = RequestAttributes.getParameters(this.request).getParameter(string);
        if (object != null) {
            return object;
        }
        return notFound;
    }
}

