/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.makumba.DBError;
import org.makumba.DataDefinition;
import org.makumba.DataTransformer;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.db.DBConnection;
import org.makumba.db.Database;

public abstract class Table {
    protected DataDefinition dd;
    protected HashMap fieldDBNames = new HashMap();
    Database db;
    Hashtable relatedTables = new Hashtable();
    String selectAllWithDbsv;
    Object[] selectLimits = null;
    static final int BAR = 75;
    DataTransformer insertHook;

    public Database getDatabase() {
        return this.db;
    }

    protected void setDataDefinition(DataDefinition dataDefinition) {
        this.dd = dataDefinition;
        Enumeration enumeration = dataDefinition.getFieldNames().elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            FieldDefinition fieldDefinition = dataDefinition.getFieldDefinition(string);
            if (fieldDefinition.getType().equals("ptr") || fieldDefinition.getType().equals("ptrRel")) {
                this.relatedTables.put(string, fieldDefinition.getForeignTable());
                continue;
            }
            if ((!fieldDefinition.getType().startsWith("ptr") || fieldDefinition.getType().equals("ptrIndex")) && !fieldDefinition.getType().startsWith("set")) continue;
            this.relatedTables.put(string, fieldDefinition.getSubtable());
        }
    }

    public DataDefinition getDataDefinition() {
        return this.dd;
    }

    public FieldDefinition getFieldDefinition(String string) {
        return this.dd.getFieldDefinition(string);
    }

    public Table getRelatedTable(String string) {
        return this.getDatabase().getTable((DataDefinition)this.relatedTables.get(string));
    }

    public abstract boolean canAdmin();

    public abstract boolean exists();

    public abstract int deleteFrom(DBConnection var1, DBConnection var2, boolean var3);

    public abstract boolean exists(String var1);

    void copyFrom(DBConnection dBConnection, Table table, DBConnection dBConnection2, boolean bl) {
        Object object;
        Object object2;
        Serializable serializable;
        final String string = this.getDataDefinition().getName();
        if (!table.exists() || string.equals("org.makumba.db.Catalog")) {
            return;
        }
        if (this.selectAllWithDbsv == null) {
            serializable = new StringBuffer();
            String string2 = "";
            Object object3 = this.dd.getFieldNames().elements();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                if (this.dd.getFieldDefinition((String)object2).getType().startsWith("set")) continue;
                ((StringBuffer)serializable).append(string2);
                string2 = ", ";
                ((StringBuffer)serializable).append("t.").append((String)object2);
            }
            object3 = this.getDataDefinition().getIndexPointerFieldName();
            object2 = "";
            if (!bl) {
                object2 = "WHERE t." + (String)object3 + ">=$1 AND t." + (String)object3 + " <=$2";
                this.selectLimits = new Object[2];
                final int n = dBConnection2.getHostDatabase().getDbsv();
                this.selectLimits[0] = new Pointer(){
                    private static final long serialVersionUID = 1L;

                    public String getType() {
                        return string;
                    }

                    public long longValue() {
                        return n << 24;
                    }
                };
                this.selectLimits[1] = new Pointer(){
                    private static final long serialVersionUID = 1L;

                    public String getType() {
                        return string;
                    }

                    public long longValue() {
                        return (n + 1 << 24) - 1;
                    }
                };
            }
            this.selectAllWithDbsv = "SELECT " + serializable + " FROM " + string + " t " + (String)object2;
        }
        if (((Vector)(serializable = dBConnection2.executeQuery(this.selectAllWithDbsv, this.selectLimits))).size() == 0) {
            MakumbaSystem.getMakumbaLogger("db.admin.copy").info(string + ": no records to copy");
            return;
        }
        MakumbaSystem.getMakumbaLogger("db.admin.copy").info(string + ": starting copying " + ((Vector)serializable).size() + " records");
        System.out.print("|");
        for (int i = 0; i < 75; ++i) {
            System.out.print("-");
        }
        System.out.print("|\n ");
        System.out.flush();
        float f = (float)((Vector)serializable).size() / 75.0f;
        int n = 0;
        object2 = new Hashtable(23);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(23);
        int n2 = 0;
        Enumeration enumeration = this.dd.getFieldNames().elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (this.dd.getFieldDefinition((String)object).getType().startsWith("set")) continue;
            hashtable.put("col" + (n2 + 1), object);
            ++n2;
        }
        for (int i = 0; i < ((Vector)serializable).size(); ++i) {
            object = (Dictionary)((Vector)serializable).elementAt(i);
            Enumeration enumeration2 = ((Dictionary)object).keys();
            while (enumeration2.hasMoreElements()) {
                Object k = enumeration2.nextElement();
                ((Hashtable)object2).put(hashtable.get(k), ((Dictionary)object).get(k));
            }
            dBConnection.insert(this.getDataDefinition().getName(), (Dictionary)object2);
            ((Hashtable)object2).clear();
            ((Vector)serializable).setElementAt(null, i);
            int n3 = (int)(((float)i + 1.0f) / f);
            while (n3 > n) {
                System.out.print("*");
                System.out.flush();
                ++n;
            }
        }
        System.out.println();
    }

    protected abstract void open(Properties var1);

    void computeInsertHook() {
        String string;
        if (this.insertHook == null && (string = this.getDatabase().getConfiguration("insert#" + this.getDataDefinition().getName())) != null) {
            try {
                this.insertHook = (DataTransformer)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new DBError(exception);
            }
        }
    }

    public Pointer insertRecord(DBConnection dBConnection, Dictionary dictionary) {
        return this.insertRecordImpl(dBConnection, dictionary);
    }

    public abstract Pointer insertRecordImpl(DBConnection var1, Dictionary var2);

    public abstract void checkInsert(Dictionary var1, Dictionary var2);

    public abstract void checkUpdate(Dictionary var1, Dictionary var2);
}

