/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.makumba.MakumbaSystem;
import org.makumba.devel.LineViewer;
import org.makumba.devel.javaViewer;
import org.makumba.devel.jspViewer;
import org.makumba.devel.logicViewer;
import org.makumba.devel.mddViewer;

public class SourceViewServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        LineViewer lineViewer = null;
        String string = httpServletRequest.getServletPath();
        try {
            if (string.equals("/dataDefinitions")) {
                lineViewer = new mddViewer(httpServletRequest, this);
            } else if (string.endsWith(".jspx") || string.endsWith(".jsps") || string.endsWith(".jspxp")) {
                lineViewer = new jspViewer(httpServletRequest, this);
            } else if (string.equals("/classes")) {
                lineViewer = new javaViewer(httpServletRequest, this);
            } else if (string.equals("/logic")) {
                lineViewer = new logicViewer(httpServletRequest, this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            httpServletResponse.sendError(404, exception.toString());
            return;
        }
        if (lineViewer != null) {
            File file = lineViewer.getDirectory();
            if (file == null) {
                httpServletResponse.setContentType("text/html");
                try {
                    lineViewer.parseText(printWriter);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                if (httpServletRequest.getPathInfo() == null) {
                    if (string.startsWith("/")) {
                        string = string.substring(1);
                    }
                    httpServletResponse.sendRedirect(string + "/");
                    return;
                }
                if (!httpServletRequest.getPathInfo().endsWith("/")) {
                    httpServletResponse.sendRedirect(string + httpServletRequest.getPathInfo() + "/");
                    return;
                }
                String string2 = file.getName();
                if (file.getAbsolutePath().indexOf("classes/") != -1) {
                    string2 = file.getAbsolutePath().substring(file.getAbsolutePath().indexOf("classes"));
                } else if (file.getAbsolutePath().indexOf("dataDefinitions/") != -1) {
                    string2 = file.getAbsolutePath().substring(file.getAbsolutePath().indexOf("dataDefinitions"));
                }
                httpServletResponse.setContentType("text/html");
                printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
                printWriter.println("<html><head><title>" + string2 + "</title>");
                printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" >");
                printWriter.println("</head><body bgcolor=white><table width=\"100%\" bgcolor=\"lightblue\"><tr><td rowspan=\"2\">");
                printWriter.print("<font size=\"+2\"><a href=\".\"><font color=\"darkblue\">" + string2 + "</font></a></font>");
                printWriter.print("<font size=\"-1\"><br>" + file.getCanonicalPath() + "</font>");
                printWriter.print("</td>");
                printWriter.print("</tr></table>\n<pre style=\"margin-top:0\">");
                if (!string2.equals("classes") && !string2.equals("classes/dataDefinitions")) {
                    printWriter.println("<b><a href=\"../\">../</a></b> (up one level)");
                }
                if (lineViewer instanceof javaViewer) {
                    this.processDirectory(printWriter, file, ".java");
                    Object[] objectArray = file.list();
                    Arrays.sort(objectArray);
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object = objectArray[i];
                        File file2 = new File(file.getAbsolutePath() + File.separator + (String)object);
                        if (!file2.isFile() || !file2.getName().endsWith(".java")) continue;
                        printWriter.println("<b><a href=\"" + (String)object + "\">" + (String)object + "</a></b>");
                    }
                } else if (lineViewer instanceof mddViewer) {
                    this.processDirectory(printWriter, file, "dd");
                    Object[] objectArray = file.list();
                    Arrays.sort(objectArray);
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object = objectArray[i];
                        if (((String)object).indexOf(".") == -1 || !((String)object).endsWith("dd")) continue;
                        String string3 = httpServletRequest.getPathInfo() + (String)object;
                        string3 = string3.substring(1, string3.lastIndexOf(".")).replace('/', '.');
                        String string4 = httpServletRequest.getContextPath() + "/dataDefinitions/" + string3;
                        printWriter.println("<a href=\"" + string4 + "\">" + (String)object + "</a>");
                    }
                } else {
                    System.out.println("don't know how to handle viewer: " + lineViewer + "(" + lineViewer.getClass() + ")");
                }
                printWriter.println("</pre>");
                printWriter.println("<hr><font size=\"-1\"><a href=\"http://www.makumba.org\">Makumba</a> developer support, version: " + MakumbaSystem.getVersion() + "</font>");
                printWriter.println("</body></html>");
            }
        } else {
            printWriter.println("unknown source type: " + string);
        }
    }

    private void processDirectory(PrintWriter printWriter, File file, String string) {
        Object[] objectArray = file.list();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            File file2 = new File(file.getAbsolutePath() + File.separator + (String)object);
            if (!file2.isDirectory() || file2.getName().equals("CVS") || !this.containsFilesWithExtension(file2, string)) continue;
            printWriter.println("<b><a href=\"" + (String)object + "/\">" + (String)object + "/</a></b>");
        }
    }

    private boolean containsFilesWithExtension(File file, String string) {
        File file2;
        int n;
        String[] stringArray = file.list();
        for (n = 0; n < stringArray.length; ++n) {
            file2 = new File(file.getAbsolutePath() + File.separator + stringArray[n]);
            if (!file2.isFile() || !file2.getName().endsWith(string)) continue;
            return true;
        }
        for (n = 0; n < stringArray.length; ++n) {
            file2 = new File(file.getAbsolutePath() + File.separator + stringArray[n]);
            if (!file2.isDirectory() || !this.containsFilesWithExtension(file2, string)) continue;
            return true;
        }
        return false;
    }
}

