/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.importer;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaSystem;
import org.makumba.Transaction;
import org.makumba.importer.ObjectImporter;
import org.makumba.util.HtmlTagEnumerator;

public class HtmlTableImporter {
    ObjectImporter imp;
    boolean inRow = false;
    boolean inCell = false;
    String text;
    Vector data;
    String[] fieldOrder;
    String type;
    Transaction db;

    void endOfCell() {
        if (this.inCell) {
            this.data.addElement(this.text);
        }
        this.text = null;
    }

    void endOfRow() {
        this.endOfCell();
        if (this.data != null && !this.data.isEmpty()) {
            if (this.data.size() != this.fieldOrder.length) {
                MakumbaSystem.getMakumbaLogger("import").severe(this.type + ": invalid HTML table row length: " + this.data.size() + "\r\nin: " + this.data);
            } else {
                try {
                    this.db.insert(this.type, this.importVector());
                }
                catch (InvalidValueException invalidValueException) {
                    MakumbaSystem.getMakumbaLogger("import").warning("record not inserted --> " + invalidValueException.getMessage());
                }
            }
        }
    }

    public HtmlTableImporter(Transaction transaction, DataDefinition dataDefinition, Reader reader, String string, String[] stringArray) throws IOException {
        this.imp = new ObjectImporter(dataDefinition, true);
        this.fieldOrder = stringArray;
        this.type = dataDefinition.getName();
        this.db = transaction;
        String[] stringArray2 = new String[]{dataDefinition.getName()};
        MakumbaSystem._delete(transaction.getName(), transaction.getName(), stringArray2);
        HtmlTagEnumerator htmlTagEnumerator = new HtmlTagEnumerator(reader);
        while (htmlTagEnumerator.next() && !htmlTagEnumerator.getTag().equals(string)) {
        }
        while (htmlTagEnumerator.next()) {
            String string2;
            if (htmlTagEnumerator.getTagType().toLowerCase().equals("tr")) {
                this.endOfRow();
                this.inRow = true;
                this.inCell = false;
                this.data = new Vector();
            } else if (this.inRow && htmlTagEnumerator.getTagType().toLowerCase().equals("td")) {
                this.endOfCell();
                this.inCell = true;
            } else if (this.inCell && (string2 = htmlTagEnumerator.getNonHtml()) != null && string2.length() > 0) {
                this.text = string2;
            }
            if (!htmlTagEnumerator.getTagType().toLowerCase().equals("/table")) continue;
            this.endOfRow();
            MakumbaSystem.getMakumbaLogger("import").severe("end of table encountered");
            return;
        }
        MakumbaSystem.getMakumbaLogger("import").severe("end of table missing");
    }

    Dictionary importVector() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.fieldOrder.length; ++i) {
            if (this.data.elementAt(i) == null) continue;
            Object object = this.imp.getValue(this.fieldOrder[i], (String)this.data.elementAt(i), this.db, null);
            if (object != null) {
                ((Dictionary)hashtable).put(this.fieldOrder[i], object);
            }
            vector.addElement(object);
        }
        MakumbaSystem.getMakumbaLogger("import").finest(vector.toString());
        return hashtable;
    }

    public static void main(String[] stringArray) throws IOException {
        String[] stringArray2 = new String[stringArray.length - 4];
        System.arraycopy(stringArray, 4, stringArray2, 0, stringArray2.length);
        new HtmlTableImporter(MakumbaSystem.getConnectionTo(stringArray[0]), MakumbaSystem.getDataDefinition(stringArray[1]), new BufferedReader(new InputStreamReader(new FileInputStream(stringArray[2]))), stringArray[3], stringArray2);
    }
}

