/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.makumba.MakumbaSystem;
import org.makumba.Text;

public class LongData {
    int length = 0;
    LongDataStrategy ds = new EmptyStrategy();

    public LongData() {
    }

    public LongData(InputStream inputStream) throws IOException {
        this.appendFrom(new InputStreamReader(inputStream));
    }

    public void appendFrom(Reader reader) throws IOException {
        int n;
        char[] cArray = new char[Text.FILE_LIMIT];
        while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
            byte[] byArray = new String(cArray, 0, n).getBytes();
            this.ds.append(byArray, 0, byArray.length);
            this.length += byArray.length;
        }
    }

    public void appendFrom(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[Text.FILE_LIMIT];
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            this.ds.append(byArray, 0, n);
            this.length += n;
        }
    }

    public int getLength() {
        return this.length;
    }

    public InputStream getInputStream() throws IOException {
        return this.ds.getInputStream();
    }

    class FileStrategy
    implements LongDataStrategy {
        File temp = File.createTempFile("makumbaLongContent", ".bin", null);
        OutputStream out;

        FileStrategy() throws IOException {
            this.temp.deleteOnExit();
            MakumbaSystem.getMakumbaLogger("util.longContent").fine("writing to " + this.temp);
            this.out = new BufferedOutputStream(new FileOutputStream(this.temp), Text.FILE_LIMIT);
        }

        public void append(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
        }

        public InputStream getInputStream() throws IOException {
            this.out.close();
            return new BufferedInputStream(new FileInputStream(this.temp));
        }

        protected void finalize() {
            this.temp.delete();
        }
    }

    class DataStrategy
    implements LongDataStrategy {
        ByteArrayOutputStream bout;

        DataStrategy(int n) {
            this.bout = new ByteArrayOutputStream(n);
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.bout.toByteArray(), 0, this.bout.size());
        }

        public void append(byte[] byArray, int n, int n2) throws IOException {
            if (LongData.this.length + n2 >= Text.FILE_LIMIT) {
                LongData.this.ds = new FileStrategy();
                LongData.this.ds.append(this.bout.toByteArray(), 0, this.bout.size());
                LongData.this.ds.append(byArray, n, n2);
                this.bout = null;
            } else {
                this.bout.write(byArray, n, n2);
            }
        }
    }

    class EmptyStrategy
    implements LongDataStrategy {
        EmptyStrategy() {
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(new byte[0], 0, 0);
        }

        public void append(byte[] byArray, int n, int n2) throws IOException {
            LongData.this.ds = LongData.this.length + n2 >= Text.FILE_LIMIT ? new FileStrategy() : new DataStrategy(n2);
            LongData.this.ds.append(byArray, n, n2);
        }
    }

    static interface LongDataStrategy {
        public InputStream getInputStream() throws IOException;

        public void append(byte[] var1, int var2, int var3) throws IOException;
    }
}

