/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.view;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.makumba.view.InvalidValueException;
import org.makumba.view.RecordFormatter;

public class FieldFormatter {
    static String[] params = new String[]{"default", "empty"};
    static String[][] paramValues = new String[][]{null, null};
    static Object dummy = new Object();
    Hashtable validParams = new Hashtable(13);

    public String[] getAcceptedParams() {
        return params;
    }

    public String[][] getAcceptedValue() {
        return paramValues;
    }

    public static FieldFormatter getInstance() {
        return SingletonHolder.singleton;
    }

    protected FieldFormatter() {
        for (int i = 0; i < this.getAcceptedParams().length; ++i) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>(13);
            if (this.getAcceptedValue()[i] != null) {
                for (int j = 0; j < this.getAcceptedValue()[i].length; ++j) {
                    hashtable.put(this.getAcceptedValue()[i][j], dummy);
                }
            }
            this.validParams.put(this.getAcceptedParams()[i], hashtable);
        }
    }

    public String getExpr(RecordFormatter recordFormatter, int n) {
        if (recordFormatter.expr[n] != null) {
            return recordFormatter.expr[n];
        }
        return recordFormatter.dd.getFieldDefinition(n).getName();
    }

    public void initExpr(RecordFormatter recordFormatter, int n, String string) {
        recordFormatter.expr[n] = string;
    }

    public void checkParams(RecordFormatter recordFormatter, int n, Dictionary dictionary) {
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.startsWith("org.makumba")) continue;
            this.checkParam(recordFormatter, n, string, ((String)dictionary.get(string)).toLowerCase());
        }
    }

    public void checkParam(RecordFormatter recordFormatter, int n, String string, String string2) {
        Hashtable hashtable = (Hashtable)this.validParams.get(string);
        if (hashtable == null) {
            throw new InvalidValueException(recordFormatter.expr[n], "invalid format parameter '" + string + "'");
        }
        if (hashtable.size() == 0) {
            return;
        }
        if (hashtable.get(string2) == null) {
            throw new InvalidValueException(recordFormatter.expr[n], "invalid value for format parameter '" + string + "': <" + string2 + ">");
        }
    }

    public String format(RecordFormatter recordFormatter, int n, Object object, Dictionary dictionary) {
        String string = object == null || object.equals(recordFormatter.dd.getFieldDefinition(n).getNull()) ? this.formatNull(recordFormatter, n, dictionary) : this.formatNotNull(recordFormatter, n, object, dictionary);
        if ("".equals(string)) {
            return this.getEmptyValueFormat(recordFormatter, n, dictionary);
        }
        return string;
    }

    public String formatNull(RecordFormatter recordFormatter, int n, Dictionary dictionary) {
        return this.getDefaultValueFormat(recordFormatter, n, dictionary);
    }

    public String formatNotNull(RecordFormatter recordFormatter, int n, Object object, Dictionary dictionary) {
        return object.toString();
    }

    public int getIntParam(RecordFormatter recordFormatter, int n, Dictionary dictionary, String string) {
        String string2 = (String)dictionary.get(string);
        if (string2 == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidValueException(recordFormatter.expr[n], "invalid integer for " + string + ": " + string2);
        }
    }

    public String getIntParamString(RecordFormatter recordFormatter, int n, Dictionary dictionary, String string) {
        int n2 = this.getIntParam(recordFormatter, n, dictionary, string);
        if (n2 == -1) {
            return "";
        }
        return string + "=\"" + n2 + "\" ";
    }

    public String getDefaultValueFormat(RecordFormatter recordFormatter, int n, Dictionary dictionary) {
        String string = (String)dictionary.get("default");
        return string == null ? "" : string;
    }

    public String getEmptyValueFormat(RecordFormatter recordFormatter, int n, Dictionary dictionary) {
        String string = (String)dictionary.get("empty");
        return string == null ? "" : string;
    }

    public String resetValueFormat(RecordFormatter recordFormatter, int n, String string, Dictionary dictionary) {
        if (string == null) {
            string = this.getDefaultValueFormat(recordFormatter, n, dictionary);
        }
        if ("".equals(string)) {
            return this.getEmptyValueFormat(recordFormatter, n, dictionary);
        }
        return string;
    }

    public boolean equals(String string, String string2) {
        return string != null && string.equals(string2);
    }

    private static final class SingletonHolder {
        static final FieldFormatter singleton = new FieldFormatter();

        private SingletonHolder() {
        }
    }
}

